/*
 * Decompiled with CFR 0.152.
 */
package org.gerhardb.jibs.concatenater;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.prefs.Preferences;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JSlider;
import javax.swing.JTextField;
import org.gerhardb.jibs.Jibs;
import org.gerhardb.lib.swing.JFileChooserExtra;
import org.gerhardb.lib.swing.JPanelRows;
import org.gerhardb.lib.swing.SwingUtils;
import org.gerhardb.lib.util.Icons;
import org.gerhardb.lib.util.StopCheckButton;

public class Splitter
extends JFrame {
    public static String APP_NAME = "Splitter";
    private static final String LAST_FILE = "LastFile";
    private static final String LAST_DIR = "LastDir";
    private static final String LAST_MEGS = "LastMegs";
    private static final String READY = "Ready";
    private static final Preferences clsPrefs = Preferences.userRoot().node("/org/gerhardb/jibs/concatenater/splitter");
    JTextField myFileFld = new JTextField(60);
    JTextField myRootDir = new JTextField(60);
    private JSlider myMegsSlider;
    DefaultBoundedRangeModel myRange = new DefaultBoundedRangeModel();
    JProgressBar myBar = new JProgressBar(this.myRange);
    StopCheckButton myStopCheckBtn = new StopCheckButton();

    public Splitter(boolean iExitOnClose) {
        super("Splitter");
        this.myMegsSlider = new JSlider(0, 0, 100, clsPrefs.getInt(LAST_MEGS, 10));
        this.layoutComponents();
        this.myRootDir.setText(clsPrefs.get(LAST_DIR, null));
        this.setIconImage(Icons.icon(26).getImage());
        if (iExitOnClose) {
            this.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent evt) {
                    System.exit(0);
                }
            });
        }
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                Splitter.this.pack();
                SwingUtils.centerOnScreen(Splitter.this);
                Splitter.this.setVisible(true);
            }
        });
    }

    private void layoutComponents() {
        this.myBar.setStringPainted(true);
        this.myBar.setString(READY);
        this.myMegsSlider.setSnapToTicks(true);
        this.myMegsSlider.setPaintLabels(true);
        this.myMegsSlider.setPaintTicks(true);
        this.myMegsSlider.setMajorTickSpacing(10);
        this.myMegsSlider.setMajorTickSpacing(1);
        this.setSize(new Dimension(600, 600));
        JButton goBtn = new JButton("Split");
        goBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Splitter.this.go();
            }
        });
        JButton fileBtn = new JButton("...");
        fileBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Splitter.this.selectFile();
            }
        });
        JButton rootBtn = new JButton("...");
        rootBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Splitter.this.selectRoot();
            }
        });
        JPanelRows topPanel = new JPanelRows(1);
        JPanel aRow = topPanel.topRow();
        aRow.add(new JLabel("Automatically splits files in a sequence like foo.mpg.001, foo.mpg.002 to foo.mpg"));
        aRow = topPanel.nextRow();
        aRow.add(new JLabel(" "));
        aRow = topPanel.nextRow();
        aRow.add(new JLabel("Select the file to split."));
        aRow = topPanel.nextRow();
        aRow.add(new JLabel("File" + Jibs.getString("colon") + " "));
        aRow.add(this.myFileFld);
        aRow.add(fileBtn);
        aRow = topPanel.nextRow();
        aRow.add(new JLabel(" "));
        aRow = topPanel.nextRow(new BorderLayout());
        aRow.add((Component)new JLabel("Megabytes" + Jibs.getString("colon") + " "), "West");
        aRow.add((Component)this.myMegsSlider, "Center");
        aRow = topPanel.nextRow();
        aRow.add(new JLabel(" "));
        aRow = topPanel.nextRow();
        aRow.add(new JLabel("Select the diretory where the split files go."));
        aRow = topPanel.nextRow();
        aRow.add(new JLabel("Directory" + Jibs.getString("colon") + " "));
        aRow.add(this.myRootDir);
        aRow.add(rootBtn);
        aRow = topPanel.nextRow();
        aRow.add(goBtn);
        aRow.add(this.myStopCheckBtn.getStopButton());
        aRow = topPanel.nextRow(new BorderLayout());
        aRow.add((Component)this.myBar, "Center");
        this.setContentPane(topPanel);
    }

    void selectFile() {
        File picked;
        this.myBar.setString(READY);
        JFileChooserExtra chooser = new JFileChooserExtra(clsPrefs.get(LAST_FILE, null));
        chooser.setSaveName(APP_NAME, Jibs.getString("RecreateDirectories.21"));
        chooser.setApproveButtonText(Jibs.getString("RecreateDirectories.22"));
        chooser.setDialogTitle("Select file to split");
        chooser.setFileSelectionMode(2);
        chooser.setMultiSelectionEnabled(false);
        int returnVal = chooser.showOpenDialog(this);
        if (returnVal == 0 && (picked = chooser.getSelectedFile()) != null) {
            this.myFileFld.setText(picked.toString());
            try {
                clsPrefs.put(LAST_FILE, picked.toString());
                clsPrefs.flush();
                if (null == clsPrefs.get(LAST_DIR, null)) {
                    clsPrefs.put(LAST_DIR, picked.getParent().toString());
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    void selectRoot() {
        File picked;
        this.myBar.setString(READY);
        JFileChooserExtra chooser = new JFileChooserExtra(clsPrefs.get(LAST_DIR, null));
        chooser.setSaveName(APP_NAME, Jibs.getString("RecreateDirectories.21"));
        chooser.setApproveButtonText(Jibs.getString("RecreateDirectories.22"));
        chooser.setDialogTitle("Select directory where split files go");
        chooser.setFileSelectionMode(1);
        chooser.setMultiSelectionEnabled(false);
        int returnVal = chooser.showOpenDialog(this);
        if (returnVal == 0 && (picked = chooser.getSelectedFile()) != null) {
            this.myRootDir.setText(picked.toString());
            try {
                clsPrefs.put(LAST_DIR, picked.toString());
                clsPrefs.flush();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    void go() {
        try {
            clsPrefs.putInt(LAST_MEGS, this.myMegsSlider.getValue());
            clsPrefs.flush();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        String rootString = this.myRootDir.getText();
        File rootFile = new File(rootString);
        if (!rootFile.exists()) {
            JOptionPane.showMessageDialog(this, "Directory does not exist: " + rootString, "Problem with Diretory", 0);
            return;
        }
        String fileString = this.myFileFld.getText();
        File fileToSpit = new File(fileString);
        if (!fileToSpit.exists()) {
            JOptionPane.showMessageDialog(this, "File does not exist: " + fileToSpit, "Problem with File", 0);
            return;
        }
        if (this.myMegsSlider.getValue() < 1) {
            JOptionPane.showMessageDialog(this, "Select at least one megabyte", "Problem", 0);
        }
        if (this.myStopCheckBtn.isStopped()) {
            return;
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        try {
            SplitAll sa = new SplitAll(fileToSpit, rootFile, this.myMegsSlider.getValue());
            new Thread(sa).start();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            JOptionPane.showMessageDialog(this, ex.getMessage(), "Splitter", 0);
        }
        this.setCursor(Cursor.getPredefinedCursor(0));
    }

    public static void main(String[] args) {
        new Splitter(true);
    }

    private class SplitAll
    implements Runnable {
        File myFileToSplit;
        File myDirToSplitInto;
        int myMegs;
        int myCount;
        String myBaseFileName;

        SplitAll(File fileToSplit, File dirToSplitInto, int megs) {
            this.myFileToSplit = fileToSplit;
            this.myDirToSplitInto = dirToSplitInto;
            this.myMegs = megs * 1024 * 1024;
            this.myBaseFileName = this.myDirToSplitInto.getAbsolutePath() + System.getProperty("file.separator") + this.myFileToSplit.getName() + ".";
            System.out.println("myMegs: " + this.myMegs);
        }

        private String getNextFileName(DecimalFormat formatter) {
            ++this.myCount;
            String newFileName = this.myBaseFileName + formatter.format(this.myCount);
            System.out.println("New File Name: " + newFileName);
            return newFileName;
        }

        public void run() {
            System.out.println("File to split is: " + this.myFileToSplit);
            System.out.println("Directory to split into is: " + this.myDirToSplitInto);
            int estimatedCount = (int)(this.myFileToSplit.length() / (long)this.myMegs) + 1;
            Splitter.this.myBar.setStringPainted(false);
            Splitter.this.myBar.getModel().setRangeProperties(0, 0, 0, estimatedCount, false);
            String format = "00";
            if (estimatedCount > 99) {
                format = "000";
            } else if (estimatedCount > 999) {
                format = "0000";
            } else if (estimatedCount > 9999) {
                format = "#0000";
            }
            DecimalFormat formatter = new DecimalFormat(format);
            BufferedInputStream in = null;
            FilterOutputStream out = null;
            int written = 0;
            try {
                in = new BufferedInputStream(new FileInputStream(this.myFileToSplit));
                out = new BufferedOutputStream(new FileOutputStream(this.getNextFileName(formatter)));
                byte[] buf = new byte[1024];
                int len = 0;
                while ((len = in.read(buf)) > 0 && !Splitter.this.myStopCheckBtn.isStopped()) {
                    ((BufferedOutputStream)out).write(buf, 0, len);
                    if ((written += len) < this.myMegs) continue;
                    Splitter.this.myBar.setValue(this.myCount);
                    out.close();
                    written = 0;
                    out = new BufferedOutputStream(new FileOutputStream(this.getNextFileName(formatter)));
                }
                Splitter.this.myBar.setValue(this.myCount);
                in.close();
                out.close();
            }
            catch (IOException ex) {
                JOptionPane.showMessageDialog(Splitter.this, ex.getMessage(), "Splitter", 0);
                try {
                    in.close();
                    out.close();
                }
                catch (Exception doubleEx) {
                    doubleEx.printStackTrace();
                }
            }
            Splitter.this.myBar.setStringPainted(true);
            Splitter.this.myBar.setString("Done");
            System.out.println("ALL DONE!!!");
        }
    }
}

