/*
 * Decompiled with CFR 0.152.
 */
package org.gerhardb.jibs.optimizer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import org.gerhardb.jibs.Jibs;
import org.gerhardb.jibs.optimizer.DownloadPanel;
import org.gerhardb.jibs.optimizer.OptimizerPreferences;
import org.gerhardb.lib.dirtree.rdp.RDPplugins;
import org.gerhardb.lib.io.DirListController;
import org.gerhardb.lib.swing.SwingUtils;
import org.gerhardb.lib.util.Icons;
import org.gerhardb.lib.util.Killer;

public class Optimizer
extends JFrame {
    public static String APP_NAME = "Optimizer";
    boolean iExitOnClose;
    DownloadPanel myDownloadPanel;
    DirListController myWorkingList = new DirListController("Working List", Jibs.getString("Optimizer.1"), false, APP_NAME);
    DirListController myStableList = new DirListController("Stable List", Jibs.getString("Optimizer.3"), false, APP_NAME);
    Killer myKiller = new Killer();
    RDPplugins myRDPplugins;

    public Optimizer(File[] files, RDPplugins rdpPlugins) {
        this.myWorkingList.add(files);
        this.myRDPplugins = rdpPlugins;
        this.init(false);
    }

    public Optimizer(boolean exitOnClose, RDPplugins rdpPlugins) {
        this.myRDPplugins = rdpPlugins;
        this.init(exitOnClose);
    }

    void init(boolean exitOnClose) {
        this.iExitOnClose = exitOnClose;
        this.setTitle(Jibs.getString("Optimizer.4"));
        this.setIconImage(Icons.icon(26).getImage());
        try {
            OptimizerPreferences.init();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            JOptionPane.showMessageDialog(this, Jibs.getString("Optimizer.5"), Jibs.getString("Optimizer.6"), 0);
        }
        this.setIconImage(Icons.icon(26).getImage());
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                Optimizer.this.exit();
            }
        });
        this.enableEvents(64L);
        try {
            this.layoutComponents();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println(Jibs.getString("Optimizer.7"));
            System.exit(99);
        }
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                Optimizer.this.validate();
                Optimizer.this.pack();
                SwingUtils.centerOnScreen(Optimizer.this);
                Optimizer.this.setVisible(true);
            }
        });
    }

    private void layoutComponents() throws Exception {
        this.myDownloadPanel = new DownloadPanel(this);
        JTabbedPane jTabbed = new JTabbedPane();
        jTabbed.addTab(Jibs.getString("Optimizer.8"), this.myWorkingList.getPanel());
        jTabbed.addTab(Jibs.getString("Optimizer.9"), this.myStableList.getPanel());
        jTabbed.addTab(Jibs.getString("Optimizer.10"), this.myDownloadPanel);
        JPanel thePanel = new JPanel(new BorderLayout());
        thePanel.add((Component)jTabbed, "Center");
        this.setContentPane(new JScrollPane(thePanel));
    }

    private void exit() {
        this.myKiller.kill();
        OptimizerPreferences.flush();
        if (this.iExitOnClose) {
            System.exit(0);
        } else {
            this.setVisible(false);
            this.dispose();
        }
    }
}

