/*
 * Decompiled with CFR 0.152.
 */
package org.gerhardb.jibs.optimizer;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import org.gerhardb.jibs.Jibs;
import org.gerhardb.jibs.optimizer.Deduper;
import org.gerhardb.jibs.optimizer.NoDirectories;
import org.gerhardb.jibs.optimizer.OptimizerPreferences;
import org.gerhardb.jibs.util.FileLoopHelper;
import org.gerhardb.lib.dirtree.rdp.RDPplugins;
import org.gerhardb.lib.image.IOImage;
import org.gerhardb.lib.image.ImageChangeUtil;
import org.gerhardb.lib.image.ImageFactory;
import org.gerhardb.lib.io.FileUtil;
import org.gerhardb.lib.util.Killer;

public class WorkerDownload
implements Runnable {
    static final String[] ENDINGS = new String[]{"jpg", "jpeg", "j2k", "jif", "jiff", "jp2", "jpe", "jpf", "jpx", "tif", "tiff", "dcm", "fits", "pgm", "bmp", "gif", "apng", "png", "psd", "pnm", "pgm", "pbm", "ppm"};
    Killer myKiller;
    boolean iDedup;
    boolean iAcrossDirectories;
    boolean iRenameUnique;
    boolean iWindows;
    boolean iCleanUpEnding;
    int myStrain;
    boolean iResize;
    boolean iSkipRechecking;
    boolean iOptomize;
    int myWidth;
    int myHeight;
    int myRemovedCount = 0;
    int myMaxSameSize = 0;
    File myParkDir;
    public static final SimpleDateFormat LONG_DATE = new SimpleDateFormat("yyyy.MMMMM.dd HH:mm:ss");
    File[] myWorkingDirs = new File[0];
    File[] myStableDirs = new File[0];
    FileLoopHelper myHelper = null;
    File[] myWorkingFiles;
    int myRelabelCount;
    static final char[] BAD = new char[]{'<', '>', ':', '\"', '\\', '/', '|', '?', '*'};

    private WorkerDownload() {
    }

    public WorkerDownload(File[] workingDirs, File[] stableDirs, boolean dedup, boolean across, boolean rename, boolean windows, boolean cleanUpEnding, int strain, boolean resize, boolean optomize, int width, int height, FileLoopHelper helper, Killer killer, RDPplugins rdpPlugins, boolean skipRechecking) throws Exception {
        if (workingDirs != null) {
            this.myWorkingDirs = workingDirs;
        }
        if (stableDirs != null) {
            this.myStableDirs = stableDirs;
        }
        this.myHelper = helper;
        this.myRelabelCount = OptimizerPreferences.getRelabelNumber();
        this.myHelper.setValue(0);
        this.myHelper.setMaximum(1);
        this.myHelper.setIndeterminate(false);
        this.myHelper.getLog().logLine(Jibs.getString("WorkerDownload.14") + ": ");
        for (int i = 0; i < this.myWorkingDirs.length; ++i) {
            this.myHelper.getLog().logLine("   " + this.myWorkingDirs[i].getAbsolutePath() + "");
        }
        this.iDedup = dedup;
        this.iAcrossDirectories = across;
        this.iRenameUnique = rename;
        this.iWindows = windows;
        this.iCleanUpEnding = cleanUpEnding;
        this.myStrain = strain;
        this.iResize = resize;
        this.iSkipRechecking = skipRechecking;
        this.iOptomize = optomize;
        this.myWidth = width;
        this.myHeight = height;
        this.myKiller = killer;
        String parkDir = rdpPlugins.getPathManager().getDirectoryAbsolute(2);
        if (parkDir != null) {
            this.myParkDir = new File(parkDir);
        }
        this.myHelper.getLog().logLine(Jibs.getString("WorkerDownload.13") + ": ");
        this.myHelper.getLog().logLine("   " + Jibs.getString("WorkerDownload.15") + ": " + this.iDedup + "");
        this.myHelper.getLog().logLine("   " + Jibs.getString("WorkerDownload.19") + ": " + this.iAcrossDirectories + "");
        this.myHelper.getLog().logLine(Jibs.getString("WorkerDownload.11") + ": ");
        switch (this.myStrain) {
            case 0: {
                this.myHelper.getLog().logLine(Jibs.getString("WorkerDownload.23"));
                break;
            }
            case 1: {
                this.myHelper.getLog().logLine("   " + Jibs.getString("WorkerDownload.25"));
                this.myHelper.getLog().logLine("      " + Jibs.getString("WorkerDownload.27") + ": " + ImageFactory.getImageFactory().getFilter() + "");
                this.myHelper.getLog().logLine("      " + Jibs.getString("WorkerDownload.31") + ": ");
                if (parkDir != null) {
                    this.myHelper.getLog().logLine(parkDir + "");
                    break;
                }
                this.myHelper.getLog().logLine(Jibs.getString("WorkerDownload.34"));
                break;
            }
            case 2: {
                this.myHelper.getLog().logLine("   " + Jibs.getString("WorkerDownload.36"));
                this.myHelper.getLog().logLine("      " + Jibs.getString("WorkerDownload.38") + Jibs.getString("colon") + ImageFactory.getImageFactory().getFilter() + "");
            }
        }
        this.myHelper.getLog().logLine(Jibs.getString("WorkerDownload.41") + ": ");
        this.myHelper.getLog().logLine("   " + Jibs.getString("WorkerDownload.44") + ": " + this.iRenameUnique + "");
        this.myHelper.getLog().logLine("      " + Jibs.getString("WorkerDownload.48") + ": " + "-jibs" + "");
        this.myHelper.getLog().logLine("");
        this.myHelper.getLog().logLine("      " + Jibs.getString("WorkerDownload.53") + ": " + this.myRelabelCount + "");
        this.myHelper.getLog().logLine("   " + Jibs.getString("WorkerDownload.57") + ": " + this.iWindows + "");
        this.myHelper.getLog().logLine("   " + Jibs.getString("WorkerDownload.61") + ": " + this.iCleanUpEnding + "");
        this.myHelper.getLog().logLine(Jibs.getString("WorkerDownload.64") + ": ");
        this.myHelper.getLog().logLine("   " + Jibs.getString("WorkerDownload.67") + ": " + this.iResize + "");
        this.myHelper.getLog().logLine("   " + Jibs.getString("WorkerDownload.71") + ": " + this.myWidth + "");
        this.myHelper.getLog().logLine("   " + Jibs.getString("WorkerDownload.75") + ": " + this.myHeight + "");
        this.myHelper.getLog().logLine(Jibs.getString("WorkerDownload.78") + ": ");
        this.myHelper.getLog().logLine("   " + Jibs.getString("WorkerDownload.81") + ": " + this.iOptomize + "");
    }

    boolean iDoSomeThingBesidesDedup() {
        return this.iRenameUnique || this.iWindows || this.iCleanUpEnding || this.myStrain != 0 || this.iResize || this.iOptomize;
    }

    public void run() {
        this.myHelper.getLog().logLine("===========================================================================================");
        Date startDate = new Date();
        this.myHelper.getLog().logLine(Jibs.getString("WorkerDownload.88") + ": " + LONG_DATE.format(startDate) + "");
        this.myHelper.getLabel().setText(Jibs.getString("WorkerDownload.91"));
        if (this.iAcrossDirectories || this.iDoSomeThingBesidesDedup() || this.myStableDirs.length > 0) {
            ArrayList outList = this.myHelper.getFilesFromDirectories(this.myWorkingDirs);
            this.myWorkingFiles = outList.toArray(new File[outList.size()]);
        }
        if (this.iDedup && this.myKiller.live()) {
            this.dedup();
        }
        if (this.myKiller.live() && this.iDoSomeThingBesidesDedup()) {
            this.myHelper.getLog().logLine("===========================================================================================");
            this.myHelper.getLog().logLine(Jibs.getString("WorkerDownload.92") + ": " + this.myWorkingFiles.length + "");
            this.myHelper.setValue(0);
            this.myHelper.setMaximum(this.myWorkingFiles.length - 1);
            for (int i = 0; i < this.myWorkingFiles.length && !this.myKiller.die(); ++i) {
                this.myHelper.setValue(i);
                int count = i + 1;
                String progress = Jibs.getString("WorkerDownload.95") + " " + count + " " + Jibs.getString("WorkerDownload.97") + " " + this.myWorkingFiles.length;
                this.myHelper.getLabel().setText(progress);
                if (this.myWorkingFiles[i] == null) continue;
                this.processIndex(i);
                this.myWorkingFiles[i] = null;
            }
            this.myHelper.getLog().logLine("===========================================================================================");
            this.myHelper.getLog().logLine(Jibs.getString("WorkerDownload.98") + " " + this.myWorkingFiles.length + " " + Jibs.getString("WorkerDownload.99"));
        }
        this.summary();
        Date stopDate = new Date();
        this.myHelper.getLog().logLine(Jibs.getString("WorkerDownload.100") + ": " + LONG_DATE.format(stopDate) + "");
        long seconds = (stopDate.getTime() - startDate.getTime()) / 1000L;
        this.myHelper.getLog().logLine(Jibs.getString("WorkerDownload.103") + ": " + seconds + "");
        this.myHelper.getLabel().setText(Jibs.getString("WorkerDownload.106"));
        try {
            this.myHelper.getLog().close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.myHelper.updateCountField();
        try {
            OptimizerPreferences.setRelabelNumber(this.myHelper.getRelableCount());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.myKiller.dead();
        this.myHelper.done();
    }

    void dedup() {
        Date startTime = new Date();
        Deduper deduper = new Deduper(this.myHelper, this.myStableDirs, this.myKiller);
        this.myHelper.getLabel().setText(Jibs.getString("WorkerDownload.107"));
        if (!deduper.setWorking(this.myWorkingFiles)) {
            this.myHelper.getLog().logLine(Jibs.getString("WorkerDownload.108"));
            this.myHelper.getLog().logLine("===========================================================================================");
            return;
        }
        if (this.myStableDirs.length > 0) {
            deduper.dedupStable();
        }
        if (this.iAcrossDirectories) {
            this.myHelper.getLog().logLine(Jibs.getString("WorkerDownload.109"));
            this.myHelper.getLabel().setText(Jibs.getString("WorkerDownload.110"));
            deduper.dedupWorking();
        } else {
            this.myHelper.getLog().logLine(Jibs.getString("WorkerDownload.111"));
            this.myHelper.getLog().logLine(Jibs.getString("WorkerDownload.112") + Jibs.getString("colon") + " " + this.myWorkingDirs.length + "");
            NoDirectories noDirectories = new NoDirectories();
            for (int i = 0; i < this.myWorkingDirs.length && !this.myKiller.die(); ++i) {
                String progress = Jibs.getString("WorkerDownload.114") + i + ": " + this.myWorkingDirs[i];
                this.myHelper.getLabel().setText(progress);
                this.myHelper.getLog().logLine(progress);
                File[] dedupThese = this.myWorkingDirs[i].listFiles(noDirectories);
                if (!deduper.setWorking(dedupThese)) continue;
                deduper.dedupWorking();
            }
        }
        Date stopTime = new Date();
        this.myRemovedCount = deduper.getRemovedCount();
        this.myMaxSameSize = deduper.getMaxSameSize();
        this.myHelper.getLog().logLine(Jibs.getString("WorkerDownload.116"));
        this.myHelper.getLog().logLine(this.myRemovedCount + " " + Jibs.getString("WorkerDownload.117"));
        this.myHelper.getLog().logTime(Jibs.getString("WorkerDownload.118"), startTime, stopTime);
        this.myHelper.getLog().logLine(Jibs.getString("WorkerDownload.119") + ": " + this.myMaxSameSize + System.getProperty("line.separator"));
        this.myHelper.getLog().logLine("===========================================================================================");
    }

    void summary() {
        this.myHelper.getLog().logLine(this.myRemovedCount + " " + Jibs.getString("WorkerDownload.8"));
        this.myHelper.getLog().logLine(Jibs.getString("WorkerDownload.123") + ": " + this.myMaxSameSize + System.getProperty("line.separator"));
        try {
            OptimizerPreferences.setRelabelNumber(this.myRelabelCount);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    void processIndex(int index) {
        if (this.myWorkingFiles[index] == null) {
            return;
        }
        if (this.iSkipRechecking && FileLoopHelper.alreadyProcessed(this.myWorkingFiles[index].getName())) {
            return;
        }
        if (this.myStrain != 0 && !ImageFactory.getImageFactory().getFilter().accept(this.myWorkingFiles[index])) {
            this.moveOrDelete(this.myWorkingFiles[index]);
            return;
        }
        if (this.iRenameUnique || this.iWindows || this.iCleanUpEnding) {
            File oldName = this.myWorkingFiles[index];
            this.myWorkingFiles[index] = this.rename(this.myWorkingFiles[index]);
            if (!oldName.equals(this.myWorkingFiles[index])) {
                this.myHelper.getLog().logLine("   " + Jibs.getString("WorkerDownload.6") + ": " + oldName.getAbsolutePath() + "\n      " + Jibs.getString("WorkerDownload.3") + ": " + this.myWorkingFiles[index].getAbsolutePath() + "\n");
            }
        }
        if (this.myStrain != 0 || this.iResize || this.iOptomize) {
            this.doFileOperations(this.myWorkingFiles[index]);
        }
        this.myWorkingFiles[index] = null;
    }

    private void doFileOperations(File theFile) {
        BufferedImage originalImage = null;
        IOImage goodImg = ImageFactory.getImageFactory().makeImageEZ(theFile);
        if (goodImg != null) {
            try {
                originalImage = goodImg.getImage();
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        if (goodImg == null || originalImage == null) {
            if (this.myStrain != 0) {
                this.moveOrDelete(theFile);
            }
            return;
        }
        if (this.iResize || this.iOptomize) {
            long startLength = theFile.length();
            BufferedImage saveImg = null;
            try {
                if (this.iResize && (saveImg = ImageChangeUtil.resizeImageDown(originalImage, this.myWidth, this.myHeight)) != null) {
                    this.myHelper.getLog().logLine("   " + Jibs.getString("WorkerDownload.132") + ": " + theFile.getAbsolutePath());
                }
                if (saveImg == null && this.iOptomize && (saveImg = ImageChangeUtil.scale(originalImage, 1.0f)) != null) {
                    this.myHelper.getLog().logLine("   " + Jibs.getString("WorkerDownload.136") + ": " + theFile.getAbsolutePath());
                }
                if (saveImg != null) {
                    goodImg.save(saveImg);
                }
                long endLength = theFile.length();
                this.myHelper.getLog().logLine("  Size from " + startLength + " to " + endLength + " reduced by " + (startLength - endLength));
            }
            catch (Exception ex) {
                ex.printStackTrace();
                this.myHelper.getLog().logLine("   " + Jibs.getString("WorkerDownload.140") + ": " + theFile.getAbsolutePath() + "\n");
            }
        }
    }

    private File rename(File currFile) {
        File rtnMe = currFile;
        if (this.iRenameUnique) {
            rtnMe = this.myHelper.renameUnique(rtnMe);
        }
        if (this.iCleanUpEnding) {
            rtnMe = this.cleanUpEnding(rtnMe);
        }
        if (this.iWindows) {
            rtnMe = this.windowsCleanup(rtnMe);
        }
        return rtnMe;
    }

    private void moveOrDelete(File currFile) {
        switch (this.myStrain) {
            case 0: {
                break;
            }
            case 1: {
                try {
                    FileUtil.moveFile(this.myParkDir, currFile, null, this.myHelper.getLog(), true);
                    this.myHelper.getLog().logLine("   " + Jibs.getString("WorkerDownload.144") + ": " + currFile.getAbsolutePath() + "\n");
                }
                catch (Exception ex) {
                    this.myHelper.getLog().logLine("   " + Jibs.getString("WorkerDownload.0") + ": " + ex.getMessage() + "\n");
                }
                break;
            }
            case 2: {
                if (currFile.delete()) {
                    this.myHelper.getLog().logLine("   " + Jibs.getString("WorkerDownload.152") + ": " + currFile.getAbsolutePath() + "\n");
                    break;
                }
                this.myHelper.getLog().logLine("   " + Jibs.getString("WorkerDownload.156") + ": " + currFile.getAbsolutePath() + "\n");
            }
        }
    }

    boolean isGood(char aCharacter) {
        if (aCharacter < ' ') {
            return false;
        }
        for (int i = 0; i < BAD.length; ++i) {
            if (aCharacter != BAD[i]) continue;
            return false;
        }
        return true;
    }

    boolean isNameGood(File file) {
        char[] oldName = file.getName().toCharArray();
        for (int i = 0; i < oldName.length; ++i) {
            if (this.isGood(oldName[i])) continue;
            return false;
        }
        return true;
    }

    File windowsCleanup(File file) {
        if (this.isNameGood(file)) {
            return file;
        }
        StringBuffer buff = new StringBuffer();
        try {
            buff.append(new File(file.getParent()).getCanonicalPath());
        }
        catch (IOException x) {
            return file;
        }
        buff.append(File.separatorChar);
        char[] oldName = file.getName().toCharArray();
        for (int i = 0; i < oldName.length; ++i) {
            if (this.isGood(oldName[i])) {
                buff.append(oldName[i]);
                continue;
            }
            buff.append('_');
        }
        File newFile = new File(buff.toString());
        if (!file.equals(newFile)) {
            if (newFile.exists()) {
                this.myHelper.getLog().logLine(Jibs.getString("WorkerDownload.164") + ": " + newFile + "\n");
            } else {
                file.renameTo(newFile);
                return newFile;
            }
        }
        return file;
    }

    /*
     * Enabled aggressive block sorting
     */
    File cleanUpEnding(File file) {
        String name = file.getName();
        int lastPeriod = name.lastIndexOf(46);
        if (lastPeriod < 1) {
            return file;
        }
        String front = name.substring(0, lastPeriod);
        String back = name.substring(lastPeriod + 1);
        String backProblem = back.toLowerCase();
        boolean changeEnding = false;
        for (int i = 0; i < ENDINGS.length; ++i) {
            if (backProblem.indexOf(ENDINGS[i]) <= -1) continue;
            if (backProblem.equals(ENDINGS[i])) {
                return file;
            }
            back = ENDINGS[i];
            changeEnding = true;
            break;
        }
        if (!changeEnding) {
            System.out.println("No Change: Could not find ending.  This message should never appear.");
            return file;
        }
        String newName = file.getParent() + File.separator + front + "." + back;
        File newFile = new File(newName);
        if (newFile.exists()) {
            this.myHelper.getLog().logLine(Jibs.getString("WorkerDownload.161") + ": " + newFile + "\n");
            return file;
        }
        file.renameTo(newFile);
        return newFile;
    }

    public static void main(String[] args) {
        WorkerDownload wd = new WorkerDownload();
        System.out.println(wd.isNameGood(new File("c:/pics/ann.txt")));
        System.out.println(wd.isNameGood(new File("c:/pics/a>n.txt")));
    }
}

