/*
 * Decompiled with CFR 0.152.
 */
package org.gerhardb.jibs.textPad;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.tree.TreePath;
import org.gerhardb.jibs.Jibs;
import org.gerhardb.jibs.textPad.TextPadActions;
import org.gerhardb.jibs.textPad.TextPadOptionsDialog;
import org.gerhardb.lib.dirtree.ExtendedDirectoryTreePopUp;
import org.gerhardb.lib.dirtree.rdp.BasicOptionsManager;
import org.gerhardb.lib.dirtree.rdp.IListShowTree;
import org.gerhardb.lib.dirtree.rdp.ILoad;
import org.gerhardb.lib.dirtree.rdp.ListShowTreeCoordinator;
import org.gerhardb.lib.io.FilenameFileFilter;
import org.gerhardb.lib.playlist.ScrollerChangeEvent;
import org.gerhardb.lib.playlist.ScrollerListener;
import org.gerhardb.lib.playlist.ScrollerSlider;
import org.gerhardb.lib.swing.JFileChooserExtra;
import org.gerhardb.lib.swing.SwingUtils;
import org.gerhardb.lib.swing.UIMenu;
import org.gerhardb.lib.util.ActionHelpers;
import org.gerhardb.lib.util.Icons;
import org.gerhardb.lib.util.app.InfoPlugins;
import org.gerhardb.lib.util.startup.AppStarter;
import org.gerhardb.lib.util.startup.Loading;

public class TextPad
extends JFrame
implements ScrollerListener,
IListShowTree,
InfoPlugins,
ILoad {
    private static final String LAST_FILE = "LastFile";
    private static final String[] FILE_NAME_ENDINGS = new String[]{".txt", ".htm", ".html"};
    static final String COUNT_TEXT_FILES = "COUNT_TEXT_FILES";
    private static final String FILE_PANEL_SIZE = "ListPicturePanelDividerLocation";
    private static final String TREE_PANEL_SIZE = "TreePanelSize";
    public static final int TREE_MIN = 100;
    public static final int FILE_MIN = 1000;
    static final Preferences clsPrefs = Preferences.userRoot().node("/org/gerhardb/jibs/textPad/TextPad");
    JEditorPane myEditorPane = new JEditorPane();
    private JSplitPane myListPanel = new JSplitPane(1);
    private JSplitPane myTreePanel = new JSplitPane(1);
    TextPadActions myActions;
    JToolBar myToolBar = new JToolBar();
    private ScrollerSlider mySlider;
    UIMenu myUImenu = new UIMenu(this, this.getAppIDandTargetType());
    boolean iExitOnClose;
    boolean iNeedToFinalize = true;
    ListShowTreeCoordinator myLST;
    Loading myLoading = new Loading(this);

    public TextPad(boolean exitOnClose) {
        this.iExitOnClose = exitOnClose;
        this.myLST = new ListShowTreeCoordinator(this);
        this.myLST.init(this);
        this.myActions = new TextPadActions(this);
        this.myLST.addActions(this.myActions);
        this.buildAndDisplayInterface();
        File loadFile = new File(this.myLST.getPathManager().getDirectoryAbsolute(0));
        this.myLST.load(loadFile, this.myLoading, this, Thread.currentThread());
    }

    public ListShowTreeCoordinator getLST() {
        return this.myLST;
    }

    public void info(StringBuffer sb) {
    }

    public String getAppIDandTargetType() {
        return "Text";
    }

    public JFrame getTopFrame() {
        return this;
    }

    public ScrollerListener getScrollerListener() {
        return this;
    }

    public FilenameFileFilter getFilenameFileFilter() {
        return new FilenameFileFilter(FILE_NAME_ENDINGS);
    }

    public boolean getCountTargetFiles() {
        return clsPrefs.getBoolean(COUNT_TEXT_FILES, true);
    }

    public void showFile(File file) {
        if (file == null || !file.exists()) {
            return;
        }
        String url = file.toURI().toString();
        try {
            this.myEditorPane.setPage(url);
            this.myEditorPane.setCaretPosition(0);
        }
        catch (Exception ex) {
            System.out.println("Can't find file: " + url);
            ex.printStackTrace();
        }
    }

    public JPopupMenu getPopupMenu(TreePath path) {
        return new ExtendedDirectoryTreePopUp(this.myLST.getTree(), path, this.getCountTargetFiles());
    }

    public void scrollerChanged(ScrollerChangeEvent ce) {
        this.showFile(this.myLST.getScroller().getCurrentFile());
    }

    public void awtComplete() {
        this.showDefaultDirectory();
        this.myLoading.dispose();
        this.myLoading = null;
        System.out.println("\n**************************************************** \n*         JIBS Background Population Ended         * \n**************************************************** \n");
    }

    private void buildAndDisplayInterface() {
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                TextPad.this.exit();
            }
        });
        this.setIconImage(Icons.icon(26).getImage());
        this.setupToolBar();
        this.mySlider = new ScrollerSlider(1, this.myLST.getScroller());
        this.mySlider.setInverted(true);
        this.mySlider.applyComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
        Dimension size = new Dimension(700, 400);
        this.setSize(size);
        this.setTitle("JIBS TextPad");
        this.myEditorPane.setEditable(false);
        this.myEditorPane.setDisabledTextColor(Color.black);
        this.myEditorPane.setEditorKit(JEditorPane.createEditorKitForContentType("text/html"));
        JScrollPane center = new JScrollPane(this.myEditorPane, 20, 31);
        this.myTreePanel.setLeftComponent(center);
        this.myTreePanel.setRightComponent(new JScrollPane(this.myLST.getExtendedDirectoryTree()));
        JPanel sliders = new JPanel(new BorderLayout());
        sliders.add((Component)new JScrollPane(this.myLST.getFileList()), "Center");
        sliders.add((Component)new JScrollPane(this.mySlider), "West");
        this.myListPanel.setLeftComponent(sliders);
        this.myListPanel.setRightComponent(this.myTreePanel);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.myToolBar, "North");
        this.getContentPane().add((Component)this.myListPanel, "Center");
        this.getContentPane().add((Component)this.myLST.getStatusBarManager().getStatusPanel(), "South");
        this.setJMenuBar(this.makeMenus());
        this.myUImenu.initLookAndFeel();
        SwingUtils.sizeScreen(this, 0.75f);
        this.validate();
        this.myListPanel.setDividerLocation(clsPrefs.getInt(FILE_PANEL_SIZE, 1000));
        this.myTreePanel.setDividerLocation(clsPrefs.getInt(TREE_PANEL_SIZE, 100));
        SwingUtils.centerOnScreen(this);
        super.setVisible(true);
    }

    void setupToolBar() {
        this.myToolBar.add(this.myLST.getRDPmanager().getMoveManager().getUndoButton());
        this.myToolBar.add(this.myLST.getRDPmanager().getMoveManager().getRedoButton());
        this.myToolBar.addSeparator();
        this.myLST.getFileListManager().addButtonsToToolBar(this.myToolBar, this.myActions);
        this.myToolBar.add(this.myActions.getToolBarButton("view", "reload"));
        this.myToolBar.addSeparator();
        this.myToolBar.addSeparator();
        this.myToolBar.add(Box.createHorizontalGlue());
        this.myLST.getRDPmanager().addButtonsToToolbar(this.myToolBar);
        this.myToolBar.addSeparator();
        this.myToolBar.add(this.myActions.getToolBarButton("help", "about"));
        this.myToolBar.add(this.myActions.getToolBarButton("help", "help"));
    }

    void exit() {
        if (this.iNeedToFinalize) {
            this.iNeedToFinalize = false;
            clsPrefs.putInt(FILE_PANEL_SIZE, this.myListPanel.getDividerLocation());
            clsPrefs.putInt(TREE_PANEL_SIZE, this.myTreePanel.getDividerLocation());
            try {
                clsPrefs.flush();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            this.myLST.storeDirectories();
            this.myLST.getPathManager().flush();
            System.out.println("**************************************************** \n*           JIBS Text Pad Exited Normally          * \n**************************************************** \n");
            System.out.println("JIBS OUT");
            AppStarter.closeDownApp();
            if (this.iExitOnClose) {
                System.exit(0);
            } else {
                this.setVisible(false);
                this.dispose();
            }
        }
    }

    void open() {
        String fileName = this.myLST.getTreeManager().getDTNReaderWriter().getFileName();
        JFileChooserExtra chooser = new JFileChooserExtra(clsPrefs.get(LAST_FILE, null));
        chooser.setSaveName(this.getAppIDandTargetType(), fileName);
        chooser.setDialogTitle(Jibs.getString("RecreateDirectories.20") + fileName);
        chooser.setFileSelectionMode(0);
        chooser.setMultiSelectionEnabled(false);
        int returnVal = chooser.showOpenDialog(this);
        if (returnVal == 0) {
            File picked = chooser.getSelectedFile();
            if (picked == null || !picked.exists()) {
                return;
            }
            try {
                clsPrefs.put(LAST_FILE, picked.toString());
                clsPrefs.flush();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            this.showFile(picked);
        }
    }

    JMenuBar makeMenus() {
        JMenu toolsMenu = new JMenu("Tools");
        JMenuItem options = new JMenuItem("Options");
        toolsMenu.add(options);
        class OptionsAction
        extends AbstractAction {
            OptionsAction() {
            }

            public void actionPerformed(ActionEvent e) {
                new TextPadOptionsDialog(TextPad.this);
            }
        }
        options.addActionListener(new OptionsAction());
        JMenuBar menuBar = new JMenuBar();
        menuBar.add(this.myActions.getFileMenu());
        menuBar.add(this.myActions.getEditMenu());
        menuBar.add(this.myLST.getSortManager().getSortMenu());
        menuBar.add(this.myActions.getViewMenu());
        menuBar.add(toolsMenu);
        menuBar.add(this.myUImenu.populateUIMenu(ActionHelpers.makeMenu("ui")));
        menuBar.add(Box.createHorizontalGlue());
        menuBar.add(this.myActions.getHelpMenu());
        return menuBar;
    }

    private void showDefaultDirectory() {
        String dir = null;
        BasicOptionsManager bom = this.myLST.getBasicOptionsManager();
        switch (bom.getStartType()) {
            case 2: {
                dir = this.myLST.getPathManager().getDirectoryAbsolute(3);
                try {
                    this.myLST.getFileListManager().setTargetDir(this.myLST.getPathManager().getDirectoryAbsolute(3));
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                break;
            }
            case 1: {
                dir = this.myLST.getPathManager().getDirectoryAbsolute(4);
                break;
            }
        }
        try {
            if (dir != null) {
                this.myLST.getFileListManager().setTargetDir(dir);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void main(String[] args) {
        AppStarter.starupApp(args, "org.gerhardb.jibs.Jibs", true);
        new TextPad(true);
    }
}

