/*
 * Decompiled with CFR 0.152.
 */
package org.gerhardb.jibs.viewer.sorter;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractAction;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.gerhardb.jibs.Jibs;
import org.gerhardb.jibs.viewer.ViewerPreferences;
import org.gerhardb.jibs.viewer.frame.SortScreen;
import org.gerhardb.jibs.viewer.sorter.TilePanel;
import org.gerhardb.lib.swing.JPanelRows;
import org.gerhardb.lib.swing.SwingUtils;

public class SorterDialog
extends JDialog {
    SortScreen mySortScreen;
    JSlider mySizeSlider = new JSlider(0, 80, 400, 100);

    public SorterDialog(SortScreen ss) {
        super(ss, Jibs.getString("SorterDialog.0"), true);
        this.mySortScreen = ss;
        this.layoutScreen();
    }

    void adjustSize() {
        int size = this.mySizeSlider.getValue();
        ViewerPreferences.setSorterTileSize(size);
        TilePanel.clsTilePanel.setTileSize(size);
        this.mySortScreen.validate();
    }

    void ok() {
        this.adjustSize();
        this.setVisible(false);
        this.dispose();
        this.mySortScreen.getShow().showImage();
    }

    private void layoutScreen() {
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                SorterDialog.this.cancel();
            }
        });
        JButton okBtn = new JButton(Jibs.getString("ok"));
        okBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                SorterDialog.this.ok();
            }
        });
        this.mySizeSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent event) {
                SorterDialog.this.adjustSize();
            }
        });
        this.mySizeSlider.setSnapToTicks(true);
        this.mySizeSlider.setPaintLabels(true);
        this.mySizeSlider.setPaintTicks(true);
        this.mySizeSlider.setMajorTickSpacing(20);
        this.mySizeSlider.setMinorTickSpacing(10);
        this.mySizeSlider.setValue(ViewerPreferences.getSorterTileSize());
        this.mySizeSlider.setPreferredSize(new Dimension(500, 50));
        JPanelRows thePanel = new JPanelRows(1);
        JPanel row = thePanel.topRow();
        row.add(new JLabel(Jibs.getString("SorterDialog.1")));
        row.add(this.mySizeSlider);
        row = thePanel.nextRow();
        row.add(okBtn);
        this.addAccelerators(okBtn, thePanel);
        this.getContentPane().add(thePanel);
        this.pack();
        SwingUtils.centerOnScreen(this);
        this.setVisible(true);
    }

    void addAccelerators(JButton okBtn, JPanel thePanel) {
        InputMap map = null;
        this.getRootPane().setDefaultButton(okBtn);
        okBtn.setMnemonic(75);
        class Dismiss
        extends AbstractAction {
            Dismiss() {
                super("dismiss");
            }

            public void actionPerformed(ActionEvent e) {
                SorterDialog.this.cancel();
            }
        }
        Dismiss dismiss = new Dismiss();
        String cancelID = "dismiss";
        thePanel.getActionMap().put(cancelID, dismiss);
        map = thePanel.getInputMap(1);
        map.put(KeyStroke.getKeyStroke(27, 0), cancelID);
    }

    void cancel() {
        this.setVisible(false);
        this.dispose();
    }
}

