/*
 * Decompiled with CFR 0.152.
 */
package org.gerhardb.jibs.viewer.sorter;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.gerhardb.jibs.Jibs;
import org.gerhardb.jibs.viewer.ViewerPreferences;
import org.gerhardb.jibs.viewer.frame.SortScreen;
import org.gerhardb.jibs.viewer.sorter.SorterDialog;
import org.gerhardb.jibs.viewer.sorter.Tile;
import org.gerhardb.jibs.viewer.sorter.TilePanel;
import org.gerhardb.lib.dirtree.filelist.popup.FileNameChanger;
import org.gerhardb.lib.io.ZipDialog;

public class SorterPanel
extends JPanel {
    SortScreen mySortScreen;
    JScrollPane myScrollPane = new JScrollPane(TilePanel.clsTilePanel);
    JPanel myMainPanel = new JPanel(new BorderLayout());

    public SorterPanel(SortScreen ss) {
        TilePanel.clsSortScreen = this.mySortScreen = ss;
        this.setLayout(new BorderLayout());
        this.myScrollPane.setHorizontalScrollBarPolicy(32);
        this.myScrollPane.setVerticalScrollBarPolicy(20);
        TilePanel.clsHorizontalScrollBar = this.myScrollPane.getHorizontalScrollBar();
        JButton btnZip = new JButton(Jibs.getString("SorterPanel.0"));
        btnZip.setToolTipText(Jibs.getString("SorterPanel.1"));
        btnZip.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                File[] fileList = TilePanel.clsTilePanel.getFiles();
                new ZipDialog(SorterPanel.this.mySortScreen, fileList, SorterPanel.this.mySortScreen.getScroller());
            }
        });
        JButton btnRename = new JButton(Jibs.getString("SorterPanel.2"));
        btnRename.setToolTipText(Jibs.getString("SorterPanel.3"));
        btnRename.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                File[] fileList = TilePanel.clsTilePanel.getFiles();
                FileNameChanger fnc = new FileNameChanger(fileList);
                fnc.showDialog(SorterPanel.this.mySortScreen, SorterPanel.this.mySortScreen.getExtendedDirectoryTree(), false, true);
                if (fnc.ran()) {
                    File[] updatedList = fnc.getChangedNames();
                    SorterPanel.this.mySortScreen.getShow().reloadScroller();
                    TilePanel.clsTilePanel.clearTiles();
                    int position = 0;
                    for (int i = 0; i < updatedList.length; ++i) {
                        if (updatedList[i] == null) continue;
                        new Tile(position, updatedList[i]);
                        ++position;
                    }
                    new Tile();
                }
            }
        });
        JButton btnClear = new JButton(Jibs.getString("SorterPanel.4"));
        btnClear.setToolTipText(Jibs.getString("SorterPanel.5"));
        btnClear.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                TilePanel.clsTilePanel.clearTiles();
                new Tile();
                SorterPanel.this.mySortScreen.getScroller().refreshCurrentImage();
            }
        });
        JButton btnOptions = new JButton(Jibs.getString("SorterPanel.6"));
        btnOptions.setToolTipText(Jibs.getString("SorterPanel.7"));
        btnOptions.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                new SorterDialog(SorterPanel.this.mySortScreen);
            }
        });
        JPanel buttonPanel = new JPanel(new GridLayout(4, 1));
        buttonPanel.add(btnZip);
        buttonPanel.add(btnRename);
        buttonPanel.add(btnClear);
        buttonPanel.add(btnOptions);
        this.myMainPanel.add((Component)buttonPanel, "West");
        this.myMainPanel.add((Component)this.myScrollPane, "Center");
        new Tile();
        if (ViewerPreferences.isShowSorterShowing()) {
            this.add(this.myMainPanel);
        }
    }

    public void flipSorter() {
        if (ViewerPreferences.isShowSorterShowing()) {
            ViewerPreferences.setShowSorterShowing(false);
            ViewerPreferences.flush();
            this.hideSorter();
        } else {
            ViewerPreferences.setShowSorterShowing(true);
            ViewerPreferences.flush();
            this.showSorter();
        }
    }

    private void showSorter() {
        this.add(this.myMainPanel);
        this.mySortScreen.gotoRegularScreen();
    }

    private void hideSorter() {
        super.removeAll();
        this.mySortScreen.gotoRegularScreen();
    }
}

