/*
 * Decompiled with CFR 0.152.
 */
package org.gerhardb.jibs.viewer.sorter;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.io.File;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import org.gerhardb.jibs.viewer.ViewerPreferences;
import org.gerhardb.jibs.viewer.frame.SortScreen;
import org.gerhardb.jibs.viewer.sorter.Tile;

public class TilePanel
extends JPanel {
    public static TilePanel clsTilePanel = new TilePanel();
    static int clsTileSize = ViewerPreferences.getSorterTileSize();
    static Dimension clsTileSizeDim = new Dimension(clsTileSize, clsTileSize);
    static SortScreen clsSortScreen;
    static JScrollBar clsHorizontalScrollBar;

    TilePanel() {
        super(new FlowLayout(0));
    }

    public void clip(File file, Graphics2D g2, int width, int height) {
        if (this.isFileInList(file)) {
            g2.setColor(Color.cyan);
            BasicStroke stroke = new BasicStroke(4.0f);
            g2.setStroke(stroke);
            int southEast = height / 6;
            int northWest = width - width / 6;
            Polygon poly = new Polygon();
            poly.addPoint(width, 0);
            poly.addPoint(width, southEast);
            poly.addPoint(northWest, 0);
            g2.fillPolygon(poly);
        }
    }

    private boolean isFileInList(File testFile) {
        if (testFile == null) {
            return false;
        }
        Component[] tiles = super.getComponents();
        for (int i = 0; i < tiles.length; ++i) {
            File aFile = ((Tile)tiles[i]).myFile;
            if (!testFile.equals(aFile)) continue;
            return true;
        }
        return false;
    }

    File[] getFiles() {
        Component[] tiles = super.getComponents();
        File[] rtnMe = new File[tiles.length];
        for (int i = 0; i < tiles.length; ++i) {
            rtnMe[i] = ((Tile)tiles[i]).myFile;
        }
        return rtnMe;
    }

    void clearTiles() {
        this.removeAll();
        super.repaint();
    }

    void setTileSize(int size) {
        clsTileSize = size;
        clsTileSizeDim = new Dimension(clsTileSize, clsTileSize);
        File[] oldFiles = this.getFiles();
        clsTilePanel.removeAll();
        int position = 0;
        for (int i = 0; i < oldFiles.length; ++i) {
            if (oldFiles[i] == null) continue;
            new Tile(position, oldFiles[i]);
            ++position;
        }
        new Tile();
        super.repaint();
    }
}

