/*
 * Decompiled with CFR 0.152.
 */
package org.gerhardb.lib.dirtree.filelist;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import javax.swing.ListSelectionModel;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import org.gerhardb.jibs6.Jibs6Hacks;
import org.gerhardb.lib.dirtree.DTNFile;
import org.gerhardb.lib.dirtree.ExtendedDirectoryTree;
import org.gerhardb.lib.dirtree.filelist.FileDrag;
import org.gerhardb.lib.dirtree.filelist.FileListPlugins;
import org.gerhardb.lib.dirtree.filelist.FileListSelectionModel;
import org.gerhardb.lib.dirtree.filelist.popup.FileNameChanger;
import org.gerhardb.lib.playlist.ScrollerChangeEvent;
import org.gerhardb.lib.playlist.ScrollerListener;
import org.gerhardb.lib.util.Range;
import org.gerhardb.lib.util.startup.AppStarter;

public class FileList
extends JList
implements AncestorListener,
ScrollerListener {
    protected static final Color SHOWING_BACKGROUND = new Color(235, 235, 235);
    protected static Color myDefaultBackground;
    protected boolean isPopulated = false;
    protected Object[] myDragSelections;
    protected int myVisibleAfterDrag = -1;
    private int mySingleMoveResetRecommendation = -1;
    protected FileDrag myFileDrag;
    protected FileListPlugins myPlugins;
    private ExtendedDirectoryTree myExtendedDirectoryTree;

    public FileList(FileListPlugins plugins, ExtendedDirectoryTree edt) {
        this.myPlugins = plugins;
        this.myExtendedDirectoryTree = edt;
        this.myFileDrag = new FileDrag(this);
        this.myPlugins.getScroller().addScrollerListener(this);
        FileRenderer lcr = new FileRenderer();
        myDefaultBackground = lcr.getListCellRendererComponent(this, "", 0, false, false).getBackground();
        super.setCellRenderer(lcr);
        super.addAncestorListener(this);
        super.setMinimumSize(new Dimension(100, 100));
        super.addKeyListener(this.myPlugins.getScroller().getScrollerKeyListener());
        FileListSelectionModel model = new FileListSelectionModel();
        super.setSelectionModel(model);
        this.myPlugins.getScroller().setListSelectionModel(model);
        try {
            if (AppStarter.isJava6Enabled()) {
                Jibs6Hacks.setDropMode((JList)this);
            }
        }
        catch (NoClassDefFoundError ex) {
            // empty catch block
        }
        super.addMouseListener(new AdaptedMouse());
    }

    public FileDrag getTransferable() {
        return this.myFileDrag;
    }

    public Dimension getPreferredSize() {
        Dimension oldSize = super.getPreferredSize();
        return new Dimension(100, (int)oldSize.getHeight());
    }

    public FileListSelectionModel getFileListSelectionModel() {
        return (FileListSelectionModel)this.getSelectionModel();
    }

    public File[] getSelectedFiles() {
        Object[] selected = super.getSelectedValues();
        if (selected.length == 0) {
            return new File[]{this.myPlugins.getScroller().getCurrentFile()};
        }
        File[] files = new File[selected.length];
        for (int i = 0; i < files.length; ++i) {
            files[i] = ((DTNFile)selected[i]).getAbsoluteFile();
        }
        return files;
    }

    public File[] getAllFiles() {
        return this.myPlugins.getScroller().getSortedFiles();
    }

    protected void processMouseEvent(MouseEvent e) {
        boolean letSuperClassProcessEvent = true;
        if (e.getID() == 501 && (e.getModifiersEx() & 0x80) == 0 && (e.getModifiersEx() & 0x40) == 0) {
            int[] picked = this.getSelectedIndices();
            if (picked.length > 0) {
                this.myDragSelections = this.getSelectedValues();
            } else {
                int index;
                Point p = e.getPoint();
                this.mySingleMoveResetRecommendation = index = this.locationToIndex(p);
                Object obj = this.getModel().getElementAt(index);
                Rectangle bounds = this.getCellBounds(index, index);
                if (null != bounds && bounds.contains(p.x, p.y)) {
                    Object[] objArray = new Object[]{obj};
                    this.myDragSelections = objArray;
                }
            }
            this.repaint(this.getBounds());
        }
        if (e.getID() == 502) {
            this.myDragSelections = null;
            this.repaint(this.getBounds());
        }
        if (letSuperClassProcessEvent) {
            super.processMouseEvent(e);
        }
    }

    public void setModel() {
        if (this.isVisible()) {
            this.populate();
        } else {
            this.isPopulated = false;
        }
    }

    public void ancestorAdded(AncestorEvent event) {
        if (!this.isPopulated) {
            this.populate();
        }
    }

    public void ancestorRemoved(AncestorEvent event) {
    }

    public void ancestorMoved(AncestorEvent event) {
    }

    public void scrollerChanged(ScrollerChangeEvent ce) {
        switch (ce.getEventType()) {
            case 2: 
            case 3: {
                super.clearSelection();
            }
        }
        ListSelectionModel model = super.getSelectionModel();
        if (model.isSelectionEmpty()) {
            int index = this.myPlugins.getScroller().getValueZeroBased();
            model.setLeadSelectionIndex(index);
            model.setAnchorSelectionIndex(index);
        }
    }

    public void sliderAdjusted() {
        super.repaint();
        int index = this.myPlugins.getScroller().getValueZeroBased();
        super.ensureIndexIsVisible(index);
        int first = super.getFirstVisibleIndex();
        int last = super.getLastVisibleIndex();
        if (first > -1 && last > 0) {
            int range = last - first;
            int middle = range / 2;
            int show = index + middle - 1;
            super.ensureIndexIsVisible(show);
            show = index - middle + 1;
            super.ensureIndexIsVisible(show);
        }
    }

    public int getResetRecommendation() {
        System.out.println("getResetRecommendation()");
        int rtnMe = this.myVisibleAfterDrag;
        if (rtnMe < 0) {
            rtnMe = this.myPlugins.getScroller().getValueZeroBased();
        }
        if (this.mySingleMoveResetRecommendation > this.myPlugins.getScroller().getMaximumZeroBased()) {
            rtnMe = this.myPlugins.getScroller().getMaximumZeroBased();
        } else if (this.mySingleMoveResetRecommendation > -1) {
            rtnMe = this.mySingleMoveResetRecommendation;
        }
        this.myVisibleAfterDrag = -1;
        this.mySingleMoveResetRecommendation = -1;
        return rtnMe;
    }

    public void updateResetRecommendation() {
        System.out.println("updateResetRecommendation()");
        if (this.mySingleMoveResetRecommendation > -1) {
            return;
        }
        int current = this.myPlugins.getScroller().getValueZeroBased();
        int[] picks = super.getSelectedIndices();
        int newHighIndex = this.myPlugins.getScroller().getMaximumZeroBased() - picks.length;
        if (newHighIndex <= 0 || picks.length < 1) {
            this.myVisibleAfterDrag = 0;
            return;
        }
        if (current < picks[0]) {
            this.myVisibleAfterDrag = current;
            return;
        }
        if (current > picks[picks.length - 1]) {
            this.myVisibleAfterDrag = current - picks.length;
            return;
        }
        this.myVisibleAfterDrag = picks[picks.length - 1] + 1 - picks.length;
        boolean found = false;
        int nextTarget = 0;
        for (int i = 0; i < picks.length; ++i) {
            if (found) {
                if (nextTarget == picks[i]) {
                    ++nextTarget;
                    continue;
                }
                this.myVisibleAfterDrag = nextTarget - i;
                break;
            }
            if (current == picks[i]) {
                found = true;
                nextTarget = current + 1;
                continue;
            }
            if (current >= picks[i]) continue;
            this.myVisibleAfterDrag = current - i;
            break;
        }
        if (this.myVisibleAfterDrag > newHighIndex) {
            this.myVisibleAfterDrag = newHighIndex;
        }
    }

    protected void populate() {
        if (this.myPlugins.getScroller() == null) {
            return;
        }
        super.setModel(this.myPlugins.getScroller());
        this.isPopulated = true;
    }

    protected void updateSelection(MouseEvent e) {
        int index = super.locationToIndex(e.getPoint());
        if (e.getClickCount() == 2) {
            super.clearSelection();
        } else {
            ListSelectionModel listSelection = super.getSelectionModel();
            if (!(e.isControlDown() || e.isShiftDown() || e.isAltDown())) {
                listSelection.removeSelectionInterval(index, index);
            }
        }
        this.myPlugins.getScroller().setValue(index);
    }

    public void selectFiles(File[] filesToSelect) {
        if (filesToSelect == null) {
            return;
        }
        File[] sortedFiles = this.myPlugins.getScroller().getSortedFiles();
        for (int i = 0; i < filesToSelect.length; ++i) {
            for (int sortedIndex = 0; sortedIndex < sortedFiles.length; ++sortedIndex) {
                if (filesToSelect[i] == null || sortedFiles[sortedIndex] == null || !filesToSelect[i].equals(sortedFiles[sortedIndex])) continue;
                super.addSelectionInterval(sortedIndex, sortedIndex);
            }
        }
    }

    public void renameSomeFiles() {
        Object[] selected = super.getSelectedValues();
        if (selected.length == 0) {
            selected = new File[]{this.myPlugins.getScroller().getCurrentFile()};
        }
        this.popUpRename(selected, true);
    }

    protected void popUp(MouseEvent e) {
        Object[] selected = super.getSelectedValues();
        if (selected.length > 1) {
            this.popUpRename(selected, false);
        } else {
            e.getPoint();
            int index = this.locationToIndex(e.getPoint());
            Object obj = this.getModel().getElementAt(index);
            if (!(obj instanceof File)) {
                return;
            }
            Object[] fileList = new File[]{(File)obj};
            this.popUpRename(fileList, false);
        }
    }

    protected void popUpRename(Object[] selected, boolean showRenameTabAtTop) {
        File[] fileList = new File[selected.length];
        for (int i = 0; i < selected.length; ++i) {
            if (selected[i] == null || !(selected[i] instanceof File)) continue;
            fileList[i] = (File)selected[i];
        }
        FileNameChanger fnc = new FileNameChanger(fileList);
        fnc.showDialog(this.myPlugins, this.myExtendedDirectoryTree, true, showRenameTabAtTop);
        if (fileList.length > 1) {
            File[] changedFiles = fnc.getChangedNames();
            if (changedFiles == null || changedFiles.length == 1) {
                this.myPlugins.getScroller().reloadScroller();
            } else {
                this.myPlugins.getScroller().reloadScroller(0);
            }
            super.clearSelection();
            this.selectFiles(changedFiles);
            this.myPlugins.getScroller().selectFile(changedFiles[0]);
        }
        this.myPlugins.setWaitCursor(false);
    }

    protected class FileRenderer
    extends DefaultListCellRenderer {
        protected FileRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Range range;
            Component rtnMe = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value != null && value instanceof File) {
                super.setText(((File)value).getName());
            }
            if (FileList.this.myPlugins.getScroller() == null) {
                return rtnMe;
            }
            if (FileList.this.myPlugins.getScroller().getValueZeroBased() == index) {
                rtnMe.setForeground(Color.RED);
            }
            if ((range = FileList.this.myPlugins.showingIndexes()).getFirst() > -1 && index >= range.getFirst() && index <= range.getLast() && rtnMe.getBackground() == myDefaultBackground) {
                rtnMe.setBackground(SHOWING_BACKGROUND);
            }
            return rtnMe;
        }
    }

    class AdaptedMouse
    extends MouseAdapter {
        AdaptedMouse() {
        }

        public void mousePressed(MouseEvent e) {
        }

        public void mouseReleased(MouseEvent e) {
        }

        public void mouseClicked(MouseEvent e) {
            if ((e.getModifiers() & 8) != 0) {
                FileList.this.popUp(e);
                return;
            }
            if ((e.getModifiers() & 4) != 0) {
                FileList.this.popUp(e);
                return;
            }
            FileList.this.updateSelection(e);
        }
    }
}

