/*
 * Decompiled with CFR 0.152.
 */
package org.gerhardb.lib.dirtree.filelist.popup;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.io.File;
import javax.swing.Icon;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.gerhardb.lib.dirtree.ExtendedDirectoryTree;
import org.gerhardb.lib.dirtree.filelist.FileListPlugins;
import org.gerhardb.lib.dirtree.filelist.popup.FileNameChangeAddNumberTab;
import org.gerhardb.lib.dirtree.filelist.popup.FileNameChangeCompleteTab;
import org.gerhardb.lib.dirtree.filelist.popup.FileNameChangeDialog;
import org.gerhardb.lib.dirtree.filelist.popup.FileNameChanger;
import org.gerhardb.lib.util.startup.AppStarter;

class FileSeveralNameChangeDialog
extends FileNameChangeDialog {
    private static final int ADD_NUMBER = 1;
    private static final int COMPLETE = 2;
    FileNameChangeCompleteTab myCompleteTab;
    FileNameChangeAddNumberTab myNumberOnlyTab;
    String mySampleText = "abcdefghijklmnopqrstuvwxyz.123";

    public FileSeveralNameChangeDialog(FileNameChanger fnc, FileListPlugins plugins, ExtendedDirectoryTree tree, boolean allTabs, boolean showRenameTabAtTop) {
        super(fnc, plugins, tree, allTabs);
        if (allTabs && showRenameTabAtTop) {
            this.myTabs.setSelectedComponent(this.myCompleteTab);
        }
        this.setVisible(true);
    }

    void layoutDialog() {
        long testLength = 1000L;
        for (int i = 0; i < this.myFileNameChanger.myInputFileList.length; ++i) {
            String name;
            if (this.myFileNameChanger.myInputFileList[i] == null || (name = this.myFileNameChanger.myInputFileList[i].getName()) == null || (long)name.length() >= testLength) continue;
            this.mySampleText = this.myFileNameChanger.myInputFileList[i].getName();
            testLength = this.mySampleText.length();
        }
        this.myCompleteTab = new FileNameChangeCompleteTab(this, this.mySampleText, this.myFileNameChanger.myInputFileList.length, this.myPlugins.getRDPmanager().getAppIDandTargetType());
        this.myNumberOnlyTab = new FileNameChangeAddNumberTab(this, this.mySampleText);
        this.myTabs.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                EventQueue.invokeLater(new Runnable(){

                    public void run() {
                        if ((this).FileSeveralNameChangeDialog.this.iShowAll) {
                            switch ((this).FileSeveralNameChangeDialog.this.myTabs.getSelectedIndex()) {
                                case 0: {
                                    FileSeveralNameChangeDialog.this.getRootPane().setDefaultButton((this).FileSeveralNameChangeDialog.this.myMoveTab.getDefaultButton());
                                    break;
                                }
                                case 2: {
                                    FileSeveralNameChangeDialog.this.getRootPane().setDefaultButton((this).FileSeveralNameChangeDialog.this.myCompleteTab.getDefaultButton());
                                    (this).FileSeveralNameChangeDialog.this.myCompleteTab.myTextFld.requestFocus();
                                    break;
                                }
                                case 1: {
                                    FileSeveralNameChangeDialog.this.getRootPane().setDefaultButton((this).FileSeveralNameChangeDialog.this.myNumberOnlyTab.getDefaultButton());
                                    (this).FileSeveralNameChangeDialog.this.myNumberOnlyTab.myTextFld.requestFocus();
                                }
                            }
                        } else {
                            (this).FileSeveralNameChangeDialog.this.myCompleteTab.myTextFld.requestFocus();
                        }
                    }
                });
            }
        });
        Icon icon = null;
        if (this.iShowAll) {
            this.myTabs.addTab(AppStarter.getString("FileNameChangeDialog.6"), icon, this.myMoveTab, AppStarter.getString("FileNameChangeDialog.3"));
            this.myTabs.addTab(AppStarter.getString("FileNameChangeDialog.4"), icon, this.myNumberOnlyTab, AppStarter.getString("FileNameChangeDialog.3"));
        }
        this.myTabs.addTab(AppStarter.getString("FileNameChangeDialog.2"), icon, this.myCompleteTab, AppStarter.getString("FileNameChangeDialog.1"));
        JPanel thePanel = new JPanel(new BorderLayout());
        thePanel.add((Component)this.myTabs, "Center");
        this.finishLayout(thePanel);
        this.myNumberOnlyTab.setSampleText(this.mySampleText);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doNameChange() {
        File[] inputFileList = this.myFileNameChanger.myOutputFileList;
        File[] outputFileList = new File[inputFileList.length];
        String failureMsg = AppStarter.getString("FileList.10");
        this.myFileNameChanger.iRan = true;
        boolean failures = false;
        this.setWaitCursor(true);
        try {
            int i;
            int position = 0;
            for (i = 0; i < inputFileList.length; ++i) {
                if (inputFileList[i] == null) continue;
                try {
                    String dir = inputFileList[i].getParentFile().getCanonicalPath();
                    String newName = dir + "/" + this.getNewName(position + 1, inputFileList[i].getName());
                    ++position;
                    outputFileList[i] = new File(newName);
                    if (!outputFileList[i].exists()) continue;
                    failures = true;
                    failureMsg = "There is already a file named:\n" + outputFileList[i];
                    break;
                }
                catch (Exception ex) {
                    inputFileList[i] = this.myFileNameChanger.myInputFileList[i];
                    System.out.println("FileNameChangeDialog A: " + ex.getMessage());
                    failures = true;
                }
            }
            if (!failures) {
                for (i = 0; i < inputFileList.length; ++i) {
                    if (inputFileList[i] == null) continue;
                    try {
                        System.out.println("Renaming: " + inputFileList[i]);
                        inputFileList[i].renameTo(outputFileList[i]);
                        inputFileList[i] = outputFileList[i];
                        continue;
                    }
                    catch (Exception ex) {
                        inputFileList[i] = this.myFileNameChanger.myInputFileList[i];
                        System.out.println("FileNameChangeDialog B: " + ex.getMessage());
                        failures = true;
                    }
                }
            }
        }
        finally {
            this.setWaitCursor(false);
        }
        if (failures) {
            JOptionPane.showMessageDialog(this, failureMsg, AppStarter.getString("FileList.11"), 2);
        }
    }

    private String getNewName(int i, String oldName) {
        if (this.iShowAll) {
            switch (this.myTabs.getSelectedIndex()) {
                case 2: {
                    return this.myCompleteTab.getNewName(i, oldName, false);
                }
                case 1: {
                    return this.myNumberOnlyTab.getNewName(oldName);
                }
            }
            return oldName;
        }
        return this.myCompleteTab.getNewName(i, oldName, false);
    }
}

