/*
 * Decompiled with CFR 0.152.
 */
package org.gerhardb.lib.dirtree.rdp;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JMenu;
import javax.swing.JRadioButton;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import org.gerhardb.lib.dirtree.rdp.ListShowTreeCoordinator;
import org.gerhardb.lib.util.ActionHelpers;
import org.gerhardb.lib.util.startup.ActiveActions;
import org.gerhardb.lib.util.startup.AppStarter;

public class SortManager {
    private static final String SORT_ORDER = "sortOrder";
    private ListShowTreeCoordinator myListShowTreeCoordinator;
    private ButtonModel[] mySortButtonModels;
    Action[] myActions = new Action[5];

    public SortManager(ListShowTreeCoordinator lst) {
        this.myListShowTreeCoordinator = lst;
        this.myActions[0] = this.makeStartupAction("SortScreen.menu", "sort", "none", new NoSort(), null);
        this.myActions[1] = this.makeStartupAction("SortScreen.menu", "sort", "insensative", new NameSortInsensative(), null);
        this.myActions[2] = this.makeStartupAction("SortScreen.menu", "sort", "sensative", new NameSortSensative(), null);
        this.myActions[3] = this.makeStartupAction("SortScreen.menu", "sort", "date", new DateSort(), null);
        this.myActions[4] = this.makeStartupAction("SortScreen.menu", "sort", "length", new LengthSort(), null);
    }

    public int getSortOrder() {
        return this.myListShowTreeCoordinator.getPreferences().getInt(SORT_ORDER, 1);
    }

    public void setSortOrder(int order) {
        this.myListShowTreeCoordinator.getPreferences().putInt(SORT_ORDER, order);
    }

    private Action makeStartupAction(String application, String menu, String item, Action action, Icon icon) {
        String key = ActiveActions.makeKey(application, menu, item);
        return ActiveActions.loadAction(key, action, icon);
    }

    public JMenu getSortMenu() {
        JMenu menu = ActionHelpers.makeMenu("sort");
        final JRadioButtonMenuItem[] menuItems = new JRadioButtonMenuItem[this.myActions.length];
        menu.addMenuListener(new MenuListener(){

            public void menuCanceled(MenuEvent e) {
            }

            public void menuDeselected(MenuEvent e) {
            }

            public void menuSelected(MenuEvent e) {
                switch (SortManager.this.getSortOrder()) {
                    case 0: {
                        menuItems[0].setSelected(true);
                        break;
                    }
                    case 1: {
                        menuItems[1].setSelected(true);
                        break;
                    }
                    case 2: {
                        menuItems[2].setSelected(true);
                        break;
                    }
                    case 3: {
                        menuItems[3].setSelected(true);
                        break;
                    }
                    case 4: {
                        menuItems[4].setSelected(true);
                    }
                }
            }
        });
        this.mySortButtonModels = new ButtonModel[this.myActions.length];
        ButtonGroup sortGroup = new ButtonGroup();
        for (int i = 0; i < this.myActions.length; ++i) {
            menuItems[i] = new JRadioButtonMenuItem(this.myActions[i]);
            menu.add(menuItems[i]);
            sortGroup.add(menuItems[i]);
            this.mySortButtonModels[i] = menuItems[i].getModel();
        }
        switch (this.getSortOrder()) {
            case 0: {
                menuItems[0].setSelected(true);
                break;
            }
            case 1: {
                menuItems[1].setSelected(true);
                break;
            }
            case 2: {
                menuItems[2].setSelected(true);
                break;
            }
            case 3: {
                menuItems[3].setSelected(true);
                break;
            }
            case 4: {
                menuItems[4].setSelected(true);
            }
        }
        return menu;
    }

    public JRadioButton[] makeSortRadioButtons() {
        JRadioButton[] rtnMe = new JRadioButton[this.myActions.length];
        for (int i = 0; i < this.myActions.length; ++i) {
            rtnMe[i] = new JRadioButton(this.myActions[i]);
            rtnMe[i].setModel(this.mySortButtonModels[i]);
        }
        return rtnMe;
    }

    class LengthSort
    extends AbstractAction {
        LengthSort() {
            super(AppStarter.getString("Actions.206"));
        }

        public void actionPerformed(ActionEvent event) {
            SortManager.this.setSortOrder(4);
            SortManager.this.myListShowTreeCoordinator.getScroller().sort(4);
        }
    }

    class DateSort
    extends AbstractAction {
        DateSort() {
            super(AppStarter.getString("Actions.205"));
        }

        public void actionPerformed(ActionEvent event) {
            SortManager.this.setSortOrder(3);
            SortManager.this.myListShowTreeCoordinator.getScroller().sort(3);
        }
    }

    class NameSortSensative
    extends AbstractAction {
        NameSortSensative() {
            super(AppStarter.getString("Actions.204"));
        }

        public void actionPerformed(ActionEvent event) {
            SortManager.this.setSortOrder(2);
            SortManager.this.myListShowTreeCoordinator.getScroller().sort(2);
        }
    }

    class NameSortInsensative
    extends AbstractAction {
        NameSortInsensative() {
            super(AppStarter.getString("Actions.203"));
        }

        public void actionPerformed(ActionEvent event) {
            SortManager.this.setSortOrder(1);
            SortManager.this.myListShowTreeCoordinator.getScroller().sort(1);
        }
    }

    class NoSort
    extends AbstractAction {
        NoSort() {
            super(AppStarter.getString("Actions.202"));
        }

        public void actionPerformed(ActionEvent event) {
            SortManager.this.setSortOrder(0);
            SortManager.this.myListShowTreeCoordinator.getScroller().sort(0);
        }
    }
}

