/*
 * Decompiled with CFR 0.152.
 */
package org.gerhardb.lib.io;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.gerhardb.lib.util.startup.AppStarter;

public class EzLogger {
    private static final String FILE_DATE_FORMAT = "yyyy.MM.dd-HH.mm.ss";
    private static final SimpleDateFormat FILE_DATE = new SimpleDateFormat("yyyy.MM.dd-HH.mm.ss");
    public static String NEW_LINE = System.getProperty("line.separator");
    FileWriter myFileWriter;
    String newLine = System.getProperty("line.separator");
    public static final String DIVIDER = "===========================================================================================";

    public static EzLogger makeEzLogger(File dir) throws Exception {
        String date = FILE_DATE.format(new Date());
        String logFileName = dir + System.getProperty("file.separator") + "jibsLog_" + date + ".txt";
        File logFile = new File(logFileName);
        return new EzLogger(logFile);
    }

    public EzLogger(File logFile) throws Exception {
        this.myFileWriter = new FileWriter(logFile);
        System.out.println(AppStarter.getString("EzLogger.3") + AppStarter.getString("colon") + " " + logFile);
        this.logLine(AppStarter.getString("EzLogger.4") + AppStarter.getString("colon") + " ");
        this.logLine(logFile.toString());
        this.logLine(AppStarter.getString("EzLogger.5") + AppStarter.getString("colon") + " " + new SimpleDateFormat().format(new Date()));
        this.logLine("");
    }

    public void logLine(String entry) {
        try {
            this.myFileWriter.write(entry + this.newLine);
            this.myFileWriter.flush();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void logTime(String type, Date start, Date stop) {
        long SECOND = 1000L;
        long MINUTE = 60000L;
        long elapsed = stop.getTime() - start.getTime();
        this.logLine(type + " " + AppStarter.getString("EzLogger.7") + AppStarter.getString("colon") + " " + elapsed + " " + AppStarter.getString("EzLogger.8") + " ");
        long minutes = elapsed / 60000L;
        long minuteRemainder = elapsed % 60000L;
        long seconds = minuteRemainder / 1000L;
        long milli = minuteRemainder % 1000L;
        this.logLine(type + " " + AppStarter.getString("EzLogger.9") + AppStarter.getString("colon") + " " + minutes + " " + AppStarter.getString("EzLogger.10") + " " + seconds + " " + AppStarter.getString("EzLogger.11") + " " + milli + " " + AppStarter.getString("EzLogger.12") + " ");
    }

    public void close() throws IOException {
        this.myFileWriter.close();
    }
}

