/*
 * Decompiled with CFR 0.152.
 */
package org.gerhardb.lib.playlist;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.EventQueue;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.swing.BoundedRangeModel;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.gerhardb.lib.dirtree.filelist.FileList;
import org.gerhardb.lib.dirtree.filelist.FileListSelectionModel;
import org.gerhardb.lib.image.IOImage;
import org.gerhardb.lib.image.ImageFactory;
import org.gerhardb.lib.io.FileDateComparator;
import org.gerhardb.lib.io.FileLengthComparator;
import org.gerhardb.lib.io.FileNameComparatorInsensative;
import org.gerhardb.lib.io.FileNameComparatorSensative;
import org.gerhardb.lib.playlist.IScroll;
import org.gerhardb.lib.playlist.ListMaker;
import org.gerhardb.lib.playlist.ScrollerChangeEvent;
import org.gerhardb.lib.playlist.ScrollerKeyListener;
import org.gerhardb.lib.playlist.ScrollerListener;
import org.gerhardb.lib.playlist.SlideShowListener;
import org.gerhardb.lib.util.Icons;
import org.gerhardb.lib.util.startup.AppStarter;

public class Scroller
implements IScroll,
ListModel,
BoundedRangeModel {
    ArrayList myList = new ArrayList(1000);
    ArrayList myListDataListeners = new ArrayList(5);
    ArrayList myBoundedRangeModelDataListeners = new ArrayList(5);
    ArrayList myScrollerListeners = new ArrayList(5);
    ArrayList myShowListeners = new ArrayList(5);
    boolean iBoundedRangeModelValueIsAdjusting = false;
    int mySortType = 0;
    int myPageSize = 10;
    int myIndex = -1;
    int myTimerDelay = 3000;
    ListMaker myListMaker;
    Component myFocusComponent;
    IOImage myCurrentIOImage;
    Timer myTimer;
    KeyListener myShowViewKeyListener = null;
    boolean iShowEndMessages = false;
    JFrame myFrame;
    ScrollerKeyListener myScrollerKeyListener = new ScrollerKeyListener(this);
    public static final int SORT_OFF = 0;
    public static final int SORT_NAME_CASE_INSENSATIVE = 1;
    public static final int SORT_NAME_CASE_SENSATIVE = 2;
    public static final int SORT_DATE = 3;
    public static final int SORT_LENGTH = 4;

    public void setListMaker(ListMaker lm) {
        this.myListMaker = lm;
        this.reloadScroller();
    }

    public void setListSelectionModel(FileListSelectionModel sm) {
        this.myScrollerKeyListener.setListSelectionModel(sm);
    }

    public void updateSelectionInterval() {
        this.myScrollerKeyListener.updateSelectionInterval();
    }

    public ListMaker getListMaker() {
        return this.myListMaker;
    }

    public void reloadScroller(int index) {
        Cursor oldCursor = this.myFrame.getCursor();
        this.myFrame.setCursor(Cursor.getPredefinedCursor(3));
        try {
            File[] list;
            this.iBoundedRangeModelValueIsAdjusting = true;
            this.myIndex = -1;
            this.myList = new ArrayList();
            if (this.myListMaker != null && (list = this.myListMaker.getFileList()) != null) {
                int length = list.length;
                this.myList = new ArrayList(length);
                for (int i = 0; i < length; ++i) {
                    this.myList.add(list[i]);
                }
                if (length > 0) {
                    this.myIndex = 0;
                }
                this.doSort(false);
            }
            this.myIndex = index >= this.myList.size() ? this.myList.size() - 1 : index;
            this.myPageSize = this.myList.size() < 51 ? 5 : (this.myList.size() < 101 ? 10 : this.myList.size() / 10);
            this.iBoundedRangeModelValueIsAdjusting = false;
            this.updateImage(3);
            this.kickListeners(new ListDataEvent(this, 0, 0, this.myList.size()));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.myFrame.setCursor(oldCursor);
    }

    public String getDescription() {
        if (this.myListMaker != null) {
            return this.myListMaker.getDescription();
        }
        return null;
    }

    public ScrollerKeyListener getScrollerKeyListener() {
        return this.myScrollerKeyListener;
    }

    public String getStatusBarCount() {
        File File2 = this.getCurrentFile();
        if (File2 != null) {
            int pageShowing = this.getValueZeroBased() + 1;
            int count = this.getMaximumZeroBased() + 1;
            return pageShowing + " " + AppStarter.getString("Scroller.0") + " " + count;
        }
        return "";
    }

    public String getStatusBarFileName() {
        File File2 = this.getCurrentFile();
        if (File2 != null) {
            return File2.toString();
        }
        if (this.myListMaker != null) {
            return this.myListMaker.getDescription();
        }
        return "";
    }

    public void setShowViewKeyListener(KeyListener k) {
        this.myShowViewKeyListener = k;
    }

    public KeyListener getShowViewKeyListener() {
        return this.myShowViewKeyListener;
    }

    public void setEndMessages(boolean showEndMessages) {
        this.iShowEndMessages = showEndMessages;
    }

    public File[] getSortedFiles() {
        File[] rtnMe = new File[this.myList.size()];
        this.myList.toArray(rtnMe);
        return rtnMe;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListDataListener(ListDataListener l) {
        ArrayList arrayList = this.myListDataListeners;
        synchronized (arrayList) {
            this.myListDataListeners.add(l);
        }
    }

    public Object getElementAt(int index) {
        if (this.myList == null) {
            return null;
        }
        if (index >= this.myList.size()) {
            return null;
        }
        return this.myList.get(index);
    }

    public int getSize() {
        return this.myList.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListDataListener(ListDataListener l) {
        ArrayList arrayList = this.myListDataListeners;
        synchronized (arrayList) {
            this.myListDataListeners.remove(l);
        }
    }

    public int getValueZeroBased() {
        return this.myIndex;
    }

    public int getMaximumZeroBased() {
        return this.myList.size() - 1;
    }

    public int getValue() {
        return this.myIndex + 1;
    }

    public int getMaximum() {
        return this.myList.size();
    }

    public int getMinimum() {
        return 0;
    }

    public void setValue(int newValue) {
        if (newValue >= 0 && newValue < this.myList.size()) {
            Cursor priorCursor = this.myFrame.getCursor();
            this.myFrame.setCursor(Cursor.getPredefinedCursor(3));
            this.myIndex = newValue;
            this.updateImage(1);
            this.myFrame.setCursor(priorCursor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChangeListener(ChangeListener x) {
        ArrayList arrayList = this.myBoundedRangeModelDataListeners;
        synchronized (arrayList) {
            this.myBoundedRangeModelDataListeners.add(x);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeChangeListener(ChangeListener x) {
        ArrayList arrayList = this.myBoundedRangeModelDataListeners;
        synchronized (arrayList) {
            this.myBoundedRangeModelDataListeners.remove(x);
        }
    }

    public int getExtent() {
        return 0;
    }

    public boolean getValueIsAdjusting() {
        return this.iBoundedRangeModelValueIsAdjusting;
    }

    public void setValueIsAdjusting(boolean b) {
        this.iBoundedRangeModelValueIsAdjusting = b;
        if (!b) {
            this.updateImage(1);
        }
    }

    public void setRangeProperties(int value, int extent, int min, int max, boolean adjusting) {
        this.setValueIsAdjusting(adjusting);
    }

    public void setExtent(int newExtent) {
    }

    public void setMaximum(int newMaximum) {
    }

    public void setMinimum(int newMinimum) {
    }

    public void sort(int type) {
        if (type < 0 || type > 4) {
            throw new IllegalArgumentException("sort type out of range");
        }
        this.mySortType = type;
        this.doSort(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void doSort(boolean realSort) {
        if (this.myFrame != null) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    Scroller.this.myFrame.setCursor(Cursor.getPredefinedCursor(3));
                }
            });
        }
        File returnTo = this.getCurrentFile();
        try {
            switch (this.mySortType) {
                case 1: {
                    Collections.sort(this.myList, new FileNameComparatorInsensative());
                    break;
                }
                case 2: {
                    Collections.sort(this.myList, new FileNameComparatorSensative());
                    break;
                }
                case 3: {
                    Collections.sort(this.myList, new FileDateComparator());
                    break;
                }
                case 4: {
                    Collections.sort(this.myList, new FileLengthComparator());
                    break;
                }
                default: {
                    if (!realSort) break;
                    this.reloadScroller();
                }
            }
            if (realSort) {
                this.kickListeners(new ScrollerChangeEvent(1), true);
                this.selectFile(returnTo);
            }
            if (this.myFrame == null) return;
        }
        catch (Throwable throwable) {
            if (this.myFrame == null) throw throwable;
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    Scroller.this.myFrame.setCursor(Cursor.getDefaultCursor());
                }
            });
            throw throwable;
        }
        SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
    }

    public File getCurrentFile() {
        return this.getFile(this.myIndex);
    }

    public File getFile(int index) {
        if (index < 0 || index >= this.myList.size()) {
            return null;
        }
        return (File)this.myList.get(index);
    }

    public void reloadScroller() {
        this.reloadScroller(0);
    }

    public void selectFile(File file) {
        if (file == null) {
            return;
        }
        File[] sortedFiles = new File[this.myList.size()];
        this.myList.toArray(sortedFiles);
        for (int i = 0; i < sortedFiles.length; ++i) {
            if (!file.equals(sortedFiles[i])) continue;
            this.myIndex = i;
            this.updateImage(1);
            break;
        }
    }

    public void removeCurrentPage() {
        if (this.myList.size() < 1 || this.myIndex < 0) {
            return;
        }
        ScrollerChangeEvent event = new ScrollerChangeEvent(2, this.myIndex);
        this.myList.remove(this.myIndex);
        this.kickListeners(new ListDataEvent(this, 2, this.myIndex, this.myIndex));
        if (this.myIndex == this.myList.size()) {
            this.myIndex = this.myList.size() - 1;
        }
        this.kickListeners(event, true);
        this.requestFocus();
    }

    public File[] getPictureFiles() {
        File[] rtnMe = new File[this.myList.size()];
        for (int i = 0; i < rtnMe.length; ++i) {
            rtnMe[i] = (File)this.myList.get(i);
        }
        return rtnMe;
    }

    public void setPageSize(int pageSize) {
        this.myPageSize = pageSize;
    }

    public void up() {
        if (this.myIndex > 0) {
            --this.myIndex;
            this.updateImage(1);
        } else if (this.iShowEndMessages) {
            this.endOfList(false);
        }
    }

    public void down() {
        if (this.myIndex < this.myList.size() - 1) {
            ++this.myIndex;
            this.updateImage(1);
        } else if (this.iShowEndMessages) {
            this.endOfList(true);
        }
    }

    public void pageUp() {
        if (this.myIndex > this.myPageSize) {
            this.myIndex -= this.myPageSize;
        } else if (this.myIndex <= 0) {
            this.endOfList(false);
        } else {
            this.myIndex = 0;
        }
        this.updateImage(1);
    }

    public void pageDown() {
        int endOfList = this.myList.size() - 1;
        if (this.myIndex < endOfList - this.myPageSize) {
            this.myIndex += this.myPageSize;
        } else if (this.myIndex >= endOfList) {
            this.endOfList(true);
        } else {
            this.myIndex = endOfList;
        }
        this.updateImage(1);
    }

    public void home() {
        this.myIndex = this.myList.size() > 0 ? 0 : -1;
        this.updateImage(1);
    }

    public void end() {
        this.myIndex = this.myList.size() - 1;
        this.updateImage(1);
    }

    public boolean jumpTo(Object jumpTo) {
        int index = this.myList.indexOf(jumpTo);
        if (index > 0) {
            this.setValue(index);
            return true;
        }
        return false;
    }

    public void jumpTo(int index) {
        if (this.myList.size() == 0) {
            return;
        }
        if (index > this.myList.size()) {
            this.setValue(this.myList.size());
        } else if (index < 0) {
            this.setValue(-1);
        } else {
            this.setValue(index);
        }
    }

    public synchronized void addSlideShowListener(SlideShowListener l) {
        this.myShowListeners.add(l);
    }

    public synchronized void removeSlideShowListener(SlideShowListener l) {
        this.myShowListeners.remove(l);
    }

    public synchronized void startSlideShow(final boolean continuous) {
        if (this.myTimer != null) {
            return;
        }
        this.notifySlideShowListeners(true);
        this.myTimer = new Timer(this.myTimerDelay, new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                boolean moreFiles = true;
                while (moreFiles) {
                    if (Scroller.this.myIndex < Scroller.this.myList.size() - 1) {
                        ++Scroller.this.myIndex;
                        File currentFile = Scroller.this.getCurrentFile();
                        if (currentFile == null || !currentFile.exists()) continue;
                        break;
                    }
                    moreFiles = false;
                }
                if (moreFiles) {
                    Scroller.this.updateImage(1);
                } else if (continuous) {
                    Scroller.this.reloadScroller();
                    Scroller.this.home();
                } else {
                    Scroller.this.endOfList(true);
                    Scroller.this.stopSlideShow();
                }
            }
        });
        this.myTimer.start();
    }

    public synchronized void stopSlideShow() {
        if (this.myTimer != null) {
            this.myTimer.stop();
            this.myTimer = null;
            this.notifySlideShowListeners(false);
        }
    }

    public boolean isSlideShowRunning() {
        return this.myTimer != null;
    }

    private void notifySlideShowListeners(final boolean running) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                Iterator loop = Scroller.this.myShowListeners.iterator();
                while (loop.hasNext()) {
                    ((SlideShowListener)loop.next()).slideShow(running);
                }
            }
        });
    }

    public void setFrame(JFrame frame) {
        this.myFrame = frame;
    }

    public void setAutoFocus(Component focus) {
        this.myFocusComponent = focus;
        this.myFocusComponent.addMouseWheelListener(this.getMouseWheelListener());
        this.requestFocus();
    }

    public void requestFocus() {
        if (this.myFocusComponent != null) {
            Component compFocusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
            if (compFocusOwner != null) {
                if (!(compFocusOwner instanceof FileList)) {
                    this.myFocusComponent.requestFocus();
                }
            } else {
                this.myFocusComponent.requestFocus();
            }
        }
    }

    public void forceFocus() {
        if (this.myFocusComponent != null) {
            this.myFocusComponent.requestFocus();
        }
    }

    public Component getFocusComponent() {
        return this.myFocusComponent;
    }

    public void refreshCurrentImage() {
        this.updateImage(1);
    }

    public IOImage getCurrentIOImage() {
        File file;
        if (this.myCurrentIOImage == null && (file = this.getCurrentFile()) != null) {
            this.myCurrentIOImage = ImageFactory.getImageFactory().makeImageEZ(file);
        }
        return this.myCurrentIOImage;
    }

    public BufferedImage getCurrentImage() {
        IOImage current = this.getCurrentIOImage();
        if (current == null) {
            return null;
        }
        try {
            return current.getImage();
        }
        catch (Exception ex) {
            System.out.println("Scroller.getCurrentImage FAILED");
            System.out.println(ex.getMessage());
            ex.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addScrollerListener(ScrollerListener x) {
        ArrayList arrayList = this.myScrollerListeners;
        synchronized (arrayList) {
            this.myScrollerListeners.add(x);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeScrollerListener(ScrollerListener x) {
        ArrayList arrayList = this.myScrollerListeners;
        synchronized (arrayList) {
            this.myScrollerListeners.remove(x);
        }
    }

    public void setSlideFlipDelay(int millisedonds) {
        this.myTimerDelay = millisedonds;
    }

    public int getSlideFlipDelay() {
        return this.myTimerDelay;
    }

    public MouseWheelListener getMouseWheelListener() {
        return new MouseWheelListener(){

            public void mouseWheelMoved(MouseWheelEvent event) {
                int units = event.getUnitsToScroll();
                if (units > 0) {
                    Scroller.this.down();
                } else if (units < 0) {
                    Scroller.this.up();
                }
            }
        };
    }

    public boolean isBeyond() {
        return this.myIndex < 0 || this.myIndex >= this.myList.size();
    }

    public BufferedImage getBeyondBounds() {
        URL url = null;
        if (this.getSize() == 0) {
            url = Icons.getURL(8);
        } else if (this.myIndex < 0) {
            url = Icons.getURL(16);
        } else if (this.myIndex >= this.myList.size()) {
            url = Icons.getURL(17);
        }
        if (url == null) {
            return null;
        }
        try {
            return ImageIO.read(url);
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public ImageIcon getBeyondBoundsIcon() {
        BufferedImage img = this.getBeyondBounds();
        if (img == null) {
            return null;
        }
        return new ImageIcon(img);
    }

    private void updateImage(int scrollerChangeEventType) {
        this.kickListeners(new ScrollerChangeEvent(scrollerChangeEventType), true);
        this.kickListeners(new ChangeEvent(this));
        this.requestFocus();
    }

    public void editedImage() {
        this.kickListeners(new ScrollerChangeEvent(0), false);
        this.requestFocus();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void kickListeners(ScrollerChangeEvent event, boolean invalidate) {
        if (invalidate) {
            this.myCurrentIOImage = null;
        }
        ScrollerListener[] listeners = null;
        ArrayList arrayList = this.myScrollerListeners;
        synchronized (arrayList) {
            listeners = new ScrollerListener[this.myScrollerListeners.size()];
            this.myScrollerListeners.toArray(listeners);
        }
        for (int i = 0; i < listeners.length; ++i) {
            listeners[i].scrollerChanged(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void kickListeners(ListDataEvent event) {
        ListDataListener[] listeners = null;
        ArrayList arrayList = this.myListDataListeners;
        synchronized (arrayList) {
            listeners = new ListDataListener[this.myListDataListeners.size()];
            this.myListDataListeners.toArray(listeners);
        }
        block8: for (int i = 0; i < listeners.length; ++i) {
            switch (event.getType()) {
                case 0: {
                    listeners[i].contentsChanged(event);
                    continue block8;
                }
                case 1: {
                    listeners[i].intervalAdded(event);
                    continue block8;
                }
                case 2: {
                    listeners[i].intervalRemoved(event);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void kickListeners(ChangeEvent event) {
        ChangeListener[] listeners = null;
        ArrayList arrayList = this.myBoundedRangeModelDataListeners;
        synchronized (arrayList) {
            listeners = new ChangeListener[this.myBoundedRangeModelDataListeners.size()];
            this.myBoundedRangeModelDataListeners.toArray(listeners);
        }
        for (int i = 0; i < listeners.length; ++i) {
            listeners[i].stateChanged(event);
        }
    }

    private void endOfList(boolean end) {
        this.myIndex = end ? this.myList.size() : -1;
        this.updateImage(1);
    }
}

