/*
 * Decompiled with CFR 0.152.
 */
package org.gerhardb.lib.print;

import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.print.PageFormat;
import java.io.File;
import org.gerhardb.lib.image.ImageChangeUtil;
import org.gerhardb.lib.image.ImageFactory;
import org.gerhardb.lib.print.PageablePreviewer;
import org.gerhardb.lib.print.PrintJobUtils;
import org.gerhardb.lib.print.PrintableBase;

public class PageableImage
extends PrintableBase {
    BufferedImage myImage;
    String myDescription;

    public PageableImage(String description, BufferedImage image) {
        super(description);
        this.myDescription = description;
        this.myImage = image;
        this.myNumberOfPages = 1;
        super.setPageFormat(PrintJobUtils.orientPageToImage(this.myImage));
    }

    public PrintableBase makeCopy() {
        PageableImage rtnMe = new PageableImage(this.myDescription, this.myImage);
        super.imprint(rtnMe);
        rtnMe.myImage = this.myImage;
        rtnMe.myDescription = this.myDescription;
        return rtnMe;
    }

    protected void drawPage(int pageIndex) {
        if (this.myImage == null) {
            return;
        }
        PageFormat paperPF = super.getPageFormat(0);
        PageFormat screenPF = super.getMediaFormat().getPageFormat();
        double screenDelta = screenPF.getImageableHeight() / paperPF.getImageableHeight();
        int adjustedPicHeight = (int)((double)this.maxPictureHeight * screenDelta);
        int adjustedPicWidth = (int)((double)this.maxPictureWidth * screenDelta);
        BufferedImage sized = ImageChangeUtil.fitAspectDown(this.myImage, adjustedPicWidth, adjustedPicHeight);
        BufferedImageOp op = null;
        int centeredX = (int)(this.myLeftMargin + (double)((this.maxPictureWidth - sized.getWidth()) / 2));
        int centeredY = (int)(this.myTopPictureMargin + (double)((this.maxPictureHeight - sized.getHeight()) / 2));
        this.myBuffGraphics.drawImage(sized, op, centeredX, centeredY);
    }

    public static void main(String[] args) {
        BufferedImage image = ImageFactory.getImageFactory().getImageEZ(new File("D:/testpics/Fixed Files/proof/g.jpg"));
        PageableImage pi = new PageableImage("Test", image);
        new PageablePreviewer(pi, null, true);
    }
}

