/*
 * Decompiled with CFR 0.152.
 */
package org.gerhardb.lib.swing;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.prefs.Preferences;
import javax.swing.ButtonGroup;
import javax.swing.JMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;

public class UIMenu {
    private Preferences myPrefs;
    private static final String USER_INTERFACE = "ui";
    int mySelectedUI;
    Component myComponent;

    public UIMenu(Component c, String appName) {
        this.myComponent = c;
        this.myPrefs = Preferences.userRoot().node("/" + appName + "/org/gerhardb/lib/swing/UIMenu");
    }

    public JMenu populateUIMenu(JMenu menuUI) {
        ButtonGroup lookGroup = new ButtonGroup();
        UIManager.LookAndFeelInfo[] feels = UIManager.getInstalledLookAndFeels();
        final JRadioButtonMenuItem[] menuItems = new JRadioButtonMenuItem[feels.length];
        for (int i = 0; i < feels.length; ++i) {
            menuItems[i] = this.makeUIMenuItem(feels[i], i);
            menuUI.add(menuItems[i]);
            lookGroup.add(menuItems[i]);
        }
        menuUI.addMenuListener(new MenuListener(){

            public void menuCanceled(MenuEvent e) {
            }

            public void menuDeselected(MenuEvent e) {
            }

            public void menuSelected(MenuEvent e) {
                menuItems[UIMenu.this.mySelectedUI].setSelected(true);
            }
        });
        return menuUI;
    }

    public void initLookAndFeel() {
        UIManager.LookAndFeelInfo[] feels = UIManager.getInstalledLookAndFeels();
        String ui = this.myPrefs.get(USER_INTERFACE, null);
        for (int i = 0; i < feels.length; ++i) {
            if (ui == null || !ui.equals(feels[i].getClassName())) continue;
            try {
                Class<?> x = Class.forName(ui);
                UIManager.setLookAndFeel((LookAndFeel)x.newInstance());
                SwingUtilities.updateComponentTreeUI(this.myComponent);
                continue;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        LookAndFeel laf = UIManager.getLookAndFeel();
        for (int i = 0; i < feels.length; ++i) {
            if (!laf.getClass().getName().equals(feels[i].getClassName())) continue;
            this.mySelectedUI = i;
        }
    }

    private JRadioButtonMenuItem makeUIMenuItem(UIManager.LookAndFeelInfo info, int i) {
        final int index = i;
        final UIManager.LookAndFeelInfo myLook = info;
        JRadioButtonMenuItem menuItem = new JRadioButtonMenuItem(myLook.getName());
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                try {
                    String ui = myLook.getClassName();
                    Class<?> x = Class.forName(ui);
                    UIManager.setLookAndFeel((LookAndFeel)x.newInstance());
                    UIMenu.this.mySelectedUI = index;
                    UIMenu.this.myPrefs.put(UIMenu.USER_INTERFACE, ui);
                    try {
                        UIMenu.this.myPrefs.flush();
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                SwingUtilities.updateComponentTreeUI(UIMenu.this.myComponent);
            }
        });
        return menuItem;
    }
}

