/*
 * Decompiled with CFR 0.152.
 */
package org.gerhardb.lib.util.app;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.URL;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.gerhardb.jibs.Jibs;
import org.gerhardb.lib.swing.JPanelRows;
import org.gerhardb.lib.swing.SwingUtils;

public class AboutBox
extends Dialog
implements ActionListener {
    JButton myOkBtn = new JButton();
    Manifest myManifest = AboutBox.readManifest();

    public AboutBox(Frame parent) {
        super(parent);
        this.enableEvents(64L);
        super.setTitle(Jibs.getString("AboutBox.title"));
        super.setResizable(false);
        super.setModal(true);
        JPanel buttons = new JPanel(new FlowLayout(1));
        buttons.add(this.myOkBtn);
        this.myOkBtn.setText(Jibs.getString("ok"));
        this.myOkBtn.addActionListener(this);
        JPanel base = new JPanel(new BorderLayout());
        base.add((Component)this.makeCopyright(), "Center");
        base.add((Component)buttons, "South");
        super.add(base);
        this.pack();
        SwingUtils.centerOnScreen(this);
        super.setVisible(true);
    }

    private JPanel makeCopyright() {
        String jibsVersion = AboutBox.getJibsVersion(this.myManifest);
        String warranty = "This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the License for more details. \n\nThe license can be found in Help menu under License. \n\nIncludes software from the following projects or sources: \nhttp://www.fightingquaker.com/sanselan/ \nhttp://saic491.sourceforge.net/ \nhttp://www.drewnoakes.com/code/exif/ \nSun Microsystems \n";
        JTextArea showWarrenty = new JTextArea(warranty);
        showWarrenty.setLineWrap(true);
        showWarrenty.setWrapStyleWord(true);
        showWarrenty.setEditable(false);
        showWarrenty.setRows(10);
        showWarrenty.setColumns(40);
        JPanelRows basePanel = new JPanelRows(1);
        JPanel row = basePanel.topRow();
        row.add(new JLabel("<html><big>JIBS -- " + Jibs.getString("AboutBox.0") + "</big></html>"));
        row = basePanel.nextRow();
        row.add(new JLabel(Jibs.getString("AboutBox.1") + Jibs.getString("colon") + " " + jibsVersion));
        row = basePanel.nextRow();
        row.add(new JLabel(Jibs.getString("AboutBox.3") + " Gerhard Beck 2010"));
        row = basePanel.nextRow();
        row.add(new JLabel(Jibs.getString("AboutBox.4") + Jibs.getString("colon")));
        row = basePanel.nextRow();
        row.add(new JLabel("<html><big><b>http://www.jibs.us/</b></big></html>"));
        row = basePanel.nextRow();
        row.add(new JLabel("http://img-browse-sort.sourceforge.net/"));
        row = basePanel.nextRow();
        row.add(new JScrollPane(showWarrenty));
        return basePanel;
    }

    protected void processWindowEvent(WindowEvent e) {
        if (e.getID() == 201) {
            this.cancel();
        }
        super.processWindowEvent(e);
    }

    void cancel() {
        this.dispose();
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.myOkBtn) {
            this.cancel();
        }
    }

    public static String getJibsVersion(Manifest manifest) {
        Attributes attr;
        String version;
        String jibsVersion = "unknown";
        if (manifest != null && (version = (attr = manifest.getMainAttributes()).getValue(Attributes.Name.SPECIFICATION_VERSION)) != null && version.length() > 0) {
            jibsVersion = version;
        }
        return jibsVersion;
    }

    public static Manifest readManifest() {
        try {
            String classContainer = AboutBox.class.getProtectionDomain().getCodeSource().getLocation().toString();
            URL manifestUrl = new URL("jar:" + classContainer + "!/META-INF/MANIFEST.MF");
            Manifest manifest = new Manifest(manifestUrl.openStream());
            return manifest;
        }
        catch (Exception ex) {
            System.out.println("No Manifest found.  Likely you are running in Eclipse.  Run from Jar.");
            return null;
        }
    }

    public static void main(String[] args) {
        try {
            Manifest manifest = AboutBox.readManifest();
            Attributes attr = manifest.getMainAttributes();
            String CREATED_BY = attr.getValue("Created-by");
            String SOFTWARE_VENDOR = attr.getValue(Attributes.Name.IMPLEMENTATION_VENDOR);
            String SOFTWARE_VENDOR_ID = attr.getValue(Attributes.Name.IMPLEMENTATION_VENDOR_ID);
            String SOFTWARE_VENDOR_TITLE = attr.getValue(Attributes.Name.IMPLEMENTATION_TITLE);
            String SOFTWARE_VERSION = attr.getValue(Attributes.Name.IMPLEMENTATION_VERSION);
            String SOFTWARE_VENDOR_URL = attr.getValue(Attributes.Name.IMPLEMENTATION_URL);
            System.out.println("CREATED_BY: " + CREATED_BY);
            System.out.println("SOFTWARE_VENDOR: " + SOFTWARE_VENDOR);
            System.out.println("SOFTWARE_VENDOR_ID: " + SOFTWARE_VENDOR_ID);
            System.out.println("SOFTWARE_VENDOR_TITLE: " + SOFTWARE_VENDOR_TITLE);
            System.out.println("SOFTWARE_VERSION: " + SOFTWARE_VERSION);
            System.out.println("SOFTWARE_VENDOR_URL: " + SOFTWARE_VENDOR_URL);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        try {
            JFrame f = new JFrame("File Tree Test");
            f.getContentPane().add(new JLabel("test"));
            f.setSize(300, 300);
            f.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent evt) {
                    System.exit(0);
                }
            });
            f.setVisible(true);
            new AboutBox(f);
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
        }
        System.out.println("Main Exiting Normally");
    }
}

