/*
 * Decompiled with CFR 0.152.
 */
package org.gerhardb.lib.util.startup;

import java.awt.Dimension;
import java.io.File;
import java.util.HashMap;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import org.gerhardb.jibs.viewer.ViewerPreferences;
import org.gerhardb.jibs6.KeyChangerXML;
import org.gerhardb.lib.util.ActionHelpers;
import org.gerhardb.lib.util.startup.AppStarter;
import org.gerhardb.lib.util.startup.FactoryDefaultActions;

public abstract class ActiveActions {
    HashMap myLinkedActions = new HashMap();

    protected void initialize() {
        this.myLinkedActions = this.getFactoryDefaultActions().getStartupActions();
    }

    protected abstract FactoryDefaultActions getFactoryDefaultActions();

    public Action getAction(String menu, String item) {
        String key = menu + "." + item;
        return (Action)this.myLinkedActions.get(key);
    }

    public HashMap getCurrentActions() {
        return this.myLinkedActions;
    }

    public HashMap getDefaultActions() {
        return this.getFactoryDefaultActions().getStartupActions();
    }

    protected JButton getAccelleratedToolBarButton(String menu, String item) {
        Action action = this.getAction(menu, item);
        return ActiveActions.makeToolBarButton(action);
    }

    public JButton getToolBarButton(String menu, String item) {
        JButton rtnMe = this.getAccelleratedToolBarButton(menu, item);
        return rtnMe;
    }

    protected JCheckBox makeCheckBox(String menu, String item) {
        JCheckBox rtnMe = null;
        Action action = this.getAction(menu, item);
        rtnMe = action != null ? new JCheckBox(action) : new JCheckBox("unknown");
        return rtnMe;
    }

    protected JMenuItem makeMenuItem(String menu, String item) {
        JMenuItem rtnMe = null;
        Action action = this.getAction(menu, item);
        rtnMe = action != null ? new JMenuItem(action) : new JMenuItem("unknown");
        return rtnMe;
    }

    public static JButton makeToolBarButton(Action action) {
        JButton rtnMe = new JButton(action);
        Dimension size = new Dimension(23, 23);
        rtnMe.setMaximumSize(size);
        rtnMe.setPreferredSize(size);
        rtnMe.setEnabled(true);
        rtnMe.setText(null);
        return rtnMe;
    }

    public static String makeKey(String application, String menu, String item) {
        return application + "." + menu + "." + item;
    }

    public static Action loadAction(String resourseKey, Action action, Icon icon) {
        String retrieved = null;
        String itemKey = null;
        try {
            itemKey = resourseKey + ".label";
            retrieved = AppStarter.getString(itemKey);
            action.putValue("Name", retrieved);
        }
        catch (Exception ex) {
            System.out.println("-------------------------------------------");
            System.out.println("loadAction label: " + ex.getLocalizedMessage());
            System.out.println(itemKey + ": " + retrieved);
        }
        try {
            itemKey = resourseKey + ".tip";
            retrieved = AppStarter.getString(itemKey);
            action.putValue("ShortDescription", retrieved);
        }
        catch (Exception ex) {
            System.out.println("-------------------------------------------");
            System.out.println("loadAction tip: " + ex.getLocalizedMessage());
            System.out.println(itemKey + ": " + retrieved);
        }
        try {
            itemKey = resourseKey + ".mnemonic";
            retrieved = AppStarter.getString(itemKey);
            int keyCode = ActionHelpers.getKeyCode(retrieved);
            action.putValue("MnemonicKey", new Integer(keyCode));
        }
        catch (Exception ex) {
            System.out.println("-------------------------------------------");
            System.out.println("loadAction mnemonic: " + ex.getLocalizedMessage());
            System.out.println(itemKey + ": " + retrieved);
        }
        try {
            itemKey = resourseKey + ".accelerator";
            retrieved = AppStarter.getString(itemKey);
            if (!retrieved.trim().equals("null")) {
                KeyStroke ks = KeyStroke.getKeyStroke(retrieved);
                action.putValue("AcceleratorKey", ks);
            }
        }
        catch (Exception ex) {
            System.out.println("-------------------------------------------");
            System.out.println("loadAction mnemonic: " + ex.getLocalizedMessage());
            System.out.println(itemKey + ": " + retrieved);
        }
        action.putValue("SmallIcon", icon);
        return action;
    }

    public class MenuOverrides {
        public MenuOverrides() {
            if (AppStarter.isJava6Enabled()) {
                KeyChangerXML kc = new KeyChangerXML();
                File readFile = ViewerPreferences.getKeyChangerFile();
                kc.remapActionsFromXML(readFile, ActiveActions.this.myLinkedActions);
            }
        }
    }
}

