/*
 * Decompiled with CFR 0.152.
 */
package org.gerhardb.lib.util.startup;

import com.saic.isd.util.ArgList;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.swing.JOptionPane;
import org.gerhardb.lib.util.startup.AppStarter;

public class AppPluginStartup {
    public static final String JIBS_OUT = "JIBS OUT";
    private static final String DOUBLE_QUOTE = "\"";
    private static final String SPACE = " ";
    private static final String JIBS_PREFERENCES_PARAMETER = "-Djava.util.prefs.PreferencesFactory=org.gerhardb.lib.util.startup.AppPreferencesFactory";
    private static final String PATH_SEPARATOR = System.getProperty("path.separator");
    private static final String JAVA_COMMAND = System.getProperty("java.home") + File.separator + "bin" + File.separator + "java" + " ";
    private static String clsRunCommand = "Started JIBS Directly";
    private static String clsPropsFileName;
    private static boolean iFoundPlugins;

    public static String getRunCommand() {
        return clsRunCommand;
    }

    public static void startupAppWithPlugins(String mainClass, String propsFileName, String[] args) {
        String memory;
        clsPropsFileName = propsFileName;
        AppStarter.log("##################################################");
        AppStarter.log("Jibs Plugin Startup Booting Jibs");
        AppStarter.log("##################################################");
        StringBuffer runMe = new StringBuffer(300);
        runMe.append(JAVA_COMMAND);
        String propFilePath = AppPluginStartup.loadPreferences(args);
        if (propFilePath != null) {
            AppStarter.log("USING PREFERENCES FROM JIBS PROPERTY FILE!");
            runMe.append(JIBS_PREFERENCES_PARAMETER);
        }
        if ((memory = AppPluginStartup.getMemoryParameter(args)) != null) {
            runMe.append(memory);
        }
        runMe.append(" -classpath ");
        runMe.append(DOUBLE_QUOTE);
        runMe.append(AppPluginStartup.getClasspaths());
        runMe.append(DOUBLE_QUOTE);
        runMe.append(SPACE);
        runMe.append(mainClass);
        runMe.append(SPACE);
        runMe.append(AppPluginStartup.strippedArgsToString(args));
        if (iFoundPlugins) {
            AppStarter.log("PLUGINS FOUND!");
        }
        if (propFilePath != null) {
            runMe.append(SPACE);
            runMe.append(propFilePath);
        }
        AppStarter.log("STARTING WITH COMMAND LINE!");
        AppPluginStartup.clsRunCommandLine(runMe.toString());
    }

    private static String loadPreferences(String[] args) {
        ArgList argList = new ArgList(args);
        File propFile = null;
        if (argList.isOption("-props")) {
            File parent;
            String propFileName = argList.getOption("-props");
            AppStarter.log("JibsPluginStartup Loading Jibs PROPS from: " + propFileName);
            if (propFileName == null || propFileName.length() == 0) {
                JOptionPane.showMessageDialog(null, "No prop file specified \n\nLoading JIBS with standard settings", "JIBS Start Problem", 0);
                return null;
            }
            propFile = new File(propFileName);
            boolean propFileOK = propFile.exists();
            if (!propFileOK && (parent = propFile.getParentFile()) != null) {
                propFileOK = parent.exists();
            }
            if (propFileOK) {
                propFileName = propFile.getAbsolutePath();
                return "-props \"" + propFileName + DOUBLE_QUOTE;
            }
            JOptionPane.showMessageDialog(null, "Invalid path: \n" + propFileName + "\nLoading JIBS with standard settings", "JIBS Start Problem", 0);
            return null;
        }
        if (argList.isOption("-thumbdrive")) {
            File startDir = AppStarter.getStartupDirectory();
            AppStarter.log("Loading Jibs THUMBDRIVE from: " + startDir);
            if (startDir != null) {
                String propFileName = startDir.getAbsolutePath() + "/" + clsPropsFileName;
                return "-thumbdrive \"" + propFileName + DOUBLE_QUOTE;
            }
        } else {
            File[] startupDirList;
            AppStarter.log("JibsPluginStartup Checking Jibs LOCAL DRIVE");
            File startDir = AppStarter.getStartupDirectory();
            if (startDir != null && (startupDirList = startDir.listFiles()) != null) {
                for (int i = 0; i < startupDirList.length; ++i) {
                    if (!startupDirList[i].getName().equalsIgnoreCase(clsPropsFileName)) continue;
                    String propFileName = startupDirList[i].getAbsolutePath();
                    return "-props \"" + propFileName + DOUBLE_QUOTE;
                }
            }
        }
        return null;
    }

    private static String strippedArgsToString(String[] args) {
        StringBuffer buff = new StringBuffer(100);
        for (int i = 0; i < args.length; ++i) {
            if ("-props".equalsIgnoreCase(args[i])) {
                ++i;
                continue;
            }
            if ("-thumbdrive".equalsIgnoreCase(args[i])) continue;
            buff.append(' ');
            buff.append(DOUBLE_QUOTE);
            buff.append(args[i]);
            buff.append(DOUBLE_QUOTE);
        }
        return buff.toString();
    }

    private static String getClasspaths() {
        String classpaths;
        StringBuffer pluginBuff = new StringBuffer(200);
        File starupDir = AppStarter.getStartupDirectory();
        File[] startupDirList = starupDir.listFiles();
        if (startupDirList != null) {
            for (int i = 0; i < startupDirList.length; ++i) {
                if (!startupDirList[i].getName().endsWith("ij.jar")) continue;
                pluginBuff.append(PATH_SEPARATOR + startupDirList[i].getAbsolutePath());
            }
        }
        if ((classpaths = System.getProperty("java.class.path")) != null) {
            if (iFoundPlugins) {
                return classpaths + pluginBuff.toString();
            }
            return classpaths;
        }
        if (iFoundPlugins) {
            return pluginBuff.toString().substring(1);
        }
        return null;
    }

    private static String getMemoryParameter(String[] args) {
        String version = System.getProperty("java.version");
        if (!version.startsWith("1.6")) {
            AppStarter.log("Starting Legacy JIBS (anything not Java 1.6)");
            StringBuffer allArgs = new StringBuffer(300);
            for (int i = 0; i < args.length; ++i) {
                allArgs.append(args[i]);
            }
            StringBuffer javaBuff = new StringBuffer(30);
            if (allArgs.indexOf("-Xms") == -1) {
                javaBuff.append(" -Xms40M");
            }
            if (allArgs.indexOf("-Xmx") == -1) {
                javaBuff.append(" -Xmx100M");
            }
            if (javaBuff.length() > 0) {
                return javaBuff.toString();
            }
            return null;
        }
        AppStarter.log("Starting JIBS for Java 1.6");
        return null;
    }

    private static void clsRunCommandLine(String runMe) {
        clsRunCommand = runMe;
        Runtime runtime = Runtime.getRuntime();
        try {
            Process process = runtime.exec(runMe);
            InputStream is = process.getInputStream();
            InputStreamReader isr = new InputStreamReader(is);
            BufferedReader br = new BufferedReader(isr);
            AppStarter.log("##################################################");
            AppStarter.log("Switching output to runtime");
            AppStarter.log("Run Command: \n" + runMe);
            AppStarter.log("##################################################");
            try {
                String line;
                while ((line = br.readLine()) != null) {
                    if (JIBS_OUT.equals(line)) {
                        System.exit(0);
                    }
                    AppStarter.log(line);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void testArgs(String[] args) {
        System.out.println(args.length);
        AppStarter.log(AppPluginStartup.strippedArgsToString(new String[0]));
        AppStarter.log(AppPluginStartup.strippedArgsToString(new String[]{"-props", "sample"}));
        AppStarter.log(AppPluginStartup.strippedArgsToString(new String[]{"-thumbdrive"}));
        AppStarter.log(AppPluginStartup.strippedArgsToString(new String[]{"-props", "sample", "-view", "home"}));
        AppStarter.log(AppPluginStartup.strippedArgsToString(new String[]{"-thumbdrive", "-view", "home"}));
    }

    static {
        iFoundPlugins = false;
    }
}

