/*
 * Decompiled with CFR 0.152.
 */
package org.gerhardb.lib.util.startup;

import com.saic.isd.util.ArgList;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Date;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.prefs.Preferences;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileSystemView;
import org.gerhardb.lib.dirtree.DTNWriter;
import org.gerhardb.lib.dirtree.rdp.PathManager;
import org.gerhardb.lib.util.startup.AppPreferencesFactory;

public class AppStarter {
    private static ResourceBundle resources;
    public static final Date TIME_STARTED;
    static final String PROPS = "-props";
    static final String THUMBDRIVE = "-thumbdrive";
    private static boolean clsThumbdrive;
    private static File clsMyDocsDir;
    static boolean iAmJava6Enabled;
    public static PrintWriter clsLogStream;

    private AppStarter() {
    }

    public static boolean isJava6Enabled() {
        if (!iAmJava6Enabled) {
            System.out.println("Featurce called which is not Java 6 enabled while running Java 1.5 or Java 5.");
        }
        return iAmJava6Enabled;
    }

    public static void starupApp(String[] args, String bundleName, boolean usePropParams) {
        String version = System.getProperty("java.version");
        System.out.println("==================================> Jibs6Hacks java.version: " + version);
        if (version.startsWith("1.4") || version.startsWith("1.5")) {
            System.out.println("Java 1.4 or 1.5 found.  Turning off Java 6 features.");
            iAmJava6Enabled = false;
        }
        AppStarter.log("Bundle: " + bundleName);
        resources = ResourceBundle.getBundle(bundleName, Locale.getDefault());
        AppStarter.log("Bundle Resources: " + resources);
        ArgList argList = new ArgList(args);
        try {
            if (usePropParams && AppStarter.useCustomAppPropertyFile(argList)) {
                AppPreferencesFactory.initializeProps();
            }
            AppPreferencesFactory.InfoToConsole();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        AppStarter.log("********************************");
        AppStarter.log("AppStarter Starting Up the Application");
        AppStarter.log("Loaded Jibs from: " + AppStarter.getStartupDirectory());
        AppStarter.log("Java Prefs: " + Preferences.userRoot().getClass());
        AppStarter.log("Pref File: " + System.getProperty("jibs.props"));
        AppStarter.log("********************************");
        if (args != null && args.length == 1) {
            File clickedOnJibs = new File(args[0]);
            if (clickedOnJibs.exists() && clickedOnJibs.isFile()) {
                PathManager.setStartingJibsFile(clickedOnJibs);
            }
        } else {
            PathManager.overrideInitialDirectories(argList.getOption("-tree"), argList.getOption("-view"));
        }
    }

    public static void closeDownApp() {
        if (clsLogStream != null) {
            clsLogStream.flush();
            clsLogStream.close();
        }
    }

    public static void log(String msg) {
        System.out.println(msg);
        if (clsLogStream != null) {
            clsLogStream.println(msg);
            clsLogStream.flush();
        }
    }

    public static String getString(String key) {
        try {
            return resources.getString(key);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return '!' + key + '!';
        }
    }

    public static boolean isThumbdrive() {
        return clsThumbdrive;
    }

    public static File getStartupDirectory() {
        String errMsg = "No starting URL provided";
        try {
            URL startURL = AppStarter.class.getProtectionDomain().getCodeSource().getLocation();
            errMsg = startURL.toString();
            String startPath = startURL.getPath();
            startPath = URLDecoder.decode(startPath, "UTF-8");
            File startupFile = new File(startPath);
            if (startupFile.exists()) {
                if (startupFile.isDirectory()) {
                    return startupFile;
                }
                return startupFile.getParentFile();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        JOptionPane.showMessageDialog(null, "JIBS does not understand start path of: \n" + errMsg, "JIBS Start Problem", 0);
        System.exit(99);
        return null;
    }

    public static File getMyDocumentsDir() {
        if (clsMyDocsDir == null) {
            JFileChooser fr = new JFileChooser();
            FileSystemView fw = fr.getFileSystemView();
            clsMyDocsDir = fw.getDefaultDirectory();
        }
        return clsMyDocsDir;
    }

    public static File getMyPicturesDir() {
        File myPics;
        File rtnMe = AppStarter.getMyDocumentsDir();
        String os = System.getProperty("os.name").toLowerCase();
        if (os.startsWith("windows") && (myPics = new File(rtnMe.getAbsolutePath() + "/My Pictures")).exists() && myPics.isDirectory()) {
            return myPics;
        }
        return rtnMe;
    }

    static boolean useCustomAppPropertyFile(ArgList argList) {
        if (argList.isOption(PROPS)) {
            String propFileName = argList.getOption(PROPS);
            if (propFileName == null || propFileName.length() == 0) {
                return false;
            }
            System.setProperty("jibs.props", propFileName);
            return true;
        }
        if (argList.isOption(THUMBDRIVE)) {
            String propFileName = argList.getOption(THUMBDRIVE);
            System.setProperty("jibs.props", propFileName);
            clsThumbdrive = true;
            return true;
        }
        return false;
    }

    public static void showArgs(String[] args) {
        String fileName = "C:/gbroot/jibsLOG.txt";
        File file = new File(fileName);
        try {
            clsLogStream = new PrintWriter(new BufferedWriter(new FileWriter(file)));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        AppStarter.log("Jibs Startup");
        AppStarter.log("##################################################");
        for (int i = 0; i < args.length; ++i) {
            AppStarter.log(args[i]);
        }
        AppStarter.log("##################################################");
        File[] roots = File.listRoots();
        for (int i = 0; i < roots.length; ++i) {
            AppStarter.log(DTNWriter.getNameOfDrive(roots[i].toString()));
        }
        AppStarter.log("##################################################");
    }

    public static void testMain(String[] args) {
        String country;
        String language;
        AppStarter.log(AppStarter.class.getName());
        if (args.length != 2) {
            language = new String("en");
            country = new String("US");
        } else {
            language = new String(args[0]);
            country = new String(args[1]);
        }
        Locale currentLocale = new Locale(language, country);
        AppStarter.log("Locale: " + currentLocale);
        currentLocale = Locale.getDefault();
        AppStarter.log("Locale: " + currentLocale);
        ResourceBundle messages = ResourceBundle.getBundle("org.gerhardb.jibs.Jibs");
        AppStarter.log(messages.getString("AboutBox.title"));
        Locale[] locales = Locale.getAvailableLocales();
        for (int i = 0; i < locales.length; ++i) {
            AppStarter.log("Available Locale: " + locales[i]);
        }
        Locale.setDefault(Locale.GERMANY);
        AppStarter.log("German Locale: " + Locale.GERMANY);
        AppStarter.log("Current Locale: " + Locale.getDefault());
        messages = ResourceBundle.getBundle("org.gerhardb.jibs.Jibs", Locale.getDefault());
        AppStarter.log("German: " + messages.getString("AboutBox.title"));
    }

    static {
        TIME_STARTED = new Date();
        clsThumbdrive = false;
        iAmJava6Enabled = true;
    }
}

