/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.builder;

import org.exolab.castor.builder.ClassInfo;
import org.exolab.castor.builder.SourceGenerator;
import org.exolab.castor.builder.XMLInfo;
import org.exolab.castor.builder.types.XSType;
import org.exolab.castor.xml.JavaNaming;
import org.exolab.javasource.JClass;
import org.exolab.javasource.JDocComment;
import org.exolab.javasource.JDocDescriptor;
import org.exolab.javasource.JField;
import org.exolab.javasource.JMethod;
import org.exolab.javasource.JModifiers;
import org.exolab.javasource.JParameter;
import org.exolab.javasource.JSourceCode;
import org.exolab.javasource.JType;

public class FieldInfo
extends XMLInfo {
    private String name = null;
    private ClassInfo declaringClassInfo = null;
    private String _comment = null;
    private String _default = null;
    private String _fixed = null;
    private boolean _final = false;
    private boolean _static = false;
    private boolean _transient = false;
    private boolean _bound = false;
    private boolean _isContainer = false;
    private String _fieldHandler;
    private String _validator;

    public FieldInfo(XSType xSType, String string) {
        this.name = string;
        this.setSchemaType(xSType);
        this._bound = SourceGenerator.boundPropertiesEnabled();
    }

    public void createJavaField(JClass jClass) {
        XSType xSType = this.getSchemaType();
        JType jType = xSType.getJType();
        JField jField = new JField(xSType.getJType(), this.name);
        if (this._static || this._final) {
            JModifiers jModifiers = jField.getModifiers();
            jModifiers.setFinal(this._final);
            jModifiers.setStatic(this._static);
        }
        if (this._default != null) {
            jField.setInitString(this._default);
        }
        if (this._fixed != null && !this.getSchemaType().isDateTime()) {
            jField.setInitString(this._fixed);
        }
        if (this._comment != null) {
            jField.setComment(this._comment);
        }
        jClass.addField(jField);
        if (!xSType.isEnumerated() && jType.isPrimitive()) {
            jField = new JField(JType.Boolean, "_has" + this.name);
            if (this._fixed != null) {
                jField.setInitString("true");
            }
            jField.setComment("keeps track of state for field: " + this.name);
            jClass.addField(jField);
        }
    }

    public void createAccessMethods(JClass jClass) {
        String string;
        JMethod jMethod = null;
        JSourceCode jSourceCode = null;
        String string2 = this.methodSuffix();
        XSType xSType = this.getSchemaType();
        JType jType = xSType.getJType();
        boolean bl = !xSType.isEnumerated() && jType.isPrimitive();
        jMethod = new JMethod(jType, "get" + string2);
        jClass.addMethod(jMethod);
        this.createGetterComment(jMethod.getJDocComment());
        jSourceCode = jMethod.getSourceCode();
        jSourceCode.add("return this.");
        jSourceCode.append(this.name);
        jSourceCode.append(";");
        jMethod = new JMethod(null, "set" + string2);
        jClass.addMethod(jMethod);
        String string3 = this.name;
        if (string3.indexOf(95) == 0 && JavaNaming.isValidJavaIdentifier(string = string3.substring(1))) {
            string3 = string;
        }
        jMethod.addParameter(new JParameter(jType, string3));
        this.createSetterComment(jMethod.getJDocComment());
        jSourceCode = jMethod.getSourceCode();
        if (this._bound) {
            jSourceCode.add("java.lang.Object old");
            jSourceCode.append(string2);
            jSourceCode.append(" = ");
            jSourceCode.append(xSType.createToJavaObjectCode("this." + this.getName()));
            jSourceCode.append(";");
        }
        jSourceCode.add("this.");
        jSourceCode.append(this.getName());
        jSourceCode.append(" = ");
        jSourceCode.append(string3);
        jSourceCode.append(";");
        if (bl) {
            jSourceCode.add("this._has");
            jSourceCode.append(this.getName());
            jSourceCode.append(" = true;");
            jMethod = new JMethod(JType.Boolean, "has" + string2);
            jClass.addMethod(jMethod);
            jSourceCode = jMethod.getSourceCode();
            jSourceCode.add("return this._has");
            jSourceCode.append(this.getName());
            jSourceCode.append(";");
            if (!this.isRequired()) {
                jMethod = new JMethod(null, "delete" + string2);
                jClass.addMethod(jMethod);
                jSourceCode = jMethod.getSourceCode();
                jSourceCode.add("this._has");
                jSourceCode.append(this.getName());
                jSourceCode.append("= false;");
            }
        }
        if (this._bound) {
            jSourceCode.add("notifyPropertyChangeListeners(\"");
            jSourceCode.append(this.getName());
            jSourceCode.append("\", old");
            jSourceCode.append(string2);
            jSourceCode.append(", ");
            jSourceCode.append(xSType.createToJavaObjectCode("this." + this.getName()));
            jSourceCode.append(");");
        }
    }

    public void createGetterComment(JDocComment jDocComment) {
        String string = this.name;
        if (string.indexOf(95) == 0) {
            string = string.substring(1);
        }
        String string2 = "the value of field '" + string + "'.";
        String string3 = "Returns " + string2;
        if (this._comment != null && this._comment.length() > 0) {
            string3 = string3 + " The field '" + string + "' has the following description: ";
            string3 = string3 + this._comment;
        }
        jDocComment.appendComment(string3);
        jDocComment.addDescriptor(JDocDescriptor.createReturnDesc(string2));
    }

    public void createSetterComment(JDocComment jDocComment) {
        String string = this.name;
        if (string.indexOf(95) == 0) {
            string = string.substring(1);
        }
        String string2 = "the value of field '" + string + "'.";
        String string3 = "Sets " + string2;
        if (this._comment != null && this._comment.length() > 0) {
            string3 = string3 + " The field '" + string + "' has the following description: ";
            string3 = string3 + this._comment;
        }
        jDocComment.appendComment(string3);
        JDocDescriptor jDocDescriptor = jDocComment.getParamDescriptor(string);
        if (jDocDescriptor == null) {
            jDocDescriptor = JDocDescriptor.createParamDesc(string, null);
            jDocComment.addDescriptor(jDocDescriptor);
        }
        jDocDescriptor.setDescription(string2);
    }

    public String getDefaultValue() {
        return this._default;
    }

    public String getFixedValue() {
        return this._fixed;
    }

    public String getDeleteMethodName() {
        return "delete" + this.methodSuffix();
    }

    public String getHasMethodName() {
        return "has" + this.methodSuffix();
    }

    public String getReadMethodName() {
        return "get" + this.methodSuffix();
    }

    public String getValidator() {
        return this._validator;
    }

    public String getWriteMethodName() {
        if (this.isMultivalued()) {
            return "add" + this.methodSuffix();
        }
        return "set" + this.methodSuffix();
    }

    public String getXMLFieldHandler() {
        return this._fieldHandler;
    }

    public void generateInitializerCode(JSourceCode jSourceCode) {
        if (!this.getSchemaType().isPrimitive()) {
            String string = this.getDefaultValue();
            boolean bl = this.getSchemaType().isDateTime();
            if (string == null) {
                string = this.getFixedValue();
            }
            if (string != null) {
                StringBuffer stringBuffer = new StringBuffer(50);
                if (bl) {
                    jSourceCode.add("try {");
                    jSourceCode.indent();
                }
                stringBuffer.append("set");
                stringBuffer.append(this.methodSuffix());
                stringBuffer.append('(');
                stringBuffer.append(string);
                stringBuffer.append(");");
                jSourceCode.add(stringBuffer.toString());
                if (bl) {
                    jSourceCode.unindent();
                    jSourceCode.add("} catch (java.text.ParseException pe) {");
                    jSourceCode.indent();
                    jSourceCode.add("throw new IllegalStateException(pe.getMessage());");
                    jSourceCode.unindent();
                    jSourceCode.add("}");
                }
            }
        }
    }

    public String getComment() {
        return this._comment;
    }

    public String getName() {
        return this.name;
    }

    public boolean isBound() {
        return this._bound;
    }

    public boolean isContainer() {
        return this._isContainer;
    }

    public boolean isTransient() {
        return this._transient || this._final || this._static;
    }

    public void setComment(String string) {
        this._comment = string;
    }

    public ClassInfo getDeclaringClassInfo() {
        return this.declaringClassInfo;
    }

    public void setBound(boolean bl) {
        this._bound = bl;
    }

    public void setContainer(boolean bl) {
        this._isContainer = bl;
    }

    public void setDeclaringClassInfo(ClassInfo classInfo) {
        this.declaringClassInfo = classInfo;
    }

    public void setDefaultValue(String string) {
        this._default = string;
    }

    public void setFinal(boolean bl) {
        this._final = bl;
    }

    public void setFixedValue(String string) {
        this._fixed = string;
    }

    public void setStatic(boolean bl) {
        this._static = bl;
    }

    public void setTransient(boolean bl) {
        this._transient = bl;
    }

    public void setValidator(String string) {
        this._validator = string;
    }

    public void setXMLFieldHandler(String string) {
        this._fieldHandler = string;
    }

    protected String methodSuffix() {
        if (this.name.startsWith("_")) {
            return JavaNaming.toJavaClassName(this.name.substring(1));
        }
        return JavaNaming.toJavaClassName(this.name);
    }
}

