/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.builder.types;

import java.util.Enumeration;
import org.exolab.castor.builder.types.XSPatternBase;
import org.exolab.castor.builder.types.XSType;
import org.exolab.castor.xml.schema.Facet;
import org.exolab.castor.xml.schema.SimpleType;
import org.exolab.javasource.JClass;
import org.exolab.javasource.JSourceCode;
import org.exolab.javasource.JType;

public final class XSString
extends XSPatternBase {
    private static final JType jType = new JClass("java.lang.String");
    private int _length = 0;
    private int maxLength = -1;
    private int minLength = 0;
    private String _whiteSpace = "preserve";

    public XSString() {
        super((short)1);
    }

    public String createFromJavaObjectCode(String string) {
        return "(String)" + string;
    }

    public JType getJType() {
        return jType;
    }

    public int getMaxLength() {
        return this.maxLength;
    }

    public int getMinLength() {
        return this.minLength;
    }

    public int getLength() {
        return this._length;
    }

    public String getWhiteSpace() {
        return this._whiteSpace;
    }

    public boolean hasMaxLength() {
        return this.maxLength >= 0;
    }

    public boolean hasMinLength() {
        return this.minLength > 0;
    }

    public boolean hasLength() {
        return this._length > 0;
    }

    public boolean hasWhiteSpace() {
        return this._whiteSpace != null;
    }

    public void setLength(int n) {
        this._length = n;
        this.setMaxLength(n);
        this.setMinLength(n);
    }

    public void setMaxLength(int n) {
        this.maxLength = n;
    }

    public void setMinLength(int n) {
        this.minLength = n;
    }

    public void setWhiteSpace(String string) {
        if (string.equals("preserve")) {
            this._whiteSpace = string;
        } else if (string.equals("replace")) {
            this._whiteSpace = string;
        } else if (string.equals("collapse")) {
            this._whiteSpace = string;
        } else {
            System.out.println("Warning : " + string + " is a bad entry for the whiteSpace value");
            this._whiteSpace = string;
        }
    }

    public void setFacets(SimpleType simpleType) {
        Enumeration enumeration = XSType.getFacets(simpleType);
        while (enumeration.hasMoreElements()) {
            Facet facet = (Facet)enumeration.nextElement();
            String string = facet.getName();
            if ("maxLength".equals(string)) {
                this.setMaxLength(facet.toInt());
                continue;
            }
            if ("minLength".equals(string)) {
                this.setMinLength(facet.toInt());
                continue;
            }
            if ("length".equals(string)) {
                this.setLength(facet.toInt());
                continue;
            }
            if ("pattern".equals(string)) {
                this.setPattern(facet.getValue());
                continue;
            }
            if (!"whiteSpace".equals(string)) continue;
            this.setWhiteSpace(facet.getValue());
        }
    }

    public void validationCode(JSourceCode jSourceCode, String string, String string2) {
        String string3;
        if (jSourceCode == null) {
            jSourceCode = new JSourceCode();
        }
        jSourceCode.add("StringValidator typeValidator = new StringValidator();");
        if (this.hasMinLength() && !this.hasLength()) {
            jSourceCode.add("typeValidator.setMinLength(");
            jSourceCode.append(Integer.toString(this.getMinLength()));
            jSourceCode.append(");");
        }
        if (this.hasMaxLength() && !this.hasLength()) {
            jSourceCode.add("typeValidator.setMaxLength(");
            jSourceCode.append(Integer.toString(this.getMaxLength()));
            jSourceCode.append(");");
        }
        if (this.hasLength()) {
            jSourceCode.add("typeValidator.setLength(");
            jSourceCode.append(Integer.toString(this.getLength()));
            jSourceCode.append(");");
        }
        if (this.hasWhiteSpace()) {
            jSourceCode.add("typeValidator.setWhiteSpace(\"");
            jSourceCode.append(this.getWhiteSpace());
            jSourceCode.append("\");");
        }
        if (string != null) {
            jSourceCode.add("typeValidator.setFixed(");
            jSourceCode.append(string);
            jSourceCode.append(");");
        }
        if ((string3 = this.getPattern()) != null) {
            jSourceCode.add("typeValidator.setPattern(\"");
            jSourceCode.append(XSType.escapePattern(string3));
            jSourceCode.append("\");");
        }
        jSourceCode.add(string2 + ".setValidator(typeValidator);");
    }
}

