/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.jdo.engine;

import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import org.exolab.castor.jdo.engine.BaseFactory;
import org.exolab.castor.jdo.engine.JDOClassDescriptor;
import org.exolab.castor.jdo.engine.JDOFieldDescriptor;
import org.exolab.castor.jdo.engine.KeyGeneratorDescriptor;
import org.exolab.castor.jdo.engine.KeyGeneratorRegistry;
import org.exolab.castor.jdo.engine.SQLTypes;
import org.exolab.castor.mapping.ClassDescriptor;
import org.exolab.castor.mapping.CollectionHandler;
import org.exolab.castor.mapping.FieldDescriptor;
import org.exolab.castor.mapping.MappingException;
import org.exolab.castor.mapping.TypeConvertor;
import org.exolab.castor.mapping.loader.ClassDescriptorImpl;
import org.exolab.castor.mapping.loader.FieldDescriptorImpl;
import org.exolab.castor.mapping.loader.MappingLoader;
import org.exolab.castor.mapping.loader.TypeInfo;
import org.exolab.castor.mapping.loader.Types;
import org.exolab.castor.mapping.xml.CacheTypeMapping;
import org.exolab.castor.mapping.xml.ClassMapping;
import org.exolab.castor.mapping.xml.FieldMapping;
import org.exolab.castor.mapping.xml.KeyGeneratorDef;
import org.exolab.castor.mapping.xml.MappingRoot;
import org.exolab.castor.mapping.xml.Param;
import org.exolab.castor.mapping.xml.types.DirtyType;
import org.exolab.castor.util.Messages;

public class JDOMappingLoader
extends MappingLoader {
    private static final String IgnoreDirty = "ignore";
    private Hashtable _keyGenDefs = new Hashtable();
    private Hashtable _keyGenDescs = new Hashtable();
    private BaseFactory _factory;
    private KeyGeneratorRegistry _keyGenReg = new KeyGeneratorRegistry();

    public JDOMappingLoader(ClassLoader classLoader, PrintWriter printWriter) {
        super(classLoader, printWriter);
    }

    protected ClassDescriptor createDescriptor(ClassMapping classMapping) throws MappingException {
        Object object;
        Serializable serializable;
        if (classMapping.getMapTo() == null || classMapping.getMapTo().getTable() == null) {
            return MappingLoader.NoDescriptor;
        }
        ClassDescriptor classDescriptor = this.loadClassDescriptor(classMapping.getName());
        if (classDescriptor != null && classDescriptor instanceof JDOClassDescriptor) {
            return classDescriptor;
        }
        classDescriptor = super.createDescriptor(classMapping);
        if (classDescriptor.getIdentity() == null) {
            throw new MappingException("mapping.noIdentity", classDescriptor.getJavaClass().getName());
        }
        String string = classMapping.getKeyGenerator();
        KeyGeneratorDescriptor keyGeneratorDescriptor = null;
        if (string != null) {
            serializable = (KeyGeneratorDef)this._keyGenDefs.get(string);
            Properties properties = new Properties();
            object = string;
            if (serializable != null) {
                object = ((KeyGeneratorDef)serializable).getName();
                Enumeration enumeration = ((KeyGeneratorDef)serializable).enumerateParam();
                while (enumeration.hasMoreElements()) {
                    Param param = (Param)enumeration.nextElement();
                    ((Hashtable)properties).put(param.getName(), param.getValue());
                }
            }
            if ((keyGeneratorDescriptor = (KeyGeneratorDescriptor)this._keyGenDescs.get(string)) == null) {
                keyGeneratorDescriptor = new KeyGeneratorDescriptor(string, (String)object, properties, this._keyGenReg);
                this._keyGenDescs.put(string, keyGeneratorDescriptor);
            }
        }
        object = (serializable = classMapping.getCacheTypeMapping()) != null ? new JDOClassDescriptor(classDescriptor, classMapping.getMapTo().getTable(), keyGeneratorDescriptor, ((CacheTypeMapping)serializable).getType().toString(), ((CacheTypeMapping)serializable).getCapacity()) : new JDOClassDescriptor(classDescriptor, classMapping.getMapTo().getTable(), keyGeneratorDescriptor, null, 0);
        ((ClassDescriptorImpl)object).setMapping(classMapping);
        return object;
    }

    protected TypeInfo getTypeInfo(Class clazz, CollectionHandler collectionHandler, FieldMapping fieldMapping) throws MappingException {
        TypeConvertor typeConvertor = null;
        TypeConvertor typeConvertor2 = null;
        String string = null;
        String string2 = null;
        Class clazz2 = null;
        clazz = Types.typeFromPrimitive(clazz);
        if (fieldMapping.getSql() != null && fieldMapping.getSql().getType().length > 0) {
            string2 = fieldMapping.getSql().getType()[0];
            clazz2 = SQLTypes.typeFromName(string2);
        } else {
            clazz2 = clazz;
        }
        if (this._factory != null) {
            clazz2 = this._factory.adjustSqlType(clazz2);
        }
        if (clazz != clazz2) {
            typeConvertor = SQLTypes.getConvertor(clazz2, clazz);
            typeConvertor2 = SQLTypes.getConvertor(clazz, clazz2);
            if (string2 != null) {
                string = SQLTypes.paramFromName(string2);
            }
        }
        return new TypeInfo(clazz, typeConvertor, typeConvertor2, string, fieldMapping.getRequired(), null, collectionHandler);
    }

    protected FieldDescriptor createFieldDesc(Class clazz, FieldMapping fieldMapping) throws MappingException {
        int[] nArray;
        if (fieldMapping.getSql() == null) {
            return super.createFieldDesc(clazz, fieldMapping);
        }
        FieldDescriptor fieldDescriptor = super.createFieldDesc(clazz, fieldMapping);
        String[] stringArray = fieldMapping.getSql().getName();
        int n = fieldMapping.getSql().getType().length;
        if (n > 0) {
            nArray = new int[n];
            int n2 = 0;
            while (n2 < n) {
                Class clazz2 = SQLTypes.typeFromName(fieldMapping.getSql().getType()[n2]);
                if (this._factory != null) {
                    clazz2 = this._factory.adjustSqlType(clazz2);
                }
                nArray[n2] = SQLTypes.getSQLType(clazz2);
                ++n2;
            }
        } else {
            Class clazz3 = fieldDescriptor.getFieldType();
            if (this._factory != null) {
                clazz3 = this._factory.adjustSqlType(clazz3);
            }
            nArray = new int[]{SQLTypes.getSQLType(clazz3)};
        }
        return new JDOFieldDescriptor((FieldDescriptorImpl)fieldDescriptor, stringArray, nArray, !DirtyType.IGNORE.equals(fieldMapping.getSql().getDirty()), fieldMapping.getSql().getManyTable(), fieldMapping.getSql().getManyKey(), fieldMapping.getSql().getReadonly());
    }

    public void loadMapping(MappingRoot mappingRoot, Object object) throws MappingException {
        this._factory = (BaseFactory)object;
        Enumeration enumeration = mappingRoot.enumerateKeyGeneratorDef();
        while (enumeration.hasMoreElements()) {
            KeyGeneratorDef keyGeneratorDef = (KeyGeneratorDef)enumeration.nextElement();
            String string = keyGeneratorDef.getAlias();
            if (string == null) {
                string = keyGeneratorDef.getName();
            }
            if (this._keyGenDefs.get(string) != null) {
                throw new MappingException(Messages.format("mapping.dupKeyGen", string));
            }
            this._keyGenDefs.put(string, keyGeneratorDef);
        }
        super.loadMapping(mappingRoot, null);
        this._keyGenDefs = null;
        this._keyGenDescs = null;
        this._keyGenReg = null;
    }
}

