/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.persist;

import java.lang.reflect.Array;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import org.exolab.castor.jdo.LockNotGrantedException;
import org.exolab.castor.jdo.PersistenceException;
import org.exolab.castor.mapping.AccessMode;
import org.exolab.castor.persist.ClassMolder;
import org.exolab.castor.persist.Lazy;
import org.exolab.castor.persist.LockEngine;
import org.exolab.castor.persist.OID;
import org.exolab.castor.persist.TransactionContext;
import org.exolab.castor.persist.TxSynchronizable;

public class RelationCollection
implements Collection,
Lazy,
TxSynchronizable {
    private TransactionContext _tx;
    private LockEngine _engine;
    private ClassMolder _molder;
    private AccessMode _accessMode;
    private OID _oid;
    private ArrayList _ids;
    private ArrayList _deleted;
    private ArrayList _added;
    private Map _loaded;
    private int _changecount;
    private int _size;

    public RelationCollection(TransactionContext transactionContext, OID oID, LockEngine lockEngine, ClassMolder classMolder, AccessMode accessMode, ArrayList arrayList) {
        this._tx = transactionContext;
        this._oid = oID;
        this._molder = classMolder;
        this._engine = lockEngine;
        this._accessMode = accessMode;
        if (arrayList == null) {
            arrayList = new ArrayList();
        }
        this._ids = arrayList;
        this._size = this._ids.size();
        this._deleted = new ArrayList();
        this._added = new ArrayList();
        this._loaded = new HashMap();
    }

    public boolean add(Object object) {
        Object object2 = this._molder.getIdentity(this._tx, object);
        if (this._ids.contains(object2)) {
            if (this._deleted.contains(object2)) {
                ((AbstractCollection)this._deleted).remove(object2);
                this._loaded.put(object2, object);
                ++this._changecount;
                ++this._size;
                return true;
            }
            return this._loaded.put(object2, object) != object;
        }
        if (this._deleted.contains(object2)) {
            throw new RuntimeException("Illegal Internal State.");
        }
        if (this._added.add(object2)) {
            this._loaded.put(object2, object);
            ++this._changecount;
            ++this._size;
            return true;
        }
        return this._loaded.put(object2, object) != object;
    }

    public boolean addAll(Collection collection) {
        boolean bl = false;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            if (!this.add(iterator.next())) continue;
            bl = true;
        }
        if (bl) {
            ++this._changecount;
        }
        return bl;
    }

    public void clear() {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            iterator.next();
            iterator.remove();
        }
    }

    public boolean contains(Object object) {
        Object object2 = this._molder.getIdentity(this._tx, object);
        if (this._added.contains(object2)) {
            return true;
        }
        return this._ids.contains(object2) && !this._deleted.contains(object2);
    }

    public boolean containsAll(Collection collection) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            if (this.contains(iterator.next())) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object object) {
        return this == object;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public Iterator iterator() {
        return new IteratorImp(this);
    }

    public boolean remove(Object object) {
        Object object2 = this._molder.getIdentity(this._tx, object);
        boolean bl = false;
        if (this._deleted.contains(object2)) {
            return false;
        }
        if (this._added.contains(object2)) {
            ((AbstractCollection)this._added).remove(object2);
            ++this._changecount;
            --this._size;
            return true;
        }
        if (this._ids.contains(object2)) {
            this._loaded.put(object2, object);
            this._deleted.add(object2);
            ++this._changecount;
            --this._size;
            return true;
        }
        return false;
    }

    public boolean removeAll(Collection collection) {
        boolean bl = false;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            if (!this.remove(iterator.next())) continue;
            bl = true;
        }
        if (bl) {
            ++this._changecount;
        }
        return bl;
    }

    public boolean retainAll(Collection collection) {
        boolean bl = false;
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (collection.contains(e)) continue;
            bl = true;
            iterator.remove();
        }
        if (bl) {
            ++this._changecount;
        }
        return bl;
    }

    public int size() {
        return this._size;
    }

    public Object[] toArray() {
        Object[] objectArray = new Object[this.size()];
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            objectArray = (Object[])iterator.next();
        }
        return objectArray;
    }

    public Object[] toArray(Object[] objectArray) {
        if (objectArray == null) {
            throw new NullPointerException();
        }
        int n = this.size();
        Object[] objectArray2 = n < objectArray.length ? objectArray : (Object[])Array.newInstance(objectArray.getClass().getComponentType(), n);
        Iterator iterator = this.iterator();
        int n2 = 0;
        while (iterator.hasNext()) {
            objectArray2[n2++] = iterator.next();
        }
        while (n2 < objectArray2.length) {
            objectArray2[n2++] = null;
        }
        return objectArray2;
    }

    public ArrayList getIdentitiesList() {
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(this._ids);
        arrayList.addAll(this._added);
        ((AbstractCollection)arrayList).removeAll(this._deleted);
        return arrayList;
    }

    public Object find(Object object) {
        return this._loaded.get(object);
    }

    public ArrayList getDeleted() {
        return (ArrayList)this._deleted.clone();
    }

    public ArrayList getAdded() {
        return (ArrayList)this._added.clone();
    }

    public void committed(TransactionContext transactionContext) {
        if (transactionContext == this._tx) {
            this._added = new ArrayList();
            this._deleted = new ArrayList();
            this._changecount = 0;
            transactionContext.removeTxSynchronizable(this);
        }
    }

    public void rolledback(TransactionContext transactionContext) {
        this.committed(transactionContext);
    }

    private class IteratorImp
    implements Iterator {
        private int changestamp;
        private int cursor;
        private int iterationsize;
        private RelationCollection parent;

        private IteratorImp(RelationCollection relationCollection2) {
            this.parent = relationCollection2;
            this.changestamp = relationCollection2._changecount;
            this.iterationsize = this.parent._added.size() + this.parent._ids.size();
        }

        public boolean hasNext() {
            if (this.changestamp != this.parent._changecount) {
                throw new ConcurrentModificationException("Concurrent Modification is not allowed!");
            }
            if (this.cursor >= RelationCollection.this._added.size()) {
                while (this.cursor < this.iterationsize && this.isSkipped(RelationCollection.this._ids.get(this.cursor - RelationCollection.this._added.size()))) {
                    ++this.cursor;
                }
            }
            return this.cursor < this.iterationsize;
        }

        public Object next() {
            if (this.changestamp != this.parent._changecount) {
                throw new ConcurrentModificationException("Concurrent Modification is not allowed!");
            }
            if (!this.hasNext()) {
                throw new NoSuchElementException("Read after the end of iterator!");
            }
            if (this.cursor < RelationCollection.this._added.size()) {
                Object e = RelationCollection.this._added.get(this.cursor++);
                Object v = RelationCollection.this._loaded.get(e);
                if (v != null) {
                    return v;
                }
                return this.lazyLoad(e);
            }
            Object e = RelationCollection.this._ids.get(this.cursor++ - RelationCollection.this._added.size());
            Object v = RelationCollection.this._loaded.get(e);
            if (v != null) {
                return v;
            }
            return this.lazyLoad(e);
        }

        private boolean isSkipped(Object object) {
            if (RelationCollection.this._deleted.contains(object)) {
                return true;
            }
            OID oID = new OID(this.parent._engine, this.parent._molder, object);
            return this.parent._tx.isDeletedByOID(oID);
        }

        private Object lazyLoad(Object object) {
            if (!RelationCollection.this._tx.isOpen()) {
                throw new RuntimeException("Transaction is closed!");
            }
            try {
                Object object2 = this.parent._tx.load(this.parent._engine, this.parent._molder, object, null, null);
                this.parent._loaded.put(object, object2);
                return object2;
            }
            catch (LockNotGrantedException lockNotGrantedException) {
                throw new RuntimeException("Lock Not Granted for lazy loaded object\n" + lockNotGrantedException);
            }
            catch (PersistenceException persistenceException) {
                throw new RuntimeException("PersistenceException for lazy loaded object\n" + persistenceException);
            }
        }

        public void remove() {
            if (this.cursor <= 0) {
                throw new IllegalStateException("Method next() must be called before remove!");
            }
            if (this.changestamp != this.parent._changecount) {
                throw new ConcurrentModificationException("Concurrent Modification is not allowed!");
            }
            --this.cursor;
            if (this.cursor < RelationCollection.this._added.size()) {
                this.parent._added.remove(this.cursor);
                this.parent._size--;
                --this.iterationsize;
                this.parent._changecount++;
                this.changestamp = this.parent._changecount;
            } else {
                Object e = RelationCollection.this._ids.get(this.cursor);
                while (RelationCollection.this._deleted.contains(e)) {
                    e = RelationCollection.this._ids.get(this.cursor--);
                }
                if (this.cursor < RelationCollection.this._added.size()) {
                    ((AbstractCollection)this.parent._added).remove(e);
                    this.parent._size--;
                    --this.iterationsize;
                    this.parent._changecount++;
                    this.changestamp = this.parent._changecount;
                } else {
                    this.parent._deleted.add(e);
                    this.parent._size--;
                    this.parent._changecount++;
                    ++this.cursor;
                    this.changestamp = this.parent._changecount;
                }
            }
        }
    }
}

