/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.types;

import java.io.Serializable;
import java.text.ParseException;
import org.exolab.castor.types.OperationNotSupportedException;
import org.exolab.castor.types.RecurringDuration;
import org.exolab.castor.types.TimeDuration;
import org.exolab.castor.xml.ValidationException;

public abstract class RecurringDurationBase
implements Serializable {
    private TimeDuration _period = null;
    private TimeDuration _duration = null;
    private short _hour = 0;
    private short _minute = 0;
    private short _second = 0;
    private short _millsecond = 0;
    private short _zoneHour = 0;
    private short _zoneMinute = 0;
    private boolean _UTC = false;
    private boolean _zoneNegative = false;
    private boolean _isNegative = false;

    protected RecurringDurationBase() {
    }

    protected RecurringDurationBase(TimeDuration timeDuration, TimeDuration timeDuration2) {
        try {
            this.setDuration(timeDuration);
            this.setPeriodInternal(timeDuration2);
        }
        catch (OperationNotSupportedException operationNotSupportedException) {
            String string = "Recurring Duration :" + operationNotSupportedException;
            throw new IllegalArgumentException(string);
        }
    }

    protected RecurringDurationBase(String string, String string2) throws IllegalArgumentException {
        try {
            this.setDuration(TimeDuration.parseTimeDuration(string));
            this.setPeriodInternal(TimeDuration.parseTimeDuration(string2));
        }
        catch (Exception exception) {
            String string3 = "In RecurringDurationBase : " + exception;
            throw new IllegalArgumentException(string3);
        }
    }

    protected RecurringDurationBase(String string, String string2, short[] sArray) throws OperationNotSupportedException {
        new RecurringDuration(string, string2);
        if (sArray.length != 6) {
            throw new IllegalArgumentException("Wrong numbers of values");
        }
        this.setValues(sArray);
    }

    private void setPeriodInternal(TimeDuration timeDuration) {
        this._period = timeDuration;
    }

    public void setPeriod(TimeDuration timeDuration) throws OperationNotSupportedException {
        this.setPeriodInternal(timeDuration);
    }

    public void setPeriod(String string) throws OperationNotSupportedException {
        try {
            this.setPeriodInternal(TimeDuration.parseTimeDuration(string));
        }
        catch (ParseException parseException) {
            String string2 = "RecurringDuration, setPeriod:" + parseException;
            throw new IllegalArgumentException(string2);
        }
    }

    public void setDuration(TimeDuration timeDuration) throws OperationNotSupportedException {
        this._duration = timeDuration;
    }

    public void setDuration(String string) throws OperationNotSupportedException {
        try {
            this._duration = TimeDuration.parseTimeDuration(string);
        }
        catch (ParseException parseException) {
            String string2 = "RecurringDuration, setDuration:" + parseException;
            throw new IllegalArgumentException(string2);
        }
    }

    public void setHour(short s) throws OperationNotSupportedException {
        String string = "";
        if (s > 23) {
            string = "the hour field (" + s + ")must be strictly lower than 24";
            throw new IllegalArgumentException(string);
        }
        this._hour = s;
    }

    public void setMinute(short s) throws OperationNotSupportedException {
        String string = "";
        if (s == -1 && this._hour != -1) {
            string = "minute cannot be omitted if the previous field is not omitted.";
            throw new IllegalArgumentException(string);
        }
        if (s > 59) {
            string = "the minute field (" + s + ")must be lower than 59";
            throw new IllegalArgumentException(string);
        }
        this._minute = s;
    }

    public void setSecond(short s, short s2) throws OperationNotSupportedException {
        String string = "";
        if (s == -1 && this._minute != -1) {
            string = "second cannot be omitted if the previous field is not omitted.";
            throw new IllegalArgumentException(string);
        }
        if (s > 60) {
            string = "the second field (" + s + ")must be lower than 60";
            throw new IllegalArgumentException(string);
        }
        this._second = s;
        this._millsecond = s2;
    }

    public void setZone(short s, short s2) throws OperationNotSupportedException {
        String string = "";
        if (s > 23) {
            string = "the zone hour field (" + s + ")must be strictly lower than 24";
            throw new IllegalArgumentException(string);
        }
        this._zoneHour = s;
        if (s2 > 59) {
            string = "the minute field (" + s2 + ")must be lower than 59";
            throw new IllegalArgumentException(string);
        }
        this._zoneMinute = s2;
    }

    public void setValues(short[] sArray) throws OperationNotSupportedException {
        this.setHour(sArray[0]);
        this.setMinute(sArray[1]);
        this.setSecond(sArray[2], sArray[3]);
        this.setZone(sArray[4], sArray[5]);
    }

    public void setNegative() {
        this._isNegative = true;
    }

    public void setZoneNegative() throws OperationNotSupportedException {
        this._zoneNegative = true;
    }

    public void setUTC() {
        this._UTC = true;
    }

    public TimeDuration getPeriod() {
        return this._period;
    }

    public TimeDuration getDuration() {
        return this._duration;
    }

    public short getHour() {
        return this._hour;
    }

    public short getMinute() {
        return this._minute;
    }

    public short getSeconds() {
        return this._second;
    }

    public short getMilli() {
        return this._millsecond;
    }

    public short getZoneHour() {
        return this._zoneHour;
    }

    public short getZoneMinute() {
        return this._zoneMinute;
    }

    public short[] getValues() {
        short[] sArray = null;
        sArray = new short[]{this.getHour(), this.getMinute(), this.getSeconds(), this.getMilli(), this.getZoneHour(), this.getZoneMinute()};
        return sArray;
    }

    public boolean isUTC() {
        this._UTC = this._zoneHour == 0 && this._zoneMinute == 0;
        return this._UTC;
    }

    public boolean isNegative() {
        return this._isNegative;
    }

    public boolean isZoneNegative() {
        return this._zoneNegative;
    }

    public boolean equals(Object object) {
        if (object instanceof RecurringDurationBase) {
            try {
                return this.equal((RecurringDurationBase)object);
            }
            catch (ValidationException validationException) {
                validationException.printStackTrace();
                return false;
            }
        }
        return false;
    }

    public boolean equal(RecurringDurationBase recurringDurationBase) throws ValidationException {
        boolean bl = false;
        if (!this.getPeriod().equals(recurringDurationBase.getPeriod()) || !this.getDuration().equals(recurringDurationBase.getDuration())) {
            String string = " Recurring Duration which have different values for the duration and period can not be compared";
            throw new ValidationException(string);
        }
        bl = this.getHour() == recurringDurationBase.getHour();
        bl = bl && this.getMinute() == recurringDurationBase.getMinute();
        bl = bl && this.getSeconds() == recurringDurationBase.getSeconds();
        bl = bl && this.getMilli() == recurringDurationBase.getMilli();
        boolean bl2 = bl = bl && this.isNegative() == this.isNegative();
        if (!recurringDurationBase.isUTC()) {
            bl = bl && !this.isUTC();
            bl = bl && this.getZoneHour() == recurringDurationBase.getZoneHour();
            bl = bl && this.getZoneMinute() == recurringDurationBase.getZoneMinute();
        }
        return bl;
    }

    public boolean isGreater(RecurringDurationBase recurringDurationBase) throws ValidationException {
        boolean bl = false;
        if (!this.getPeriod().equals(recurringDurationBase.getPeriod()) || !this.getDuration().equals(recurringDurationBase.getDuration())) {
            String string = " Recurring Duration which have different values for the duration and period can not be compared";
            throw new ValidationException(string);
        }
        short[] sArray = this.getValues();
        short[] sArray2 = recurringDurationBase.getValues();
        int n = 0;
        while (!bl || n < sArray.length) {
            boolean bl2 = bl = sArray[n] > sArray2[n];
            if (sArray[n] < sArray2[n]) {
                return false;
            }
            ++n;
        }
        return bl;
    }
}

