/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.xml;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import org.exolab.castor.mapping.Mapping;
import org.exolab.castor.mapping.MappingException;
import org.exolab.castor.util.Configuration;
import org.exolab.castor.util.LocalConfiguration;
import org.exolab.castor.xml.ClassDescriptorResolver;
import org.exolab.castor.xml.EventProducer;
import org.exolab.castor.xml.FileLocation;
import org.exolab.castor.xml.IDResolver;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.UnmarshalHandler;
import org.exolab.castor.xml.UnmarshalListener;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.XMLMappingLoader;
import org.exolab.castor.xml.util.ClassDescriptorResolverImpl;
import org.exolab.castor.xml.util.DOMEventProducer;
import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.XMLReaderAdapter;

public class Unmarshaller {
    private ClassDescriptorResolver _cdResolver = null;
    private Class _class = null;
    private boolean _clearCollections = false;
    private Configuration _config = null;
    private IDResolver _idResolver = null;
    private boolean _ignoreExtraAtts = true;
    private boolean _ignoreExtraElements = false;
    private Object _instanceObj = null;
    EntityResolver entityResolver = null;
    private ClassLoader _loader = null;
    private PrintWriter _pw = null;
    private boolean _debug = false;
    private boolean _reuseObjects = false;
    private UnmarshalListener _unmarshalListener = null;
    private boolean _validate = false;

    public Unmarshaller() {
        this(null, null);
    }

    public Unmarshaller(Class clazz) {
        this(clazz, null);
    }

    public Unmarshaller(Class clazz, ClassLoader classLoader) {
        this.initConfig();
        this._class = clazz;
        this._loader = classLoader;
        this._cdResolver = new ClassDescriptorResolverImpl(classLoader);
    }

    public Unmarshaller(Mapping mapping) throws MappingException {
        this.initConfig();
        if (mapping != null) {
            this.setMapping(mapping);
            this._loader = mapping.getClassLoader();
        }
    }

    public Unmarshaller(Object object) {
        this.initConfig();
        if (object != null) {
            this._class = object.getClass();
            this._loader = this._class.getClassLoader();
        }
        this._instanceObj = object;
    }

    private void initConfig() {
        this._config = LocalConfiguration.getInstance();
        this._debug = this._config.debug();
        this._validate = this._config.marshallingValidation();
        this._ignoreExtraElements = !this._config.strictElements();
    }

    public UnmarshalHandler createHandler() {
        UnmarshalHandler unmarshalHandler = new UnmarshalHandler(this._class);
        if (this._cdResolver == null) {
            this._cdResolver = new ClassDescriptorResolverImpl(this._loader);
        }
        unmarshalHandler.setResolver(this._cdResolver);
        unmarshalHandler.setLogWriter(this._pw);
        unmarshalHandler.setClearCollections(this._clearCollections);
        unmarshalHandler.setDebug(this._debug);
        unmarshalHandler.setReuseObjects(this._reuseObjects);
        unmarshalHandler.setValidation(this._validate);
        unmarshalHandler.setIgnoreExtraAttributes(this._ignoreExtraAtts);
        unmarshalHandler.setIgnoreExtraElements(this._ignoreExtraElements);
        unmarshalHandler.setConfiguration(this._config);
        if (this._instanceObj != null) {
            unmarshalHandler.setRootObject(this._instanceObj);
        }
        if (this._idResolver != null) {
            unmarshalHandler.setIDResolver(this._idResolver);
        }
        if (this._loader != null) {
            unmarshalHandler.setClassLoader(this._loader);
        }
        if (this._unmarshalListener != null) {
            unmarshalHandler.setUnmarshalListener(this._unmarshalListener);
        }
        return unmarshalHandler;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this._loader = classLoader;
    }

    public void setClearCollections(boolean bl) {
        this._clearCollections = bl;
    }

    public void setDebug(boolean bl) {
        this._debug = bl;
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        this.entityResolver = entityResolver;
    }

    public void setIDResolver(IDResolver iDResolver) {
        this._idResolver = iDResolver;
    }

    public void setIgnoreExtraAttributes(boolean bl) {
        this._ignoreExtraAtts = bl;
    }

    public void setIgnoreExtraElements(boolean bl) {
        this._ignoreExtraElements = bl;
    }

    public void setLogWriter(PrintWriter printWriter) {
        this._pw = printWriter;
    }

    public void setMapping(Mapping mapping) throws MappingException {
        if (this._loader == null) {
            this._loader = mapping.getClassLoader();
        }
        if (this._cdResolver == null) {
            this._cdResolver = new ClassDescriptorResolverImpl(this._loader);
        }
        this._cdResolver.setMappingLoader((XMLMappingLoader)mapping.getResolver(Mapping.XML));
    }

    public void setReuseObjects(boolean bl) {
        this._reuseObjects = bl;
    }

    public void setResolver(ClassDescriptorResolver classDescriptorResolver) {
        this._cdResolver = classDescriptorResolver != null ? classDescriptorResolver : new ClassDescriptorResolverImpl(this._loader);
    }

    public void setUnmarshalListener(UnmarshalListener unmarshalListener) {
        this._unmarshalListener = unmarshalListener;
    }

    public void setValidation(boolean bl) {
        this._validate = bl;
    }

    public Object unmarshal(Reader reader) throws MarshalException, ValidationException {
        return this.unmarshal(new InputSource(reader));
    }

    public Object unmarshal(EventProducer eventProducer) throws MarshalException, ValidationException {
        UnmarshalHandler unmarshalHandler = this.createHandler();
        eventProducer.setDocumentHandler(unmarshalHandler);
        try {
            eventProducer.start();
        }
        catch (SAXException sAXException) {
            Exception exception = sAXException.getException();
            if (exception == null) {
                exception = sAXException;
            }
            MarshalException marshalException = new MarshalException(exception);
            if (unmarshalHandler.getDocumentLocator() != null) {
                FileLocation fileLocation = new FileLocation();
                fileLocation.setFilename(unmarshalHandler.getDocumentLocator().getSystemId());
                fileLocation.setLineNumber(unmarshalHandler.getDocumentLocator().getLineNumber());
                fileLocation.setColumnNumber(unmarshalHandler.getDocumentLocator().getColumnNumber());
                marshalException.setLocation(fileLocation);
            }
            throw marshalException;
        }
        return unmarshalHandler.getObject();
    }

    public Object unmarshal(InputSource inputSource) throws MarshalException, ValidationException {
        Parser parser = this._config.getParser();
        if (parser == null) {
            throw new MarshalException("unable to create parser");
        }
        if (this.entityResolver != null) {
            parser.setEntityResolver(this.entityResolver);
        }
        UnmarshalHandler unmarshalHandler = this.createHandler();
        parser.setDocumentHandler(unmarshalHandler);
        parser.setErrorHandler(unmarshalHandler);
        try {
            parser.parse(inputSource);
        }
        catch (IOException iOException) {
            throw new MarshalException(iOException);
        }
        catch (SAXException sAXException) {
            Exception exception = sAXException.getException();
            if (exception == null) {
                exception = sAXException;
            }
            MarshalException marshalException = new MarshalException(exception);
            if (unmarshalHandler.getDocumentLocator() != null) {
                FileLocation fileLocation = new FileLocation();
                fileLocation.setFilename(unmarshalHandler.getDocumentLocator().getSystemId());
                fileLocation.setLineNumber(unmarshalHandler.getDocumentLocator().getLineNumber());
                fileLocation.setColumnNumber(unmarshalHandler.getDocumentLocator().getColumnNumber());
                marshalException.setLocation(fileLocation);
            }
            throw marshalException;
        }
        return unmarshalHandler.getObject();
    }

    public Object unmarshal(Node node) throws MarshalException, ValidationException {
        return this.unmarshal(new DOMEventProducer(node));
    }

    public static ContentHandler getContentHandler(UnmarshalHandler unmarshalHandler) throws SAXException {
        XMLReaderAdapter xMLReaderAdapter = new XMLReaderAdapter();
        xMLReaderAdapter.setDocumentHandler(unmarshalHandler);
        return xMLReaderAdapter;
    }

    public static Object unmarshal(Class clazz, Reader reader) throws MarshalException, ValidationException {
        Unmarshaller unmarshaller = new Unmarshaller(clazz);
        return unmarshaller.unmarshal(reader);
    }

    public static Object unmarshal(Class clazz, InputSource inputSource) throws MarshalException, ValidationException {
        Unmarshaller unmarshaller = new Unmarshaller(clazz);
        return unmarshaller.unmarshal(inputSource);
    }

    public static Object unmarshal(Class clazz, Node node) throws MarshalException, ValidationException {
        Unmarshaller unmarshaller = new Unmarshaller(clazz);
        return unmarshaller.unmarshal(node);
    }
}

