/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.xml.schema;

import java.util.Enumeration;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.schema.Facet;
import org.exolab.castor.xml.schema.FacetList;
import org.exolab.castor.xml.schema.FacetListEnumerator;
import org.exolab.castor.xml.schema.Referable;
import org.exolab.castor.xml.schema.SimpleTypeReference;
import org.exolab.castor.xml.schema.SimpleTypesFactory;
import org.exolab.castor.xml.schema.Structure;
import org.exolab.castor.xml.schema.XMLType;

public abstract class SimpleType
extends XMLType
implements Referable {
    public static final String FINAL_ALL = "#all";
    public static final String FINAL_LIST = "list";
    public static final String FINAL_UNION = "union";
    public static final String FINAL_RESTRICTION = "restriction";
    private FacetList facets = new FacetList();
    private String _final = null;
    private Structure parent = null;
    private int typeCode = -1;

    public void addFacet(Facet facet) {
        if (facet == null) {
            return;
        }
        String string = facet.getName();
        if (string == null) {
            return;
        }
        this.facets.add(facet);
    }

    public Facet getFacet(String string) {
        Enumeration enumeration = this.getFacets(string);
        if (enumeration == null) {
            return null;
        }
        return (Facet)enumeration.nextElement();
    }

    public Enumeration getFacets(String string) {
        FacetListEnumerator facetListEnumerator = null;
        SimpleType simpleType = (SimpleType)this.getBaseType();
        if (simpleType != null) {
            facetListEnumerator = (FacetListEnumerator)simpleType.getFacets(string);
        }
        facetListEnumerator = new FacetListEnumerator(this.facets, facetListEnumerator);
        facetListEnumerator.setMask(string);
        return facetListEnumerator;
    }

    public Enumeration getFacets() {
        FacetListEnumerator facetListEnumerator = null;
        SimpleType simpleType = (SimpleType)this.getBaseType();
        if (simpleType != null) {
            facetListEnumerator = (FacetListEnumerator)simpleType.getFacets();
        }
        facetListEnumerator = new FacetListEnumerator(this.facets, facetListEnumerator);
        return facetListEnumerator;
    }

    public String getFinal() {
        return this._final;
    }

    public Enumeration getLocalFacets() {
        if (this.facets == null) {
            return null;
        }
        return this.facets.enumerate();
    }

    public SimpleType getBuiltInBaseType() {
        SimpleType simpleType = this;
        while (simpleType != null && !SimpleTypesFactory.isBuiltInType(simpleType.getTypeCode())) {
            simpleType = (SimpleType)simpleType.getBaseType();
        }
        return simpleType;
    }

    public Structure getParent() {
        return this.parent;
    }

    public String getReferenceId() {
        return "datatype:" + this.getName();
    }

    public boolean hasFacet(String string) {
        if (string == null) {
            return false;
        }
        int n = 0;
        while (n < this.facets.size()) {
            Facet facet = this.facets.get(n);
            if (string.equals(facet.getName())) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public boolean isBuiltInType() {
        return SimpleTypesFactory.isBuiltInType(this.typeCode);
    }

    public int getTypeCode() {
        return this.typeCode;
    }

    void setTypeCode(int n) {
        this.typeCode = n;
    }

    public Long getLength() {
        Facet facet = this.getFacet("length");
        if (facet == null) {
            return null;
        }
        try {
            return new Long(facet.toLong());
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Long getMinLength() {
        Facet facet = this.getFacet("minLength");
        if (facet == null) {
            return null;
        }
        try {
            return new Long(facet.toLong());
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Long getMaxLength() {
        Facet facet = this.getFacet("maxLength");
        if (facet == null) {
            return null;
        }
        try {
            return new Long(facet.toLong());
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void setFinal(String string) {
        if (!(string == null || string.equals(FINAL_ALL) || string.equals(FINAL_UNION) || string.equals(FINAL_LIST) || string.equals(FINAL_RESTRICTION))) {
            String string2 = "The value '" + string + "' is not a valid" + "value of the final property.";
            throw new IllegalArgumentException(string2);
        }
        this._final = string;
    }

    public short getStructureType() {
        return 21;
    }

    public void validate() throws ValidationException {
    }

    protected SimpleType createReference(String string) {
        return new SimpleTypeReference(this.getSchema(), string);
    }

    protected static SimpleType resolveReference(SimpleType simpleType) {
        return (SimpleType)simpleType.getType();
    }

    protected void setParent(Structure structure) {
        this.parent = structure;
    }

    protected void copyFacets(SimpleType simpleType) {
        simpleType.facets.add(this.facets);
    }
}

