/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.xml.schema.reader;

import org.exolab.castor.xml.AttributeSet;
import org.exolab.castor.xml.Namespaces;
import org.exolab.castor.xml.XMLException;
import org.exolab.castor.xml.schema.Annotation;
import org.exolab.castor.xml.schema.AttributeDecl;
import org.exolab.castor.xml.schema.AttributeGroupReference;
import org.exolab.castor.xml.schema.ComplexType;
import org.exolab.castor.xml.schema.ContentType;
import org.exolab.castor.xml.schema.Group;
import org.exolab.castor.xml.schema.ModelGroup;
import org.exolab.castor.xml.schema.Resolver;
import org.exolab.castor.xml.schema.Schema;
import org.exolab.castor.xml.schema.SchemaException;
import org.exolab.castor.xml.schema.SchemaNames;
import org.exolab.castor.xml.schema.SimpleType;
import org.exolab.castor.xml.schema.Wildcard;
import org.exolab.castor.xml.schema.XMLType;
import org.exolab.castor.xml.schema.reader.AnnotationUnmarshaller;
import org.exolab.castor.xml.schema.reader.AttributeGroupUnmarshaller;
import org.exolab.castor.xml.schema.reader.AttributeUnmarshaller;
import org.exolab.castor.xml.schema.reader.ComponentReader;
import org.exolab.castor.xml.schema.reader.GroupUnmarshaller;
import org.exolab.castor.xml.schema.reader.ModelGroupUnmarshaller;
import org.exolab.castor.xml.schema.reader.WildcardUnmarshaller;

public class ExtensionUnmarshaller
extends ComponentReader {
    private ComponentReader unmarshaller;
    private int depth = 0;
    private ComplexType _complexType = null;
    private Schema _schema = null;
    private boolean foundAnnotation = false;
    private boolean foundAnyAttribute = false;
    private boolean foundAttributes = false;
    private boolean foundModelGroup = false;

    public ExtensionUnmarshaller(ComplexType complexType, AttributeSet attributeSet, Resolver resolver) throws XMLException {
        this.setResolver(resolver);
        this._complexType = complexType;
        this._schema = complexType.getSchema();
        this._complexType.setDerivationMethod("extension");
        String string = attributeSet.getValue("base");
        if (string != null && string.length() > 0) {
            XMLType xMLType = this._schema.getType(string);
            if (xMLType == null) {
                this._complexType.setBase(string);
            } else {
                Object object;
                if (xMLType.isSimpleType() && this._complexType.isComplexContent()) {
                    object = "In a 'complexContent', the base attribute must be a complexType but " + string + " is a simpleType.\n";
                    this.error((String)object);
                }
                this._complexType.setBaseType(xMLType);
                if (this._complexType.isSimpleContent()) {
                    object = ContentType.valueOf("simpleType");
                    if (xMLType.isSimpleType()) {
                        ((ContentType)object).setSimpleType((SimpleType)xMLType);
                        this._complexType.setContentType((ContentType)object);
                    } else {
                        ComplexType complexType2 = (ComplexType)xMLType;
                        ((ContentType)object).setSimpleType(complexType2.getContentType().getSimpleType());
                        this._complexType.setContentType((ContentType)object);
                        complexType2 = null;
                    }
                }
            }
        }
    }

    public String elementName() {
        return "extension";
    }

    public Object getObject() {
        return null;
    }

    public void startElement(String string, String string2, AttributeSet attributeSet, Namespaces namespaces) throws XMLException {
        if (this.unmarshaller != null) {
            this.unmarshaller.startElement(string, string2, attributeSet, namespaces);
            ++this.depth;
            return;
        }
        if ("anyAttribute".equals(string)) {
            this.foundAnyAttribute = true;
            this.unmarshaller = new WildcardUnmarshaller(this._complexType, this._schema, string, attributeSet, this.getResolver());
        } else if ("attribute".equals(string)) {
            this.foundAttributes = true;
            this.unmarshaller = new AttributeUnmarshaller(this._schema, attributeSet, this.getResolver());
        } else if ("attributeGroup".equals(string)) {
            if (attributeSet.getValue("ref") == null) {
                String string3 = "A complexType may contain referring attribute groups, but not defining ones.";
                this.error(string3);
            }
            this.foundAttributes = true;
            this.unmarshaller = new AttributeGroupUnmarshaller(this._schema, attributeSet);
        } else if (string.equals("group")) {
            if (this.foundAttributes) {
                this.error("'" + string + "' must appear before any attribute " + "definitions when a child of 'complexType'.");
            }
            if (this.foundModelGroup) {
                this.error("'" + string + "' cannot appear as a child of 'complexType' " + "if another 'all', 'sequence', 'choice' or " + "'group' also exists.");
            }
            this.foundModelGroup = true;
            this.unmarshaller = new ModelGroupUnmarshaller(this._schema, attributeSet, this.getResolver());
        } else if (SchemaNames.isGroupName(string) && string != "group") {
            if (this.foundAttributes) {
                this.error("'" + string + "' must appear before attribute " + "definitions in an 'extension' element.");
            }
            if (this.foundModelGroup) {
                this.error("'" + string + "' cannot appear as a child of 'extension' " + "if another 'all', 'sequence', 'choice' or " + "'group' already exists.");
            }
            if (this._complexType.isSimpleContent()) {
                this.error("'" + string + "' may not appear in a 'extension' of " + "'simpleContent'.");
            }
            this.foundModelGroup = true;
            this.unmarshaller = new GroupUnmarshaller(this._schema, string, attributeSet, this.getResolver());
        } else if ("anyAttribute".equals(string)) {
            this.error("anyAttribute is not yet supported.");
        } else if (string.equals("annotation")) {
            if (this.foundAttributes || this.foundModelGroup) {
                this.error("An annotation must appear as the first child of an 'extension' element.");
            }
            if (this.foundAnnotation) {
                this.error("Only one (1) annotation may appear as the child of an 'extension' element.");
            }
            this.foundAnnotation = true;
            this.unmarshaller = new AnnotationUnmarshaller(attributeSet);
        } else {
            this.illegalElement(string);
        }
        this.unmarshaller.setDocumentLocator(this.getDocumentLocator());
    }

    public void endElement(String string, String string2) throws XMLException {
        if (this.unmarshaller != null && this.depth > 0) {
            this.unmarshaller.endElement(string, string2);
            --this.depth;
            return;
        }
        this.unmarshaller.finish();
        if ("anyAttribute".equals(string)) {
            Wildcard wildcard = ((WildcardUnmarshaller)this.unmarshaller).getWildcard();
            try {
                this._complexType.setAnyAttribute(wildcard);
            }
            catch (SchemaException schemaException) {
                throw new IllegalArgumentException(schemaException.getMessage());
            }
        } else if ("attribute".equals(string)) {
            AttributeDecl attributeDecl = ((AttributeUnmarshaller)this.unmarshaller).getAttribute();
            this._complexType.addAttributeDecl(attributeDecl);
        } else if ("attributeGroup".equals(string)) {
            AttributeGroupReference attributeGroupReference = (AttributeGroupReference)this.unmarshaller.getObject();
            this._complexType.addAttributeGroupReference(attributeGroupReference);
        } else if (string.equals("group")) {
            ModelGroup modelGroup = ((ModelGroupUnmarshaller)this.unmarshaller).getGroup();
            this._complexType.addGroup(modelGroup);
        } else if (SchemaNames.isGroupName(string) && string != "group") {
            Group group = ((GroupUnmarshaller)this.unmarshaller).getGroup();
            this._complexType.addGroup(group);
        } else if ("annotation".equals(string)) {
            Annotation annotation = ((AnnotationUnmarshaller)this.unmarshaller).getAnnotation();
            this._complexType.addAnnotation(annotation);
        }
        this.unmarshaller = null;
    }

    public void characters(char[] cArray, int n, int n2) throws XMLException {
        if (this.unmarshaller != null) {
            this.unmarshaller.characters(cArray, n, n2);
        }
    }
}

