/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.xml.schema.reader;

import java.io.IOException;
import org.exolab.castor.net.URIException;
import org.exolab.castor.net.URILocation;
import org.exolab.castor.net.URIResolver;
import org.exolab.castor.xml.AttributeSet;
import org.exolab.castor.xml.XMLException;
import org.exolab.castor.xml.schema.Resolver;
import org.exolab.castor.xml.schema.Schema;
import org.exolab.castor.xml.schema.SchemaException;
import org.exolab.castor.xml.schema.reader.ComponentReader;
import org.exolab.castor.xml.schema.reader.Sax2ComponentReader;
import org.exolab.castor.xml.schema.reader.SchemaUnmarshaller;
import org.exolab.castor.xml.schema.reader.SchemaUnmarshallerState;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class IncludeUnmarshaller
extends ComponentReader {
    public IncludeUnmarshaller(Schema schema, AttributeSet attributeSet, Resolver resolver, URIResolver uRIResolver, Locator locator, SchemaUnmarshallerState schemaUnmarshallerState) throws XMLException {
        Object object;
        this.setResolver(resolver);
        this.setURIResolver(uRIResolver);
        URILocation uRILocation = null;
        String string = attributeSet.getValue("schemaLocation");
        if (string == null) {
            throw new SchemaException("'schemaLocation' attribute missing on 'include'");
        }
        if (string.indexOf("\\") != -1) {
            String string2 = string + " is not a valid URI as defined by IETF RFC 2396.";
            string2 = string2 + "The URI must not contain '\\'.";
            throw new SchemaException(string2);
        }
        try {
            object = locator.getSystemId();
            if (object != null && !((String)object).endsWith("/")) {
                object = ((String)object).substring(0, ((String)object).lastIndexOf("/") + 1);
            }
            uRILocation = this.getURIResolver().resolve(string, (String)object);
        }
        catch (URIException uRIException) {
            throw new XMLException(uRIException);
        }
        if (uRILocation != null) {
            string = uRILocation.toString();
        }
        if (schemaUnmarshallerState.processed(string)) {
            return;
        }
        schemaUnmarshallerState.markAsProcessed(string, schema);
        schema.addInclude(string);
        object = null;
        try {
            object = schemaUnmarshallerState.getConfiguration().getParser();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        if (object == null) {
            throw new SchemaException("Error failed to create parser for include");
        }
        Object object2 = new SchemaUnmarshaller(true, schemaUnmarshallerState, this.getURIResolver());
        ((SchemaUnmarshaller)object2).setSchema(schema);
        Sax2ComponentReader sax2ComponentReader = new Sax2ComponentReader((ComponentReader)object2);
        object.setDocumentHandler(sax2ComponentReader);
        object.setErrorHandler(sax2ComponentReader);
        try {
            object2 = new InputSource(uRILocation.getReader());
            ((InputSource)object2).setSystemId(uRILocation.getAbsoluteURI());
            object.parse((InputSource)object2);
        }
        catch (IOException iOException) {
            throw new SchemaException("Error reading include file '" + string + "'");
        }
        catch (SAXException sAXException) {
            throw new SchemaException(sAXException);
        }
    }

    public String elementName() {
        return "include";
    }

    public Object getObject() {
        return null;
    }
}

