/*
 * Decompiled with CFR 0.152.
 */
package fi.iki.jka;

import fi.iki.jka.JPhoto;
import fi.iki.jka.JPhotoCollection;
import fi.iki.jka.JPhotoList;
import fi.iki.jka.Utils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Label;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class JPhotoBrowser
extends JDialog
implements ListSelectionListener,
ActionListener {
    protected JScrollPane scrollPane = null;
    protected JPhotoList list = null;
    protected JPhotoCollection photos = null;
    protected JTextField textInput = null;
    protected File directory = null;
    protected static String[] result = null;
    protected static File defaultDirectory = null;

    public JPhotoBrowser(JFrame parent, String initialDir) {
        super((Frame)parent, true);
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.add((Component)new Label("Directory:"), "West");
        this.textInput = new JTextField();
        panel.add((Component)this.textInput, "Center");
        JButton button = new JButton("...");
        button.addActionListener(this);
        panel.add((Component)button, "East");
        this.setDirectory(initialDir);
        this.list = new JPhotoList(this.photos, 550);
        this.list.setSelectedIndex(0);
        this.list.setDragEnabled(true);
        this.list.addListSelectionListener(this);
        this.list.addMouseListener(new MouseListener());
        this.scrollPane = new JScrollPane(this.list);
        this.scrollPane.setFocusable(false);
        this.scrollPane.addComponentListener(new ResizeAdapter());
        JPanel panelB = new JPanel();
        panelB.setLayout(new FlowLayout());
        button = new JButton("OK");
        button.addActionListener(this);
        panelB.add(button);
        button = new JButton("Cancel");
        button.addActionListener(this);
        panelB.add(button);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.scrollPane, "Center");
        this.getContentPane().add((Component)panel, "North");
        this.getContentPane().add((Component)panelB, "South");
        this.setDefaultCloseOperation(2);
        InputMap im = this.textInput.getInputMap(1);
        ActionMap am = this.textInput.getActionMap();
        im.put(KeyStroke.getKeyStroke(10, 0), "SelectDirectory");
        am.put("SelectDirectory", new SelectDirectory());
        im = this.list.getInputMap(1);
        am = this.list.getActionMap();
        im.put(KeyStroke.getKeyStroke(10, 0), "OK");
        am.put("OK", new SelectOK());
        this.list.requestFocus();
        this.pack();
        defaultDirectory = null;
        this.setSize(700, 550);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation(screenSize.width / 2 - 350, screenSize.height / 2 - 275);
        this.setVisible(true);
        this.list.requestFocus();
    }

    public void setDirectory(String dir) {
        File dirFile = new File(dir);
        dir = dirFile.getAbsolutePath();
        String[] files = Utils.expandDirectory(dir, true);
        if (dirFile.getParent() != null) {
            int len = 1;
            if (files != null) {
                len = files.length + 1;
            }
            String[] filesAndParent = new String[len];
            filesAndParent[0] = dirFile.getParent();
            if (len > 1) {
                System.arraycopy(files, 0, filesAndParent, 1, len - 1);
            }
            files = filesAndParent;
        }
        if (files == null || files.length == 0) {
            JOptionPane.showMessageDialog(this, "No photos in " + dir, "Browse", 0);
            if (this.directory != null) {
                this.textInput.setText(this.directory.toString());
            }
        } else {
            this.photos = new JPhotoCollection(files);
            this.textInput.setText(dir);
            this.directory = new File(dir);
            if (this.list != null) {
                this.list.setPhotoModel(this.photos);
                this.list.setSelectedIndex(0);
                this.list.setVisibleBounds(this.getSize());
                this.list.recalculateVisibleRows();
            }
        }
    }

    public void actionPerformed(ActionEvent event) {
        String cmd = event.getActionCommand();
        if (cmd.equals("...")) {
            String dir = Utils.getDirectory(this, this.directory);
            if (dir != null) {
                this.setDirectory(dir);
            }
        } else if (cmd.equals("OK")) {
            this.selectedPhotos(this.list.getSelectedValues());
        } else if (cmd.equals("Cancel")) {
            this.dispose();
        } else {
            System.out.println("Not implemented: " + cmd);
        }
    }

    public void valueChanged(ListSelectionEvent e) {
        JPhoto photo = (JPhoto)this.list.getSelectedValue();
        if (e.getValueIsAdjusting()) {
            return;
        }
    }

    public boolean selectedPhotos(Object[] photos) {
        if (photos == null) {
            return false;
        }
        result = new String[photos.length];
        int i = 0;
        while (i < photos.length) {
            JPhotoBrowser.result[i] = ((JPhoto)photos[i]).getFullOriginalName();
            if (new File(result[i]).isDirectory()) {
                this.setDirectory(result[i]);
                return false;
            }
            ++i;
        }
        defaultDirectory = this.directory;
        this.dispose();
        return true;
    }

    static File getDefaultDirectory() {
        return defaultDirectory;
    }

    static String[] getFiles(JFrame parent, File directory) {
        JPhotoBrowser frame = new JPhotoBrowser(parent, directory.toString());
        frame.setTitle("Select photos...");
        if (JPhotoBrowser.getDefaultDirectory() != null) {
            return result;
        }
        return null;
    }

    public static void main(String[] args) throws Exception {
        JPhotoBrowser frame = null;
        frame = new JPhotoBrowser(null, args[0]);
        frame.setDefaultCloseOperation(3);
        frame.setTitle("Select photos...");
    }

    class ResizeAdapter
    extends ComponentAdapter {
        ResizeAdapter() {
        }

        public void componentResized(ComponentEvent e) {
            Dimension dim = JPhotoBrowser.this.scrollPane.getViewport().getSize();
            JPhotoBrowser.this.list.setVisibleBounds(dim);
        }
    }

    class MouseListener
    extends MouseAdapter {
        MouseListener() {
        }

        public void mouseClicked(MouseEvent e) {
            super.mouseClicked(e);
            if (e.getClickCount() == 2) {
                JPhotoBrowser.this.selectedPhotos(JPhotoBrowser.this.list.getSelectedValues());
            }
        }
    }

    class FocusHandler
    extends FocusAdapter {
        FocusHandler() {
        }

        public void focusLost(FocusEvent e) {
            JPhotoBrowser.this.setDirectory(JPhotoBrowser.this.textInput.getText());
        }
    }

    class SelectDirectory
    extends AbstractAction {
        public void actionPerformed(ActionEvent ae) {
            JPhotoBrowser.this.setDirectory(JPhotoBrowser.this.textInput.getText());
        }
    }

    class SelectOK
    extends AbstractAction {
        public void actionPerformed(ActionEvent ae) {
            JPhotoBrowser.this.selectedPhotos(JPhotoBrowser.this.list.getSelectedValues());
        }
    }
}

