/*
 * Decompiled with CFR 0.152.
 */
package fi.iki.jka;

import java.awt.EventQueue;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.ProgressMonitor;

public class JPhotoStatus {
    protected static JFrame parent = null;
    protected static JLabel statusLine = null;
    protected static ProgressMonitor progressMonitor = null;
    protected static boolean canceled = false;
    private JDialog dialog;
    private JProgressBar bar;
    private JLabel label;

    static void setStatusLineLabel(JFrame parentFrame, JLabel text) {
        parent = parentFrame;
        statusLine = text;
    }

    static void showStatus(String caller, String status) {
        if (statusLine != null) {
            statusLine.setText(status);
        }
        if (caller != null) {
            System.out.println(String.valueOf(caller) + ":" + status);
        } else {
            System.out.println(status);
        }
    }

    static void showProgress(final String caller, final String status, final int percentDone) {
        if (parent != null && !EventQueue.isDispatchThread()) {
            try {
                EventQueue.invokeAndWait(new Runnable(){

                    public void run() {
                        JPhotoStatus.showProgress(caller, status, percentDone);
                    }
                });
            }
            catch (Exception e) {
                System.out.println("showProgress invokeAndWait failed:" + e);
                e.printStackTrace();
                e.getCause().printStackTrace();
            }
            return;
        }
        System.out.println(String.valueOf(caller != null ? String.valueOf(caller) + ":" : "") + status + ":" + percentDone + "%");
        if (parent == null) {
            return;
        }
        if (percentDone == 0 && progressMonitor == null) {
            parent.setEnabled(false);
            progressMonitor = new ProgressMonitor(parent, caller, status, 0, 100);
            progressMonitor.setProgress(0);
            progressMonitor.setMillisToDecideToPopup(0);
            JPhotoStatus.setCanceled(false);
        }
        if (progressMonitor.isCanceled()) {
            JPhotoStatus.setCanceled(true);
        } else {
            progressMonitor.setNote(status);
            progressMonitor.setProgress(percentDone);
        }
        if (percentDone >= 100) {
            progressMonitor.close();
            progressMonitor = null;
            parent.setEnabled(true);
            parent.setFocusableWindowState(true);
            parent.requestFocus();
        }
    }

    static boolean inProgress() {
        return progressMonitor != null;
    }

    static void setCanceled(boolean val) {
        canceled = val;
    }

    static boolean isCanceled() {
        return canceled;
    }
}

