/*
 * Decompiled with CFR 0.152.
 */
package com.drew.lang.test;

import com.drew.lang.Rational;
import junit.framework.TestCase;

public class RationalTest
extends TestCase {
    public RationalTest(String string) {
        super(string);
    }

    public void testCreateRational() throws Exception {
        Rational rational = new Rational(1, 3);
        RationalTest.assertEquals((int)1, (int)rational.getNumerator());
        RationalTest.assertEquals((int)3, (int)rational.getDenominator());
        RationalTest.assertEquals((Object)new Double(0.3333333333333333), (Object)new Double(rational.doubleValue()));
    }

    public void testToString() throws Exception {
        Rational rational = new Rational(1, 3);
        RationalTest.assertEquals((String)"1/3", (String)rational.toString());
    }

    public void testToSimpleString() throws Exception {
        Rational rational = new Rational(1, 3);
        Rational rational2 = new Rational(2, 6);
        RationalTest.assertEquals((String)"1/3", (String)rational.toSimpleString(true));
        RationalTest.assertEquals((String)"1/3", (String)rational2.toSimpleString(true));
        RationalTest.assertEquals((Object)rational, (Object)rational2);
        Rational rational3 = new Rational(10, 15);
        RationalTest.assertEquals((String)"2/3", (String)rational3.toSimpleString(true));
        Rational rational4 = new Rational(10, 5);
        RationalTest.assertTrue((boolean)rational4.isInteger());
        RationalTest.assertEquals((String)"2", (String)rational4.toSimpleString(true));
        RationalTest.assertEquals((String)"2", (String)rational4.toSimpleString(false));
        Rational rational5 = new Rational(4, 10);
        RationalTest.assertEquals((String)"0.4", (String)rational5.toSimpleString(true));
        RationalTest.assertEquals((String)"2/5", (String)rational5.toSimpleString(false));
        Rational rational6 = new Rational(3, 8);
        RationalTest.assertEquals((String)"3/8", (String)rational6.toSimpleString(true));
        Rational rational7 = new Rational(0, 8);
        RationalTest.assertTrue((boolean)rational7.isInteger());
        RationalTest.assertEquals((String)"0", (String)rational7.toSimpleString(true));
        RationalTest.assertEquals((String)"0", (String)rational7.toSimpleString(false));
        rational7 = new Rational(0, 0);
        RationalTest.assertTrue((boolean)rational7.isInteger());
        RationalTest.assertEquals((String)"0", (String)rational7.toSimpleString(true));
        RationalTest.assertEquals((String)"0", (String)rational7.toSimpleString(false));
    }

    public void testGetReciprocal() throws Exception {
        Rational rational = new Rational(1, 3);
        Rational rational2 = rational.getReciprocal();
        RationalTest.assertEquals((String)"new rational should be reciprocal", (Object)new Rational(3, 1), (Object)rational2);
        RationalTest.assertEquals((String)"origianl reciprocal should remain unchanged", (Object)new Rational(1, 3), (Object)rational);
    }
}

