/*
 * Decompiled with CFR 0.152.
 */
package pm.gui;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import pm.gui.PM_IndexView;
import pm.gui.PM_PictureView;
import pm.gui.PM_PictureViewDragAndDrop;
import pm.gui.PM_WindowMain;
import pm.picture.PM_Picture;
import pm.utilities.PM_Interface;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PM_IndexViewCollection
implements PM_Interface {
    private final List<PM_Picture> pictureList = new ArrayList<PM_Picture>();
    private final Hashtable<PM_Picture, PM_PictureView> pictureViewTable = new Hashtable();
    private final Set<PM_Picture> pictureClosed = new HashSet<PM_Picture>();
    private PM_PictureView pictureViewSelected = null;
    private PM_WindowMain windowMain;
    private PM_IndexView indexView;

    public PM_IndexViewCollection(PM_WindowMain pM_WindowMain, PM_IndexView pM_IndexView) {
        this.windowMain = pM_WindowMain;
        this.indexView = pM_IndexView;
    }

    private PM_IndexViewCollection() {
    }

    public void paintPictureDeleted(PM_Picture pM_Picture) {
        this.pictureClosed.remove(pM_Picture);
        if (this.hasPictureView(pM_Picture)) {
            PM_PictureView pM_PictureView = this.pictureViewTable.get(pM_Picture);
            pM_PictureView.repaint();
        }
    }

    public void setPictureList(List<PM_Picture> list) {
        this.pictureList.clear();
        this.pictureList.addAll(list);
        this.pictureViewTable.clear();
        this.pictureClosed.clear();
        this.pictureViewSelected = null;
    }

    public void appendPictureList(List<PM_Picture> list) {
        this.pictureList.addAll(list);
    }

    public boolean isPictureViewSelected(PM_PictureView pM_PictureView) {
        if (this.pictureViewSelected == null) {
            return false;
        }
        return this.pictureViewSelected == pM_PictureView;
    }

    public PM_PictureView getPictureViewSelected() {
        return this.pictureViewSelected;
    }

    public void setPictureViewSelected(PM_PictureView pM_PictureView) {
        PM_PictureView pM_PictureView2 = this.pictureViewSelected;
        this.pictureViewSelected = null;
        if (pM_PictureView2 != null) {
            pM_PictureView2.repaint();
        }
        this.pictureViewSelected = pM_PictureView;
        pM_PictureView.repaint();
    }

    public boolean addPicture(PM_Picture pM_Picture, PM_IndexView pM_IndexView, int n) {
        if (this.hasPicture(pM_Picture)) {
            return false;
        }
        if (n == -1) {
            this.pictureList.add(pM_Picture);
        } else if (n < 0 || n > this.pictureList.size()) {
            this.pictureList.add(pM_Picture);
        } else {
            this.pictureList.add(n, pM_Picture);
        }
        return true;
    }

    public boolean removePicture(PM_Picture pM_Picture) {
        if (!this.pictureList.remove(pM_Picture)) {
            return false;
        }
        this.pictureClosed.remove(pM_Picture);
        if (this.hasPictureView(pM_Picture)) {
            PM_PictureView pM_PictureView = this.getPictureView(pM_Picture);
            if (this.pictureViewSelected == pM_PictureView) {
                this.pictureViewSelected = null;
            }
            this.pictureViewTable.remove(pM_Picture);
        }
        return true;
    }

    public void removePictureList(List<PM_Picture> list) {
        this.pictureList.removeAll(list);
        this.pictureClosed.removeAll(list);
        this.removePictureViews(list);
    }

    public void removeAllPicture() {
        this.pictureList.clear();
        this.pictureViewTable.clear();
        this.pictureClosed.clear();
        this.pictureViewSelected = null;
    }

    public PM_Picture getNextPicture(PM_Picture pM_Picture) {
        int n = this.pictureList.indexOf(pM_Picture) + 1;
        if (n >= this.pictureList.size()) {
            return null;
        }
        PM_Picture pM_Picture2 = this.pictureList.get(n);
        if (this.canDisplay(pM_Picture2)) {
            return pM_Picture2;
        }
        return this.getNextPicture(pM_Picture2);
    }

    public PM_Picture getPreviousPicture(PM_Picture pM_Picture) {
        int n = this.pictureList.indexOf(pM_Picture) - 1;
        if (n < 0) {
            return null;
        }
        PM_Picture pM_Picture2 = this.pictureList.get(n);
        if (this.canDisplay(pM_Picture2)) {
            return pM_Picture2;
        }
        return this.getPreviousPicture(pM_Picture2);
    }

    public List<PM_Picture> getPictureListDarstellen() {
        ArrayList<PM_Picture> arrayList = new ArrayList<PM_Picture>(this.pictureList);
        arrayList.removeAll(this.pictureClosed);
        return arrayList;
    }

    public List<PM_Picture> getPictureList() {
        return this.pictureList;
    }

    public void removePictureClosed() {
        this.pictureList.removeAll(this.pictureClosed);
        this.removePictureViews(this.pictureClosed);
        this.pictureClosed.clear();
    }

    public void removePictureDeleted() {
        ArrayList<PM_Picture> arrayList = new ArrayList<PM_Picture>();
        for (PM_Picture pM_Picture : this.pictureList) {
            if (!pM_Picture.meta.isInvalid()) continue;
            arrayList.add(pM_Picture);
        }
        for (PM_Picture pM_Picture : arrayList) {
            this.removePicture(pM_Picture);
        }
    }

    public void closePicture(PM_Picture pM_Picture) {
        this.pictureClosed.add(pM_Picture);
    }

    public void openPicture(PM_Picture pM_Picture) {
        this.pictureClosed.remove(pM_Picture);
    }

    public void removePictureViews(Set<PM_Picture> set) {
        Iterator<PM_Picture> iterator = set.iterator();
        while (iterator.hasNext()) {
            this.pictureViewTable.remove(iterator.next());
        }
    }

    public void removePictureViews(List<PM_Picture> list) {
        Iterator<PM_Picture> iterator = list.iterator();
        while (iterator.hasNext()) {
            PM_PictureView pM_PictureView = this.pictureViewTable.remove(iterator.next());
            if (pM_PictureView != null) continue;
            System.out.println("removePictureViews  nigefu !!!!");
        }
    }

    public void removePictureView(PM_Picture pM_Picture) {
        this.pictureViewTable.remove(pM_Picture);
    }

    private boolean canDisplay(PM_Picture pM_Picture) {
        return this.hasPicture(pM_Picture) && !this.isPictureClosed(pM_Picture);
    }

    public boolean hasPictureView(PM_Picture pM_Picture) {
        return this.pictureViewTable.containsKey(pM_Picture);
    }

    public boolean hasPictureView(int n) {
        if (n >= this.pictureList.size()) {
            return false;
        }
        PM_Picture pM_Picture = this.pictureList.get(n);
        return this.hasPictureView(pM_Picture);
    }

    public PM_PictureView getPictureView(PM_Picture pM_Picture) {
        if (this.pictureViewTable.containsKey(pM_Picture)) {
            return this.pictureViewTable.get(pM_Picture);
        }
        this.addPicture(pM_Picture, this.indexView, -1);
        PM_PictureViewDragAndDrop pM_PictureViewDragAndDrop = new PM_PictureViewDragAndDrop(pM_Picture, this.windowMain, this.indexView);
        this.pictureViewTable.put(pM_Picture, pM_PictureViewDragAndDrop);
        return pM_PictureViewDragAndDrop;
    }

    public int getPictureIndex(PM_Picture pM_Picture) {
        return this.pictureList.indexOf(pM_Picture);
    }

    public void insertPicture(PM_Picture pM_Picture, PM_Picture pM_Picture2) {
        this.pictureList.add(this.pictureList.indexOf(pM_Picture2), pM_Picture);
    }

    public void movePicture(PM_Picture pM_Picture, PM_Picture pM_Picture2) {
        int n = 0;
        if (this.pictureList.indexOf(pM_Picture2) > this.pictureList.indexOf(pM_Picture)) {
            n = 1;
        }
        this.pictureList.remove(pM_Picture);
        this.pictureList.add(this.pictureList.indexOf(pM_Picture2) + n, pM_Picture);
    }

    public void rereadAllPictureViewThumbnail() {
        Enumeration<PM_PictureView> enumeration = this.pictureViewTable.elements();
        while (enumeration.hasMoreElements()) {
            PM_PictureView pM_PictureView = enumeration.nextElement();
            pM_PictureView.flushImageThumbnail();
        }
    }

    public int getSize() {
        return this.pictureList.size();
    }

    public int getSizeDarstellen() {
        return this.sizeDargestellt();
    }

    public int getSizeClosed() {
        return this.pictureClosed.size();
    }

    public boolean isPictureClosed(PM_Picture pM_Picture) {
        return this.pictureClosed.contains(pM_Picture);
    }

    public int sizeDargestellt() {
        int n = this.pictureList.size() - this.pictureClosed.size();
        return n < 0 ? 0 : n;
    }

    public boolean hasPicture(PM_Picture pM_Picture) {
        return this.pictureList.contains(pM_Picture);
    }

    public boolean isEqual(PM_IndexView pM_IndexView) {
        return this.isEqual(pM_IndexView.getPictureListDarstellen());
    }

    public boolean isEqual(List<PM_Picture> list) {
        return ((Object)this.getPictureListDarstellen()).equals(list);
    }
}

