/*
 * Decompiled with CFR 0.152.
 */
package pm.gui;

import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.io.Serializable;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.TransferHandler;
import pm.gui.PM_IndexView;
import pm.gui.PM_PictureView;
import pm.gui.PM_PictureViewTransferHandler;
import pm.gui.PM_WindowBase;
import pm.gui.PM_WindowMain;
import pm.picture.PM_Picture;
import pm.utilities.PM_Interface;

public class PM_PictureViewDragAndDrop
extends PM_PictureView
implements PM_Interface,
MouseMotionListener {
    private MouseEvent firstMouseEvent = null;
    private static PM_PictureViewTransferHandler transferHandler = new PM_PictureViewTransferHandler();
    private static boolean installInputMapBindings = true;

    public PM_PictureViewDragAndDrop(PM_Picture pM_Picture, PM_WindowMain pM_WindowMain, PM_IndexView pM_IndexView) {
        super(pM_Picture, pM_WindowMain, pM_IndexView);
        Serializable serializable;
        this.setTransferHandler(transferHandler);
        this.addMouseMotionListener(this);
        if (installInputMapBindings) {
            serializable = this.getInputMap();
            ((InputMap)serializable).put(KeyStroke.getKeyStroke("ctrl X"), TransferHandler.getCutAction().getValue("Name"));
            ((InputMap)serializable).put(KeyStroke.getKeyStroke("ctrl C"), TransferHandler.getCopyAction().getValue("Name"));
            ((InputMap)serializable).put(KeyStroke.getKeyStroke("ctrl V"), TransferHandler.getPasteAction().getValue("Name"));
        }
        serializable = this.getActionMap();
        ((ActionMap)serializable).put(TransferHandler.getCutAction().getValue("Name"), TransferHandler.getCutAction());
        ((ActionMap)serializable).put(TransferHandler.getCopyAction().getValue("Name"), TransferHandler.getCopyAction());
        ((ActionMap)serializable).put(TransferHandler.getPasteAction().getValue("Name"), TransferHandler.getPasteAction());
    }

    public void mousePressed(MouseEvent mouseEvent) {
        super.mousePressed(mouseEvent);
        this.firstMouseEvent = mouseEvent;
        mouseEvent.consume();
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        PM_IndexView pM_IndexView = this.windowMain.getIndexViewWindowRight();
        PM_IndexView pM_IndexView2 = this.windowMain.getIndexViewThumbnails();
        if (pM_IndexView == null || pM_IndexView2 == null) {
            return;
        }
        if (this.firstMouseEvent != null) {
            mouseEvent.consume();
            int n = Math.abs(mouseEvent.getX()) - this.firstMouseEvent.getX();
            int n2 = Math.abs(mouseEvent.getY()) - this.firstMouseEvent.getY();
            if (n > 5 || n2 > 5) {
                int n3 = 2;
                JComponent jComponent = (JComponent)this.firstMouseEvent.getSource();
                PM_PictureViewTransferHandler pM_PictureViewTransferHandler = (PM_PictureViewTransferHandler)jComponent.getTransferHandler();
                pM_PictureViewTransferHandler.exportAsDrag(jComponent, this.firstMouseEvent, n3);
                if (pM_IndexView.getAllowCrossing()) {
                    pM_IndexView.setWindowsEqual(this.windowsEqual());
                }
                this.firstMouseEvent = null;
            }
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.firstMouseEvent = null;
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public boolean canImport(PM_PictureView pM_PictureView) {
        if (pM_PictureView == null) {
            return false;
        }
        if (this == pM_PictureView) {
            return false;
        }
        if (this.allowedCrossing()) {
            return true;
        }
        if (pM_PictureView.getIndexView().isLeft() && !this.getIndexView().isLeft() && this.getIndexView().getAllowGetFromRight()) {
            return !this.getIndexView().hasPicture(pM_PictureView.getPicture());
        }
        return !pM_PictureView.getIndexView().isLeft() && !this.getIndexView().isLeft();
    }

    public void doImport(PM_PictureView pM_PictureView) {
        PM_IndexView pM_IndexView = this.windowMain.getIndexViewWindowRight();
        PM_IndexView pM_IndexView2 = this.windowMain.getIndexViewThumbnails();
        if (pM_IndexView == null || pM_IndexView2 == null) {
            return;
        }
        if (this.allowedCrossing()) {
            this.movePicture(pM_IndexView, pM_PictureView.getPicture(), this.getPicture());
            this.movePicture(pM_IndexView2, pM_PictureView.getPicture(), this.getPicture());
            return;
        }
        if (pM_PictureView.getIndexView().isLeft() && !this.getIndexView().isLeft() && this.getIndexView().getAllowGetFromRight()) {
            if (!this.insertPicture(this.getIndexView(), pM_PictureView.getPicture(), this.getPicture())) {
                return;
            }
            pM_PictureView.getIndexView().repaintPicture(pM_PictureView.getPicture());
            return;
        }
        if (!pM_PictureView.getIndexView().isLeft() && !this.getIndexView().isLeft()) {
            this.movePicture(pM_PictureView.getIndexView(), pM_PictureView.getPicture(), this.getPicture());
            return;
        }
    }

    private boolean insertPicture(PM_IndexView pM_IndexView, PM_Picture pM_Picture, PM_Picture pM_Picture2) {
        PM_WindowBase pM_WindowBase = this.getWindowBase(pM_IndexView);
        if (pM_WindowBase == null) {
            return false;
        }
        return pM_WindowBase.insertPicture(pM_Picture, pM_Picture2);
    }

    private void movePicture(PM_IndexView pM_IndexView, PM_Picture pM_Picture, PM_Picture pM_Picture2) {
        PM_WindowBase pM_WindowBase = this.getWindowBase(pM_IndexView);
        if (pM_WindowBase == null) {
            return;
        }
        pM_WindowBase.movePicture(pM_Picture, pM_Picture2);
    }

    private PM_WindowBase getWindowBase(PM_IndexView pM_IndexView) {
        if (this.windowMain.getWindowThumbnails().getIndexView() == pM_IndexView) {
            return this.windowMain.getWindowThumbnails();
        }
        if (this.windowMain.getWindowRightSelected().getIndexView() == pM_IndexView) {
            return this.windowMain.getWindowRightSelected();
        }
        return null;
    }

    private boolean windowsEqual() {
        PM_IndexView pM_IndexView = this.windowMain.getIndexViewWindowRight();
        PM_IndexView pM_IndexView2 = this.windowMain.getIndexViewThumbnails();
        if (pM_IndexView == null || pM_IndexView2 == null) {
            return false;
        }
        return pM_IndexView.isEqual(pM_IndexView2);
    }

    private boolean allowedCrossing() {
        PM_IndexView pM_IndexView = this.windowMain.getIndexViewWindowRight();
        return pM_IndexView.getAllowCrossing() && pM_IndexView.getWindowsEqual();
    }
}

