/*
 * Decompiled with CFR 0.152.
 */
package pm.gui;

import java.awt.FlowLayout;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.tree.DefaultMutableTreeNode;
import pm.gui.PM_WindowBase;
import pm.gui.PM_WindowImportGUI;
import pm.gui.PM_WindowMain;
import pm.gui.PM_WindowStatusPanel;
import pm.picture.PM_ImportExternal;
import pm.picture.PM_Picture;
import pm.picture.PM_PictureDirectory;
import pm.picture.PM_Pictures;
import pm.search.PM_Search;
import pm.search.PM_SearchExpr;
import pm.sequence.PM_Sequence;
import pm.sequence.PM_SequenceAlbum;
import pm.sequence.PM_SequenceOriginal;
import pm.sequence.PM_TreeWindow;
import pm.utilities.PM_Interface;
import pm.utilities.PM_Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PM_WindowImport
extends PM_WindowBase
implements PM_Interface {
    private static List<File> newExternalPictureDirs = Collections.synchronizedList(new ArrayList());
    private static PM_WindowImportGUI gui;

    public static boolean addImportFiles(List<File> list) {
        HashSet<String> hashSet = new HashSet<String>();
        for (File file : newExternalPictureDirs) {
            hashSet.add(file.getPath());
        }
        for (File file : list) {
            File file2;
            if (!file.exists() || PM_Utils.isUnderTLD(file)) continue;
            try {
                file2 = file.getCanonicalFile();
            }
            catch (IOException iOException) {
                continue;
            }
            if (hashSet.contains(file2.getPath())) continue;
            newExternalPictureDirs.add(file2);
        }
        return !newExternalPictureDirs.isEmpty();
    }

    public static void setTimer() {
        if (newExternalPictureDirs.isEmpty()) {
            PM_WindowStatusPanel.getInstance().stopImportTimer();
            PM_WindowImport.gui.importButtonExternal.setEnabled(false);
            return;
        }
        PM_WindowStatusPanel.getInstance().startImportTimer();
        PM_WindowImport.gui.importButtonExternal.setEnabled(true);
    }

    public PM_WindowImport(PM_WindowMain pM_WindowMain, int n) {
        super(pM_WindowMain, n, false);
        gui = new PM_WindowImportGUI(this, pM_WindowMain);
        this.setLayout(new FlowLayout(0));
        this.add(new JScrollPane(gui.getComponent()));
    }

    public boolean externalImport() {
        return !newExternalPictureDirs.isEmpty();
    }

    @Override
    public boolean requestToChange() {
        return true;
    }

    public PM_TreeWindow getTreeWindowNew() {
        return PM_WindowImport.gui.treeWindowNew;
    }

    public boolean requestToImport() {
        String string = "Vor dem Import werden alle Darstellungen gel\u00f6scht.";
        int n = JOptionPane.showConfirmDialog(null, string, "Sicherheitsabfrage", 0, 3);
        if (n == 1) {
            return false;
        }
        return this.windowMain.flushAndCloseDisplay();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doImportExternal() {
        ArrayList<File> arrayList = new ArrayList();
        Object object = newExternalPictureDirs;
        synchronized (object) {
            arrayList = new ArrayList<File>(newExternalPictureDirs);
        }
        object = new PM_ImportExternal();
        ((PM_ImportExternal)object).checkAndImport(arrayList);
    }

    @Override
    public void doubleClickOnTree(DefaultMutableTreeNode defaultMutableTreeNode, PM_TreeWindow pM_TreeWindow) {
        List<PM_Picture> list = this.getPictureList(defaultMutableTreeNode);
        if (list.size() == 0) {
            return;
        }
        this.windowMain.getWindowThumbnails().getIndexView().setAndPaintPictureList(list);
    }

    private List<PM_Picture> getPictureList(DefaultMutableTreeNode defaultMutableTreeNode) {
        if (defaultMutableTreeNode == null) {
            return new ArrayList<PM_Picture>();
        }
        Object object = defaultMutableTreeNode.getUserObject();
        if (object instanceof PM_PictureDirectory) {
            PM_PictureDirectory pM_PictureDirectory = (PM_PictureDirectory)object;
            List<File> list = pM_PictureDirectory.getOrigFiles();
            List<PM_Picture> list2 = PM_Pictures.getPictureList(list);
            Collections.sort(list2, PM_Utils.SORT_TIME_ORDER);
            return list2;
        }
        PM_Sequence pM_Sequence = null;
        if (object instanceof PM_Sequence) {
            pM_Sequence = (PM_Sequence)object;
        }
        if (pM_Sequence == null) {
            return new ArrayList<PM_Picture>();
        }
        PM_SearchExpr pM_SearchExpr = new PM_SearchExpr(PM_Interface.SearchType.SEQ);
        pM_SearchExpr.setSequenz(pM_Sequence);
        PM_Search pM_Search = new PM_Search(pM_SearchExpr);
        int n = pM_Search.search();
        if (n == 0) {
            return new ArrayList<PM_Picture>();
        }
        if (pM_Sequence instanceof PM_SequenceOriginal) {
            return pM_Search.getPictureList(PM_Interface.SearchSortType.FILE_PATH);
        }
        if (pM_Sequence instanceof PM_SequenceAlbum && ((PM_SequenceAlbum)pM_Sequence).getSeqClosed() == null) {
            return pM_Search.getPictureList(PM_Interface.SearchSortType.TIME);
        }
        return pM_Search.getPictureList(PM_Interface.SearchSortType.SEQ);
    }
}

