/*
 * Decompiled with CFR 0.152.
 */
package pm.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import pm.gui.PM_PictureView;
import pm.gui.PM_WindowBase;
import pm.gui.PM_WindowMain;
import pm.inout.PM_All_InitValues;
import pm.picture.PM_Picture;
import pm.picture.PM_PictureImageMetadaten;
import pm.utilities.PM_Interface;
import pm.utilities.PM_UtilsGrafik;

public class PM_WindowInfo
extends PM_WindowBase
implements PM_Interface {
    private Image imageThumb = null;
    private Rectangle cutRectangle = null;
    private JPanel windowPicture = null;
    private PM_Picture picture = null;
    private JSplitPane splitPane;
    private JTable exifTable = null;
    private DefaultTableModel tm = new DefaultTableModel();
    private JScrollPane exifTableScrollPane;
    private String lastSelectedKey = "";
    private JTextField exifFeld;

    public PM_WindowInfo(PM_WindowMain pM_WindowMain, int n) {
        super(pM_WindowMain, n, false);
        this.setLayout(new BorderLayout());
        this.splitPane = new JSplitPane(0, this.getPicturePanel(), this.getExifPanel());
        int n2 = PM_All_InitValues.getInstance().getValueInt(this, "devider");
        if (n2 == 0) {
            n2 = 150;
        }
        this.splitPane.setDividerLocation(n2);
        this.add(this.splitPane);
    }

    public void rereadPictureViewThumbnail(PM_Picture pM_Picture) {
        if (pM_Picture != this.picture) {
            return;
        }
        this.setPicture(pM_Picture);
    }

    public void rereadAllThumbs() {
        this.setPicture(null);
    }

    public void close() {
        PM_All_InitValues.getInstance().putValueInt(this, "devider", this.splitPane.getDividerLocation());
    }

    public boolean requestToChange() {
        return true;
    }

    public PM_Picture getPictureSelected() {
        return this.picture;
    }

    public boolean appendPicture(PM_PictureView pM_PictureView) {
        this.setPicture(pM_PictureView.getPicture());
        return true;
    }

    public void setPicture(PM_Picture pM_Picture) {
        if (pM_Picture == null) {
            this.picture = null;
            this.imageThumb = null;
            Vector<Vector> vector = this.tm.getDataVector();
            vector.removeAllElements();
            this.exifFeld.setText("");
            this.windowPicture.repaint();
            return;
        }
        this.picture = pM_Picture;
        this.imageThumb = pM_Picture.getImageThumbnail();
        this.cutRectangle = pM_Picture.meta.hasCutRectangle() ? pM_Picture.meta.getCutRectangle() : null;
        int n = pM_Picture.meta.getRotation();
        this.cutRectangle = this.getCutRectangle(pM_Picture, this.imageThumb, this.cutRectangle, n);
        this.imageThumb = PM_UtilsGrafik.rotate(this.imageThumb, n);
        PM_PictureImageMetadaten pM_PictureImageMetadaten = pM_Picture.getImageMetadaten();
        SortedMap sortedMap = pM_PictureImageMetadaten.getMap();
        Set set = sortedMap.entrySet();
        Vector<Vector> vector = this.tm.getDataVector();
        vector.removeAllElements();
        for (Map.Entry object : set) {
            Vector<Object> vector2 = new Vector<Object>();
            vector2.add(object.getKey());
            vector2.add(object.getValue());
            vector.add(vector2);
        }
        if (this.lastSelectedKey.length() != 0) {
            String string = (String)sortedMap.get(this.lastSelectedKey);
            if (string != null) {
                String string2 = this.lastSelectedKey + ": " + (String)string;
                this.exifFeld.setText(string2);
            } else {
                this.exifFeld.setText("");
            }
        }
        this.exifTable.clearSelection();
        this.exifTable.updateUI();
        this.windowPicture.doLayout();
        this.windowPicture.repaint();
    }

    public int getListDivPos() {
        return 20;
    }

    private JPanel getExifPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(0));
        this.exifFeld = new JTextField();
        jPanel.add(this.exifFeld);
        this.exifFeld.setColumns(40);
        Font font = this.exifFeld.getFont();
        Font font2 = new Font(font.getName(), 1, font.getSize());
        this.exifFeld.setFont(font2);
        this.exifTable = new JTable();
        this.exifTable.setModel(this.tm);
        this.tm.setColumnCount(2);
        this.exifTable.setSelectionMode(0);
        ListSelectionModel listSelectionModel = this.exifTable.getSelectionModel();
        listSelectionModel.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (listSelectionEvent.getValueIsAdjusting()) {
                    int n = PM_WindowInfo.this.exifTable.getSelectedRow();
                    if (n == -1) {
                        PM_WindowInfo.this.exifFeld.setText("");
                        return;
                    }
                    Vector<Vector> vector = PM_WindowInfo.this.tm.getDataVector();
                    Vector vector2 = vector.elementAt(n);
                    PM_WindowInfo.this.lastSelectedKey = (String)vector2.elementAt(0);
                    String string = PM_WindowInfo.this.lastSelectedKey + ": " + (String)vector2.elementAt(1);
                    PM_WindowInfo.this.exifFeld.setText(string);
                }
            }
        });
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout());
        jPanel2.add((Component)jPanel, "North");
        this.exifTableScrollPane = new JScrollPane(this.exifTable);
        jPanel2.add((Component)this.exifTableScrollPane, "Center");
        return jPanel2;
    }

    private JPanel getPicturePanel() {
        this.windowPicture = new JPanel(){

            public void paintComponent(Graphics graphics) {
                PM_WindowInfo.this.doPaintComponent(graphics);
            }
        };
        this.windowPicture.setBackground(Color.YELLOW);
        return this.windowPicture;
    }

    private void doPaintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        if (this.imageThumb != null) {
            graphics.drawImage(this.imageThumb, 20, 20, this);
            Color color = graphics.getColor();
            if (this.cutRectangle != null) {
                graphics.setColor(Color.WHITE);
                graphics.drawRect(this.cutRectangle.x + 20, this.cutRectangle.y + 20, this.cutRectangle.width, this.cutRectangle.height);
            }
            graphics.setColor(color);
            Font font = graphics.getFont();
            Font font2 = new Font(font.getName(), 1, font.getSize());
            graphics.setFont(font2);
            graphics.drawString(this.picture.getFileOriginal().getPath(), 10, 12);
        }
    }

    private Rectangle getCutRectangle(PM_Picture pM_Picture, Image image, Rectangle rectangle, int n) {
        Rectangle rectangle2;
        Rectangle rectangle3 = null;
        if (rectangle != null) {
            rectangle3 = new Rectangle(rectangle);
        }
        if (rectangle3 != null) {
            rectangle2 = PM_UtilsGrafik.getImageRectangle(image);
            Dimension dimension = pM_Picture.meta.getImageSize();
            double d = dimension.getWidth() / rectangle2.getWidth();
            rectangle3 = PM_UtilsGrafik.resizeRectangle(rectangle3, d, 1.0);
        }
        if (rectangle3 != null && n != 0) {
            rectangle2 = PM_UtilsGrafik.getImageRectangle(image);
            rectangle3 = PM_UtilsGrafik.rotateCutRectangle(n, rectangle3, rectangle2);
        }
        return rectangle3;
    }
}

