/*
 * Decompiled with CFR 0.152.
 */
package pm.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import pm.gui.PM_FocusPanel;
import pm.gui.PM_PictureView;
import pm.gui.PM_WindowBase;
import pm.gui.PM_WindowMain;
import pm.gui.PM_WindowRightTabbedPane;
import pm.picture.PM_Picture;
import pm.utilities.PM_Action;
import pm.utilities.PM_Configuration;
import pm.utilities.PM_Interface;
import pm.utilities.PM_Listener;
import pm.utilities.PM_MSG;
import pm.utilities.PM_Utils;

public class PM_WindowLeftThumbnails
extends PM_WindowBase
implements PM_Interface {
    private PM_FocusPanel upperPanel;
    private JButton clearButton = null;
    private JButton buttonReRead = null;
    private JPanel panelAnz = null;
    private JPanel panelToRight = null;
    private JButton buttonDiashow;

    public PM_WindowLeftThumbnails(PM_WindowMain pM_WindowMain, int n) {
        super(pM_WindowMain, n, true);
        PM_Configuration pM_Configuration = PM_Configuration.getInstance();
        this.setLayout(new BorderLayout());
        this.getIndexView().setPopUpLoeschen(true);
        this.getIndexView().setPopUpLoeschenAufheben(true);
        this.getIndexView().setPopUpAendern(true);
        this.getIndexView().setPopUpDiaShow(true);
        this.getIndexView().setPopUpExternBearbeiten(true);
        this.getIndexView().setPopUpSerien(true);
        if (pM_Configuration.isNurLesen()) {
            this.getIndexView().setBackground(Color.pink);
        } else {
            this.getIndexView().setBackground(COLOR_BACKGROUND);
        }
        JSlider jSlider = this.getIndexView().getSlider();
        this.upperPanel = this.getUpperPanel();
        JScrollPane jScrollPane = new JScrollPane(this.upperPanel);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)jScrollPane, "North");
        jPanel.add((Component)this.indexViewScrollPane, "Center");
        jPanel.add((Component)jSlider, "South");
        this.add(jPanel);
        this.setAktiverFocus(jSlider);
        this.addFocusPanel(this.upperPanel);
        this.addFocusPanel(this.getIndexView().getFocusPanel());
        this.addFocusPanel(new PM_FocusPanel(null, jSlider, jSlider));
        this.setBackgroundUpperPanel(COLOR_BG_PANEL);
        PM_Listener pM_Listener = new PM_Listener(){

            public void actionPerformed(PM_Action pM_Action) {
                PM_WindowLeftThumbnails.this.setMsg();
            }
        };
        PM_MSG.addChangeListener(pM_Listener);
        this.setMsg();
    }

    private void setMsg() {
        this.buttonDiashow.setText(PM_MSG.getMsg("diashow"));
    }

    public PM_FocusPanel getFocusComponent() {
        PM_FocusPanel pM_FocusPanel = new PM_FocusPanel(null, this.getIndexView(), this.getIndexView());
        return pM_FocusPanel;
    }

    public void closeAlbum() {
    }

    public boolean requestToChange() {
        return true;
    }

    public boolean flush() {
        this.getIndexView().removeAllThumbs();
        return true;
    }

    private PM_FocusPanel getUpperPanel() {
        PM_FocusPanel pM_FocusPanel = new PM_FocusPanel(){

            public void setBackgroundColor(Color color) {
                PM_WindowLeftThumbnails.this.setBackgroundUpperPanel(color);
            }
        };
        pM_FocusPanel.setLayout(new FlowLayout(0));
        this.buttonDiashow = new JButton("?Diashow?");
        pM_FocusPanel.add(this.buttonDiashow);
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                List<PM_Picture> list = PM_WindowLeftThumbnails.this.getIndexView().getPictureListDarstellen();
                if (list.size() != 0) {
                    PM_PictureView pM_PictureView = PM_WindowLeftThumbnails.this.getIndexView().getPictureViewSelected();
                    PM_Picture pM_Picture = list.get(0);
                    if (pM_PictureView != null) {
                        pM_Picture = pM_PictureView.getPicture();
                    }
                    PM_WindowLeftThumbnails.this.windowMain.doDiaShow(pM_Picture, list, 1);
                }
            }
        };
        this.buttonDiashow.addActionListener(actionListener);
        this.panelAnz = new JPanel(new FlowLayout(0));
        this.clearButton = PM_Utils.getJButon("button_cancel.png");
        this.panelAnz.add(this.clearButton);
        ActionListener actionListener2 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PM_WindowLeftThumbnails.this.getIndexView().removeAllThumbs();
            }
        };
        this.clearButton.addActionListener(actionListener2);
        this.buttonReRead = PM_Utils.getJButon("rebuild.png");
        this.panelAnz.add(this.buttonReRead);
        ActionListener actionListener3 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PM_WindowLeftThumbnails.this.getIndexView().rereadAllThumbs();
            }
        };
        this.buttonReRead.addActionListener(actionListener3);
        FlowLayout flowLayout = new FlowLayout(0);
        this.panelToRight = new JPanel(flowLayout);
        int n = flowLayout.getHgap();
        flowLayout.setHgap(50);
        JButton jButton = PM_Utils.getJButon("1rightarrow.png");
        this.panelToRight.add(jButton);
        ActionListener actionListener4 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (PM_WindowLeftThumbnails.this.getIndexView().sizeDargestellt() == 0) {
                    return;
                }
                PM_WindowRightTabbedPane pM_WindowRightTabbedPane = PM_WindowMain.getInstance().getWindowRechts();
                pM_WindowRightTabbedPane.getWindowSelected().getAllThumbs(PM_WindowLeftThumbnails.this.getIndexView());
                PM_WindowLeftThumbnails.this.getIndexView().repaintViewport();
            }
        };
        jButton.addActionListener(actionListener4);
        flowLayout.setHgap(n);
        JButton jButton2 = PM_Utils.getJButon("2rightarrow.png");
        this.panelToRight.add(jButton2);
        ActionListener actionListener5 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (PM_WindowLeftThumbnails.this.getIndexView().sizeDargestellt() == 0) {
                    return;
                }
                PM_WindowRightTabbedPane pM_WindowRightTabbedPane = PM_WindowMain.getInstance().getWindowRechts();
                pM_WindowRightTabbedPane.getWindowSelected().appendAllThumbs(PM_WindowLeftThumbnails.this.getIndexView());
                PM_WindowLeftThumbnails.this.getIndexView().repaintViewport();
            }
        };
        jButton2.addActionListener(actionListener5);
        pM_FocusPanel.add(this.panelAnz);
        pM_FocusPanel.add(this.panelToRight);
        ArrayList<JButton> arrayList = new ArrayList<JButton>();
        arrayList.add(this.clearButton);
        arrayList.add(this.buttonReRead);
        ArrayList<ArrayList<JButton>> arrayList2 = new ArrayList<ArrayList<JButton>>();
        arrayList2.add(arrayList);
        pM_FocusPanel.setFocusListe(arrayList2);
        pM_FocusPanel.setLastFocus(this.clearButton);
        pM_FocusPanel.setContainer(pM_FocusPanel);
        return pM_FocusPanel;
    }

    private void setBackgroundUpperPanel(Color color) {
        this.upperPanel.setBackground(color);
        this.panelAnz.setBackground(color);
        this.clearButton.setBackground(COLOR_ENABLED);
        this.buttonReRead.setBackground(COLOR_ENABLED);
    }
}

