/*
 * Decompiled with CFR 0.152.
 */
package pm.inout;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageOutputStream;
import javax.swing.JLabel;
import javax.swing.JPanel;
import pm.gui.PM_WindowExport;
import pm.gui.PM_WindowMain;
import pm.inout.PM_Export;
import pm.picture.PM_Picture;
import pm.sequence.PM_Sequence;
import pm.utilities.PM_Configuration;
import pm.utilities.PM_Interface;
import pm.utilities.PM_MSG;
import pm.utilities.PM_UtilsGrafik;

public class PM_ExportChanged
extends PM_Export
implements PM_Interface {
    boolean cut = false;
    boolean rotateReflected = false;
    double ratio = 0.0;
    double resolution = 0.0;
    boolean overscan = false;
    int overscanX = 0;
    int overscanY = 0;
    boolean testOverscan = false;
    boolean imageText = false;
    Color colorBG = null;
    Color colorFG = null;
    boolean transparent = false;

    public PM_ExportChanged(PM_WindowMain pM_WindowMain, PM_WindowExport pM_WindowExport) {
        super(pM_WindowMain, pM_WindowExport);
        this.getInitValues();
    }

    protected void getAddOnDialogPanel(JPanel jPanel) {
        jPanel.add(new JLabel(PM_MSG.getMsg("expDialogChng")));
    }

    protected boolean schreibenBild(PM_Picture pM_Picture, File file, int n, int n2) {
        if (file.isFile()) {
            return false;
        }
        BufferedImage bufferedImage = this.getBufferedImage(pM_Picture, n, n2);
        if (bufferedImage == null) {
            return false;
        }
        ImageWriter imageWriter = ImageIO.getImageWritersByFormatName("jpg").next();
        ImageOutputStream imageOutputStream = null;
        try {
            imageOutputStream = ImageIO.createImageOutputStream(file);
            imageWriter.setOutput(imageOutputStream);
            imageWriter.write(bufferedImage);
        }
        catch (IOException iOException) {
            String string = "Fehler: beim Schreiben Thumbnail in Datei " + file.getName();
            System.out.println(string);
            return false;
        }
        bufferedImage.flush();
        System.gc();
        ++this.pictureCount;
        return true;
    }

    private void getInitValues() {
        this.cut = this.windowExport.getCut();
        this.rotateReflected = this.windowExport.getRotate();
        this.ratio = this.windowExport.getSeitenVerhaeltniss();
        this.resolution = this.windowExport.getResolution();
        this.overscan = this.windowExport.getOverscan();
        if (this.overscan) {
            this.overscanX = this.windowExport.getOverscanValueX();
            this.overscanY = this.windowExport.getOverscanValueY();
            this.testOverscan = this.windowExport.getTestOverscancolor();
        } else {
            this.overscanX = 0;
            this.overscanY = 0;
            this.testOverscan = false;
        }
        this.imageText = this.windowExport.getTextOnPicture();
        this.colorBG = this.windowExport.getBackgroundColor();
        this.colorFG = this.windowExport.getForgroundColor();
        this.transparent = this.windowExport.getTransparent();
    }

    private BufferedImage getBufferedImage(PM_Picture pM_Picture, int n, int n2) {
        Object object;
        BufferedImage bufferedImage;
        double d;
        Object object2;
        Image image = null;
        PM_Picture.readImageOriginal(Collections.singletonList(pM_Picture), new ArrayList<PM_Picture>());
        image = pM_Picture.getImageOriginal();
        BufferedImage bufferedImage2 = null;
        if (this.cut && pM_Picture.meta.hasCutRectangle()) {
            object2 = pM_Picture.meta.getCutRectangle();
            bufferedImage2 = PM_UtilsGrafik.getBufferedImage(((Rectangle)object2).width, ((Rectangle)object2).height);
            Graphics2D graphics2D = PM_UtilsGrafik.getGraphics(bufferedImage2);
            graphics2D.drawImage(image, 0, 0, ((Rectangle)object2).width, ((Rectangle)object2).height, ((Rectangle)object2).x, ((Rectangle)object2).y, ((Rectangle)object2).width + ((Rectangle)object2).x, ((Rectangle)object2).height + ((Rectangle)object2).y, null);
        } else {
            bufferedImage2 = PM_UtilsGrafik.getBufferedImage(image);
        }
        image.flush();
        if (this.rotateReflected) {
            double d2 = bufferedImage2.getWidth(null);
            d = bufferedImage2.getHeight(null);
            double d3 = 0.0;
            double d4 = 0.0;
            switch (pM_Picture.meta.getRotation()) {
                case 90: {
                    d3 = d;
                    break;
                }
                case 180: {
                    d3 = d2;
                    d4 = d;
                    break;
                }
                case 270: {
                    d4 = d2;
                }
            }
            bufferedImage = bufferedImage2;
            int n3 = 0;
            if (this.rotateReflected) {
                n3 = pM_Picture.meta.getRotation();
            }
            bufferedImage = n3 == 0 || n3 == 180 ? new BufferedImage(bufferedImage2.getWidth(), bufferedImage2.getHeight(), 1) : new BufferedImage(bufferedImage2.getHeight(), bufferedImage2.getWidth(), 1);
            object = bufferedImage.createGraphics();
            AffineTransform affineTransform = new AffineTransform();
            if (n3 != 0) {
                affineTransform.translate(d3, d4);
                affineTransform.rotate((double)pM_Picture.meta.getRotation() * Math.PI / 180.0);
            }
            if (pM_Picture.meta.getMirror()) {
                affineTransform.translate(bufferedImage.getWidth(), 0.0);
                affineTransform.scale(-1.0, 1.0);
            }
            ((Graphics2D)object).drawImage(bufferedImage2, affineTransform, null);
            bufferedImage2 = bufferedImage;
        }
        if (this.resolution > 0.0) {
            double d5 = Math.sqrt(this.resolution * (double)bufferedImage2.getWidth() / (double)bufferedImage2.getHeight());
            Image image2 = PM_UtilsGrafik.getScaledImage(bufferedImage2, (int)d5, (int)(this.resolution / d5));
            bufferedImage2 = PM_UtilsGrafik.getBufferedImage(image2);
            image2.flush();
        }
        if (this.imageText) {
            object2 = PM_UtilsGrafik.getGraphics(bufferedImage2);
            int n4 = bufferedImage2.getHeight() / 25;
            int n5 = bufferedImage2.getWidth();
            int n6 = bufferedImage2.getHeight();
            Rectangle rectangle = new Rectangle(0, n6 - n4, n5, n4);
            if (!this.transparent) {
                ((Graphics)object2).setColor(this.colorBG);
                ((Graphics)object2).fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
            ((Graphics)object2).setFont(new Font("Arial", 1, n4));
            ((Graphics)object2).setColor(this.colorFG);
            ((Graphics2D)object2).drawString(this.getTextUnterBild(pM_Picture, n, n2), 0, n6);
        }
        if (this.overscan) {
            int n7 = bufferedImage2.getWidth(null);
            int n8 = bufferedImage2.getHeight(null);
            d = (100.0 + (double)this.overscanX) / 100.0 * (double)n7;
            int n9 = (int)d;
            double d6 = (100.0 + (double)this.overscanY) / 100.0 * (double)n8;
            int n10 = (int)d6;
            bufferedImage = PM_UtilsGrafik.getBufferedImage(n9, n10);
            Graphics2D graphics2D = PM_UtilsGrafik.getGraphics(bufferedImage);
            object = graphics2D.getColor();
            if (this.testOverscan) {
                graphics2D.setColor(Color.YELLOW);
            } else {
                graphics2D.setColor(Color.DARK_GRAY);
            }
            graphics2D.fill(new Rectangle(0, 0, n9, n10));
            graphics2D.setColor((Color)object);
            int n11 = (int)((double)(n9 - n7) / 2.0);
            int n12 = (int)((double)(n10 - n8) / 2.0);
            graphics2D.drawImage(bufferedImage2, n11, n12, n7, n8, null);
            bufferedImage2 = bufferedImage;
        }
        return bufferedImage2;
    }

    private String getTextUnterBild(PM_Picture pM_Picture, int n, int n2) {
        if (!this.windowExport.getTextOnPicture()) {
            return "";
        }
        PM_Configuration pM_Configuration = PM_Configuration.getInstance();
        String string = String.valueOf(n) + "/" + String.valueOf(n2) + " ";
        string = this.addText(pM_Picture, string, pM_Configuration.getSlideshowText1());
        string = this.addText(pM_Picture, string, pM_Configuration.getSlideshowText2());
        string = this.addText(pM_Picture, string, pM_Configuration.getSlideshowText3());
        return string;
    }

    private String addText(PM_Picture pM_Picture, String string, String string2) {
        String string3 = "";
        if (string2.equals("index1")) {
            string3 = pM_Picture.meta.getIndex1();
        } else if (string2.equals("index2")) {
            string3 = pM_Picture.meta.getIndex2();
        } else if (string2.equals("datum")) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd.MM.yyyy");
            string3 = simpleDateFormat.format(pM_Picture.meta.getDateCurrent());
        } else if (string2.equals("bemerkung") || string2.equals("bemerkungen")) {
            string3 = pM_Picture.meta.getRemarks();
        } else if (string2.equals("name")) {
            File file = pM_Picture.meta.getFileOriginal();
            string3 = file.getName();
        } else if (string2.equals("kategorie")) {
            string3 = "K";
            string3 = string3 + pM_Picture.meta.getCategory();
        } else if (string2.equals("serie")) {
            String string4 = pM_Picture.meta.getSequence();
            String[] stringArray = string4.split(" ");
            for (int i = 0; i < stringArray.length; ++i) {
                String string5 = stringArray[i];
                if (string5.indexOf("s") < 0) continue;
                String[] stringArray2 = string5.split("_");
                if (stringArray2.length != 2) break;
                PM_Sequence pM_Sequence = PM_Sequence.getSequenzFromAll(stringArray2[0]);
                if (pM_Sequence.getType() != PM_Interface.SequenceType.BASE || pM_Sequence.getType() != PM_Interface.SequenceType.EXTENDED) continue;
                string3 = pM_Sequence.getPath();
                break;
            }
        }
        if (string3.length() == 0) {
            return string;
        }
        if (string.length() == 0) {
            return string3;
        }
        return string + " " + string3;
    }
}

