/*
 * Decompiled with CFR 0.152.
 */
package pm.inout;

import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import pm.gui.PM_WindowExport;
import pm.gui.PM_WindowMain;
import pm.inout.PM_Export;
import pm.inout.PM_IndexFileXML;
import pm.picture.PM_IndexFile;
import pm.picture.PM_MetadataContainer;
import pm.picture.PM_Picture;
import pm.picture.PM_PictureDirectory;
import pm.sequence.PM_Sequence;
import pm.sequence.PM_TreeModel;
import pm.sequence.PM_TreeModelBase;
import pm.sequence.PM_TreeModelExtended;
import pm.sequence.PM_TreeModelNew;
import pm.utilities.PM_Interface;
import pm.utilities.PM_Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PM_ExportDelete
extends PM_Export
implements PM_Interface {
    private File dirThumbnails = null;
    private PM_IndexFile xmlIndexFile = null;

    public static int deleteAllPictures() {
        int n = 0;
        for (PM_PictureDirectory pM_PictureDirectory : PM_MetadataContainer.getInstance().getPictureDirectories()) {
            n += pM_PictureDirectory.deletePictureInvalid();
        }
        return n;
    }

    public PM_ExportDelete(PM_WindowMain pM_WindowMain, PM_WindowExport pM_WindowExport) {
        super(pM_WindowMain, pM_WindowExport);
    }

    @Override
    protected int schreibenAlleBilder(List<PM_Picture> list) {
        int n = super.schreibenAlleBilder(list);
        return n;
    }

    public void deletePictures(List<PM_Picture> list) {
        Serializable serializable;
        HashSet hashSet = new HashSet();
        for (PM_Picture pM_Interface : list) {
            pM_Interface.meta.setInvalid(true);
            serializable = new ArrayList();
            for (String string : PM_Utils.getList(pM_Interface.meta.getSequence())) {
                String[] stringArray = string.split("_");
                if (stringArray.length < 1) continue;
                serializable.add(stringArray[0]);
            }
            hashSet.addAll(serializable);
            this.fireDeleteListener(pM_Interface);
        }
        this.fireDeleteListener(null);
        ArrayList arrayList = new ArrayList();
        if (!hashSet.isEmpty()) {
            PM_TreeModelBase pM_TreeModelBase = PM_TreeModelBase.getInstance();
            serializable = PM_TreeModelExtended.getInstance();
            PM_TreeModelNew pM_TreeModelNew = PM_TreeModelNew.getInstance();
            ArrayList<PM_Sequence> arrayList2 = ((PM_TreeModel)pM_TreeModelBase).getSequenceList();
            arrayList2.addAll(((PM_TreeModel)serializable).getSequenceList());
            arrayList2.addAll(((PM_TreeModel)pM_TreeModelNew).getSequenceList());
            for (PM_Sequence pM_Sequence : arrayList2) {
                if (!hashSet.contains(pM_Sequence.getShortName())) continue;
                arrayList.add(pM_Sequence);
                pM_Sequence.computeNewSize();
                if (pM_Sequence.getAnzahlBilder() != 0) continue;
                pM_Sequence.loeschenSequenz();
                pM_TreeModelBase.removeSequence(pM_Sequence);
                ((PM_TreeModel)serializable).removeSequence(pM_Sequence);
                pM_TreeModelNew.removeSequence(pM_Sequence);
            }
            return;
        }
    }

    @Override
    protected boolean schreibenBild(PM_Picture pM_Picture, File file, int n, int n2) {
        pM_Picture.meta.setInvalid(true);
        this.fireDeleteListener(pM_Picture);
        return true;
    }

    @Override
    protected void open() {
        File file = new File(this.tempPictureDirectory.getPath() + File.separator + "pm.metadaten");
        file.mkdirs();
        this.dirThumbnails = new File(file.getPath() + File.separator + "pm.thumbnails");
        this.dirThumbnails.mkdirs();
        File file2 = new File(file.getPath() + File.separator + "pm_index.xml");
        this.xmlIndexFile = new PM_IndexFileXML(file2);
    }

    @Override
    protected void close() {
        this.xmlIndexFile.writeDocument();
        this.xmlIndexFile = null;
    }
}

