/*
 * Decompiled with CFR 0.152.
 */
package pm.picture;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import pm.gui.PM_WindowMain;
import pm.picture.PM_MetadataContainer;
import pm.picture.PM_Picture;
import pm.utilities.PM_Configuration;
import pm.utilities.PM_Interface;
import pm.utilities.PM_Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PM_DoublePictures
implements PM_Interface {
    private PM_WindowMain windowMain;
    private JProgressBar progressionBar = null;
    private PM_MetadataContainer metaContainer;
    private int anzGesamt = 0;
    private int anzDoppelt = 0;
    private int anzDreifach = 0;
    private int anzVierfachPlus = 0;
    private File[] alleFiles = new File[0];
    int anzahlFuerProgressionBar = 0;

    public PM_DoublePictures(PM_WindowMain pM_WindowMain) {
        this.windowMain = pM_WindowMain;
        this.metaContainer = PM_MetadataContainer.getInstance();
    }

    public void doppelteBilderErmitteln() {
        JDialog jDialog = new JDialog((Frame)this.windowMain, true);
        JPanel jPanel = new JPanel();
        jPanel.setPreferredSize(new Dimension(300, 200));
        jPanel.setLayout(new BorderLayout());
        int n = this.metaContainer.getPictureSizeValid();
        if (n <= 0) {
            return;
        }
        this.progressionBar = new JProgressBar(1, n);
        jPanel.add((Component)this.progressionBar, "North");
        jDialog.getContentPane().add(jPanel);
        jDialog.pack();
        this.anzahlFuerProgressionBar = 0;
        DoppelteBilder doppelteBilder = new DoppelteBilder(jDialog);
        doppelteBilder.start();
        jDialog.setVisible(true);
    }

    public int getAnzGesamt() {
        return this.anzGesamt;
    }

    public int getAnzDoppelt() {
        return this.anzDoppelt;
    }

    public int getAnzDreifach() {
        return this.anzDreifach;
    }

    public int getAnzVierfachPlus() {
        return this.anzVierfachPlus;
    }

    public List<PM_Picture> getAlleFiles() {
        ArrayList<PM_Picture> arrayList = new ArrayList<PM_Picture>();
        for (int i = 0; i < this.alleFiles.length; ++i) {
            File file = this.alleFiles[i];
            PM_Picture pM_Picture = PM_Picture.getPicture(file);
            if (pM_Picture == null) continue;
            arrayList.add(pM_Picture);
        }
        return arrayList;
    }

    static /* synthetic */ File[] access$102(PM_DoublePictures pM_DoublePictures, File[] fileArray) {
        pM_DoublePictures.alleFiles = fileArray;
        return fileArray;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DoppelteBilder
    extends Thread {
        private JDialog dialog;
        private HashMap<String, Vector<File>> dic = null;

        public DoppelteBilder(JDialog jDialog) {
            this.dialog = jDialog;
        }

        private void lesenDir(File file) {
            File file2;
            int n;
            File[] fileArray = file.listFiles();
            for (n = 0; n < fileArray.length; ++n) {
                Object object;
                file2 = fileArray[n];
                if (!file2.isFile() || !PM_Utils.isPictureFile(file2)) continue;
                if (PM_Picture.isPictureInstanceAvailable(file2)) {
                    object = PM_Picture.getPicture(file2);
                    if (((PM_Picture)object).meta.isInvalid()) continue;
                }
                object = Long.toString(file2.length());
                Vector<Object> vector = null;
                if (this.dic.containsKey(object)) {
                    vector = this.dic.get(object);
                    vector.add(file2);
                } else {
                    vector = new Vector<File>();
                    vector.add(file2);
                    this.dic.put((String)object, vector);
                }
                PM_DoublePictures.this.progressionBar.setValue(PM_DoublePictures.this.anzahlFuerProgressionBar++);
            }
            for (n = 0; n < fileArray.length; ++n) {
                file2 = fileArray[n];
                if (!PM_Utils.isBilderDir(file2)) continue;
                this.lesenDir(fileArray[n]);
            }
        }

        private File[] makeArrayFromDic(HashMap<String, Vector<File>> hashMap) {
            Collection<Vector<File>> collection = hashMap.values();
            Iterator<Vector<File>> iterator = collection.iterator();
            Vector<File> vector = new Vector<File>();
            while (iterator.hasNext()) {
                Vector<File> vector2 = iterator.next();
                if (vector2.size() <= 1) continue;
                for (int i = 0; i < vector2.size(); ++i) {
                    File file = vector2.elementAt(i);
                    vector.add(file);
                }
            }
            return vector.toArray(new File[vector.size()]);
        }

        @Override
        public void run() {
            PM_Configuration pM_Configuration = PM_Configuration.getInstance();
            File file = pM_Configuration.getTopLevelPictureDirectory();
            this.dic = new HashMap();
            this.lesenDir(file);
            File[] fileArray = this.makeArrayFromDic(this.dic);
            PM_DoublePictures.this.progressionBar.setMinimum(1);
            PM_DoublePictures.this.progressionBar.setMaximum(fileArray.length);
            PM_DoublePictures.this.anzahlFuerProgressionBar = 0;
            this.dic = new HashMap();
            for (int i = 0; i < fileArray.length; ++i) {
                File file2 = fileArray[i];
                if (file2.isFile()) {
                    String object = new String(PM_Utils.getMessageDigest(file2));
                    Vector<Object> vector = null;
                    if (this.dic.containsKey(object)) {
                        vector = this.dic.get(object);
                        vector.add(file2);
                    } else {
                        vector = new Vector<Object>();
                        vector.add(file2);
                        this.dic.put(object, vector);
                    }
                }
                PM_DoublePictures.this.progressionBar.setValue(PM_DoublePictures.this.anzahlFuerProgressionBar++);
            }
            PM_DoublePictures.access$102(PM_DoublePictures.this, this.makeArrayFromDic(this.dic));
            Collection<Vector<File>> collection = this.dic.values();
            for (Vector vector : collection) {
                if (vector.size() == 2) {
                    PM_DoublePictures.this.anzDoppelt++;
                }
                if (vector.size() == 3) {
                    PM_DoublePictures.this.anzDreifach++;
                }
                if (vector.size() <= 3) continue;
                PM_DoublePictures.this.anzVierfachPlus++;
            }
            PM_DoublePictures.this.anzGesamt = PM_DoublePictures.this.alleFiles.length;
            if (this.dialog != null) {
                this.dialog.dispose();
            }
        }
    }
}

