/*
 * Decompiled with CFR 0.152.
 */
package pm.picture;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import pm.inout.PM_SequencesInout;
import pm.picture.PM_Import;
import pm.picture.PM_MetadataContainer;
import pm.search.PM_DatabaseLucene;
import pm.utilities.PM_Action;
import pm.utilities.PM_Configuration;
import pm.utilities.PM_Interface;
import pm.utilities.PM_MSG;
import pm.utilities.PM_Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PM_ImportInternal
extends PM_Import
implements PM_Interface {
    public PM_ImportInternal() {
        super(PM_Interface.Import.INTERN);
    }

    public void checkAndImport() {
        Thread thread = new Thread(){

            public void run() {
                PM_MetadataContainer.getInstance().flush();
                PM_DatabaseLucene.getInstance().flush();
                PM_SequencesInout.getInstance().flush();
                List list = PM_ImportInternal.this.searchNewPicture();
                if (list == null) {
                    return;
                }
                List<File> list2 = PM_ImportInternal.this.getNewDouble(list, null);
                ArrayList<File> arrayList = new ArrayList<File>(list);
                arrayList.removeAll(list2);
                List<File> list3 = PM_ImportInternal.this.getKnownPictures(arrayList, null);
                if (list2.isEmpty() && list3.isEmpty()) {
                    int n = list.size();
                    String string = String.format(PM_MSG.getMsg("importMsgCountNoDouble"), n);
                    PM_ImportInternal.this.listener.actionPerformed(new PM_Action("max", n, string));
                    PM_ImportInternal.this.dialogImport.setEnableContinue(true);
                    PM_ImportInternal.this.dialogImport.setEnableStop(true);
                    boolean bl = PM_ImportInternal.this.dialogImport.await();
                    if (bl) {
                        PM_ImportInternal.this.dialogImport.dispose();
                        return;
                    }
                    PM_ImportInternal.this.runImport(list);
                    PM_ImportInternal.this.dialogImport.dispose();
                    return;
                }
                int n = list2.size() + list3.size();
                String string = String.format(PM_MSG.getMsg("importMsgWithDouble"), list.size(), n);
                String string2 = String.format(PM_MSG.getMsg("importMsgWithoutDouble"), list.size() - n, n);
                boolean bl = PM_ImportInternal.this.dialogImport.isDoublePicSelected();
                if (bl) {
                    PM_ImportInternal.this.listener.actionPerformed(new PM_Action("max", list.size(), string));
                } else {
                    PM_ImportInternal.this.listener.actionPerformed(new PM_Action("max", list.size() - n, string2));
                }
                PM_ImportInternal.this.dialogImport.setEnableContinue(true);
                PM_ImportInternal.this.dialogImport.setEnableStop(true);
                boolean bl2 = PM_ImportInternal.this.dialogImport.await();
                if (bl2) {
                    PM_ImportInternal.this.dialogImport.dispose();
                    return;
                }
                if (bl != PM_ImportInternal.this.dialogImport.isDoublePicSelected()) {
                    bl = PM_ImportInternal.this.dialogImport.isDoublePicSelected();
                    if (bl) {
                        PM_ImportInternal.this.listener.actionPerformed(new PM_Action("max", list.size(), string));
                    } else {
                        PM_ImportInternal.this.listener.actionPerformed(new PM_Action("max", list.size() - n, string2));
                    }
                }
                if (bl) {
                    PM_ImportInternal.this.runImport(list);
                } else {
                    list.removeAll(list2);
                    list.removeAll(list3);
                    PM_ImportInternal.this.runImport(list);
                    for (File file : list2) {
                        PM_Utils.setStop(file);
                    }
                    for (File file : list3) {
                        PM_Utils.setStop(file);
                    }
                }
                PM_ImportInternal.this.dialogImport.dispose();
            }
        };
        thread.start();
    }

    private List<File> searchNewPicture() {
        int n = PM_MetadataContainer.getInstance().getPictureDirectories().size();
        this.listener.actionPerformed(new PM_Action("max", n));
        List<File> list = PM_MetadataContainer.getInstance().getPicturesWithoutThumbs(this.dialogImport.getListener());
        int n2 = list.size();
        if (n2 == 0) {
            String string = PM_Configuration.getInstance().getTopLevelPictureDirectory().getPath();
            String string2 = String.format(PM_MSG.getMsg("importMsgNoPictures"), string);
            this.listener.actionPerformed(new PM_Action("max", 0, string2));
            this.dialogImport.setEnableContinue(true);
            this.dialogImport.setEnableStop(false);
            this.dialogImport.setEnableInfoDoublePic(false);
            this.dialogImport.await();
            this.dialogImport.dispose();
            return null;
        }
        String string = String.format(PM_MSG.getMsg("importMsgPicsFound"), n2);
        this.listener.actionPerformed(new PM_Action("max", n2, string));
        this.dialogImport.setEnableContinue(true);
        this.dialogImport.setEnableStop(true);
        boolean bl = this.dialogImport.await();
        if (bl) {
            this.dialogImport.dispose();
            return null;
        }
        return list;
    }
}

