/*
 * Decompiled with CFR 0.152.
 */
package pm.picture;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import pm.inout.PM_IndexFileXML;
import pm.picture.PM_IndexFile;
import pm.picture.PM_Picture;
import pm.search.PM_DatabaseLucene;
import pm.utilities.PM_Action;
import pm.utilities.PM_Configuration;
import pm.utilities.PM_Interface;
import pm.utilities.PM_ListenerX;
import pm.utilities.PM_MSG;
import pm.utilities.PM_Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PM_PictureDirectory
implements PM_Interface {
    private File dirOrigFile;
    private File pmIndexFile;
    private PM_IndexFile xmlIndexFile;
    private HashMap<String, PM_Picture> pictureToChange = new HashMap();
    private static int number = 0;
    private int idNumber;
    private int level;

    public PM_PictureDirectory(File file, int n) {
        this.dirOrigFile = file;
        this.level = n;
        this.idNumber = ++number;
        this.pmIndexFile = PM_Utils.getFileIndexXML(file);
        this.xmlIndexFile = new PM_IndexFileXML(this.pmIndexFile);
    }

    public File getPmIndexFile() {
        return this.pmIndexFile;
    }

    public int getIdNumber() {
        return this.idNumber;
    }

    public int getLevel() {
        return this.level;
    }

    public void initProgramStart(PM_ListenerX pM_ListenerX) {
        boolean bl = false;
        if (pM_ListenerX != null) {
            pM_ListenerX.actionPerformed(new PM_Action(null, 1, this.dirOrigFile.getPath()));
        }
        HashSet<String> hashSet = new HashSet<String>();
        File[] fileArray = this.dirOrigFile.listFiles();
        for (File file : fileArray) {
            if (!PM_Utils.isPictureFile(file)) continue;
            hashSet.add(file.getName());
        }
        File file = this.getDirThumbnails();
        for (String string : file.list()) {
            int n = string.lastIndexOf("_th");
            if (n <= 0 || hashSet.contains(string.substring(0, n))) continue;
            new File(file.getPath() + File.separator + string).delete();
        }
        Set<String> set = this.xmlIndexFile.getValidFileNames();
        set.addAll(this.xmlIndexFile.getInvalidFileNames());
        Set<String> set2 = this.getThumbnailIDs();
        Iterator<Object> iterator = set.iterator();
        while (iterator.hasNext()) {
            String string;
            string = (String)iterator.next();
            if (set2.contains(string)) continue;
            this.xmlIndexFile.removeID(string);
            bl = true;
        }
        set2 = new HashSet<String>(this.getThumbnailIDs());
        set2.removeAll(this.xmlIndexFile.getValidFileNames());
        set2.removeAll(this.xmlIndexFile.getInvalidFileNames());
        for (String string : set2) {
            new File(file.getPath() + File.separator + string + "_th").delete();
        }
        if (bl) {
            PM_DatabaseLucene.getInstance().setNeuErzeugen(true);
            this.xmlIndexFile.writeDocument();
        }
        this.xmlIndexFile.initComplete();
    }

    public List<File> getPicturesWithoutThumbs(PM_ListenerX pM_ListenerX) {
        ArrayList<File> arrayList = new ArrayList<File>();
        Set<String> set = this.getOrigFileNames();
        set.removeAll(this.getThumbnailIDs());
        if (pM_ListenerX != null) {
            pM_ListenerX.actionPerformed(new PM_Action(null, 1, this.dirOrigFile.getPath()));
        }
        for (String string : set) {
            File file = new File(this.dirOrigFile.getPath() + File.separator + string);
            arrayList.add(file);
        }
        return arrayList;
    }

    public List<File> getOrigValidFiles() {
        ArrayList<File> arrayList = new ArrayList<File>();
        Set<String> set = this.xmlIndexFile.getValidFileNames();
        for (String object2 : set) {
            File[] fileArray = new File(this.dirOrigFile.getPath() + File.separator + object2);
            arrayList.add((File)fileArray);
        }
        File file = new File(this.dirOrigFile.getPath() + File.separator + "pm.metadaten");
        File file2 = new File(file.getPath() + File.separator + "pm.bilder_bearbeiten");
        if (file2.isDirectory()) {
            for (File file3 : file2.listFiles()) {
                if (!file3.getName().endsWith("0")) continue;
                arrayList.add(file3);
            }
        }
        return arrayList;
    }

    public List<File> getOrigFiles() {
        ArrayList<File> arrayList = new ArrayList<File>();
        Set<String> set = this.xmlIndexFile.getValidFileNames();
        for (String string : set) {
            File file = new File(this.dirOrigFile.getPath() + File.separator + string);
            arrayList.add(file);
        }
        return arrayList;
    }

    private Set<String> getOrigFileNames() {
        File[] fileArray;
        HashSet<String> hashSet = new HashSet<String>();
        for (File file : fileArray = this.dirOrigFile.listFiles()) {
            if (!PM_Utils.isPictureFile(file)) continue;
            hashSet.add(file.getName());
        }
        return hashSet;
    }

    private Set<String> getThumbnailIDs() {
        HashSet<String> hashSet = new HashSet<String>();
        for (String string : this.getDirThumbnails().list()) {
            int n = string.lastIndexOf("_th");
            if (n <= 0) continue;
            hashSet.add(string.substring(0, n));
        }
        return hashSet;
    }

    File getDirThumbnails() {
        File file = new File(this.getDirMetadaten() + File.separator + "pm.thumbnails");
        if (!file.isDirectory()) {
            file.mkdirs();
        }
        return file;
    }

    File getDirMetadaten() {
        File file = new File(this.dirOrigFile.getPath() + File.separator + "pm.metadaten");
        if (!file.isDirectory()) {
            file.mkdirs();
        }
        return file;
    }

    public List<String> getTreePath() {
        File file;
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.level < 0) {
            arrayList.add("????");
            arrayList.add("unbekannt");
            return arrayList;
        }
        try {
            file = this.dirOrigFile.getCanonicalFile();
        }
        catch (IOException iOException) {
            arrayList.add("unbekannt");
            return arrayList;
        }
        int n = this.level;
        for (file = file.getParentFile(); file != null && n > 0; --n, file = file.getParentFile()) {
            arrayList.add(0, file.getName());
        }
        return arrayList;
    }

    public File getDirOrigFile() {
        return this.dirOrigFile;
    }

    public String getRelativePathTLD() {
        return PM_Utils.getRelativePath(PM_Configuration.getInstance().getTopLevelPictureDirectory(), this.dirOrigFile);
    }

    public int getPictureSizeValid() {
        return this.xmlIndexFile.getPictureSizeValid();
    }

    public int getPictureSizeInvalid() {
        return this.xmlIndexFile.getPictureSizeInvalid();
    }

    public void metadatenChanged(PM_Picture pM_Picture) {
        this.pictureToChange.put(pM_Picture.meta.getId(), pM_Picture);
    }

    public void loeschenIndex1() {
        this.flush();
        this.xmlIndexFile.loeschenIndex1();
    }

    public void loeschenIndex2() {
        this.flush();
        this.xmlIndexFile.loeschenIndex2();
    }

    public void alleSequenzenLoeschen() {
        this.flush();
        this.xmlIndexFile.alleSequenzenLoeschen();
    }

    public void flush() {
        boolean bl = false;
        if (this.xmlIndexFile.getVersionRead() != this.xmlIndexFile.getVersionWrite()) {
            bl = true;
        }
        if (this.pictureToChange.isEmpty() && !bl) {
            return;
        }
        for (PM_Picture pM_Picture : this.pictureToChange.values()) {
            this.update(pM_Picture);
        }
        this.pictureToChange.clear();
        this.xmlIndexFile.writeDocument();
    }

    public void close() {
        this.flush();
    }

    public void alleLuceneEintraegeNeuErstellen(PM_ListenerX pM_ListenerX) {
        this.xmlIndexFile.alleLuceneEintraegeNeuErstellen(pM_ListenerX);
    }

    public List<PM_Picture> bilderOhneSequenzen() {
        return this.xmlIndexFile.bilderOhneSequenzen();
    }

    public List<PM_Picture> bilderDoppelteSequenzen() {
        return this.xmlIndexFile.bilderDoppelteSequenzen();
    }

    public List<File> bilderNichtInSerien(List list, boolean bl) {
        return this.xmlIndexFile.bilderNichtInSerien(list, bl);
    }

    public void initMetadaten(PM_Picture pM_Picture) {
        if (!pM_Picture.meta.getInit()) {
            return;
        }
        this.xmlIndexFile.getMetadaten(pM_Picture);
    }

    public String toString() {
        int n = this.xmlIndexFile.getPictureSizeValid();
        if (n == 1) {
            return this.dirOrigFile.getName() + ": 1 " + PM_MSG.getMsg("picture");
        }
        return this.dirOrigFile.getName() + ": " + String.valueOf(n) + " " + PM_MSG.getMsg("pictures");
    }

    public int getAnzahlMetadatenToChange() {
        return this.pictureToChange.size();
    }

    public int deletePictureInvalid() {
        return this.xmlIndexFile.deletePictureInvalid(this.dirOrigFile);
    }

    private void update(PM_Picture pM_Picture) {
        this.xmlIndexFile.update(pM_Picture, pM_Picture.meta.getId());
    }
}

