/*
 * Decompiled with CFR 0.152.
 */
package pm.picture;

import java.io.File;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.TreeSet;
import pm.picture.PM_Picture;
import pm.utilities.PM_Interface;
import pm.utilities.PM_Utils;

public class PM_PictureExternalModify
implements PM_Interface {
    private PM_Picture picture;
    private File dirBilderBearbeiten;
    private Collection<EinBild> filesBilderBearbeitet = new TreeSet<EinBild>(TIME_ORDER);
    private File fileSicherungTemp = null;
    private static final Comparator<EinBild> TIME_ORDER = new Comparator<EinBild>(){

        @Override
        public int compare(EinBild einBild, EinBild einBild2) {
            int n;
            int n2 = einBild.getExtension();
            if (n2 < (n = einBild2.getExtension())) {
                return -1;
            }
            return 1;
        }
    };

    public PM_PictureExternalModify(PM_Picture pM_Picture) {
        this.picture = pM_Picture;
        this.init();
    }

    public EinBild[] getFileList() {
        return this.filesBilderBearbeitet.toArray(new EinBild[this.filesBilderBearbeitet.size()]);
    }

    public void startBearbeitung() {
        this.fileSicherungTemp.delete();
        PM_Utils.copyFile(this.picture.getFileOriginal(), this.fileSicherungTemp);
        this.fileSicherungTemp.setLastModified(this.picture.getFileOriginal().lastModified());
    }

    public boolean endeBearbeitung() {
        if (PM_Utils.dateienIdentisch(this.picture.getFileOriginal(), this.fileSicherungTemp)) {
            this.fileSicherungTemp.delete();
            return false;
        }
        File file = this.getFileGeladen();
        if (!file.exists()) {
            this.fileSicherungTemp.renameTo(file);
        } else {
            this.fileSicherungTemp.delete();
        }
        this.filesBilderBearbeitet.add(new EinBild(this.getFileSicherungNeu()));
        this.setzenBildGeladen();
        return true;
    }

    public void ladenBild(int n) {
        if (n > this.filesBilderBearbeitet.size() || n < 0) {
            return;
        }
        Object[] objectArray = this.filesBilderBearbeitet.toArray();
        EinBild einBild = (EinBild)objectArray[n];
        if (einBild.getGeladen()) {
            return;
        }
        EinBild einBild2 = this.getEinBildGeladen();
        if (!einBild2.getGeladen()) {
            return;
        }
        File file = einBild2.getFile();
        einBild2.setGeladen(false);
        if (!file.exists()) {
            PM_Utils.copyFile(this.picture.getFileOriginal(), file);
            file.setLastModified(this.picture.getFileOriginal().lastModified());
        }
        einBild.setGeladen(true);
        PM_Utils.copyFile(einBild.getFile(), this.picture.getFileOriginal());
        this.picture.getFileOriginal().setLastModified(einBild.getFile().lastModified());
    }

    public void loeschenBild(int n) {
        if (!this.hasEinBildAt(n)) {
            return;
        }
        TreeSet<EinBild> treeSet = new TreeSet<EinBild>(TIME_ORDER);
        int n2 = 0;
        for (EinBild einBild : this.filesBilderBearbeitet) {
            if (n2 == n) {
                File file = einBild.getFile();
                file.delete();
            } else {
                treeSet.add(einBild);
            }
            ++n2;
        }
        this.filesBilderBearbeitet = treeSet;
    }

    public int getIndexGeladen() {
        int n = 0;
        for (EinBild einBild : this.filesBilderBearbeitet) {
            if (einBild.getGeladen()) {
                return n;
            }
            ++n;
        }
        return 0;
    }

    public EinBild getEinBildAt(int n) {
        if (!this.hasEinBildAt(n)) {
            return null;
        }
        Object[] objectArray = this.filesBilderBearbeitet.toArray();
        return (EinBild)objectArray[n];
    }

    public boolean hasEinBildAt(int n) {
        return n < this.filesBilderBearbeitet.size() && n >= 0;
    }

    private void init() {
        File file = new File(this.picture.getFileOriginal().getParent() + File.separator + "pm.metadaten");
        this.dirBilderBearbeiten = new File(file.getPath() + File.separator + "pm.bilder_bearbeiten");
        this.dirBilderBearbeiten.mkdirs();
        String string = this.dirBilderBearbeiten.getPath() + File.separator + this.picture.getFileOriginal().getName() + "_temp";
        this.fileSicherungTemp = new File(string);
        this.fileSicherungTemp.delete();
        File[] fileArray = this.dirBilderBearbeiten.listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            File file2 = fileArray[i];
            if (file2.getName().indexOf(this.picture.getFileOriginal().getName()) != 0) continue;
            this.filesBilderBearbeitet.add(new EinBild(file2));
        }
        long l = this.picture.getFileOriginal().lastModified();
        boolean bl = false;
        for (EinBild einBild : this.filesBilderBearbeitet) {
            if (l != einBild.getDatumLong()) continue;
            bl = true;
            break;
        }
        if (!bl) {
            this.filesBilderBearbeitet.add(new EinBild(this.getFileSicherungNeu()));
        }
        this.setzenBildGeladen();
    }

    private void setzenBildGeladen() {
        long l = this.picture.getFileOriginal().lastModified();
        for (EinBild einBild : this.filesBilderBearbeitet) {
            einBild.setGeladen(l == einBild.getDatumLong());
        }
    }

    private File getFileSicherungNeu() {
        int n = this.getMaxExtension();
        String string = this.dirBilderBearbeiten.getPath() + File.separator + this.picture.getFileOriginal().getName() + "_b" + Integer.toString(++n);
        return new File(string);
    }

    private File getFileGeladen() {
        return this.getEinBildGeladen().getFile();
    }

    private EinBild getEinBildGeladen() {
        EinBild einBild2 = null;
        for (EinBild einBild2 : this.filesBilderBearbeitet) {
            if (!einBild2.getGeladen()) continue;
            return einBild2;
        }
        return einBild2;
    }

    private int getMaxExtension() {
        int n = -1;
        for (EinBild einBild : this.filesBilderBearbeitet) {
            int n2 = einBild.getExtension();
            if (n2 <= n) continue;
            n = n2;
        }
        return n;
    }

    public class EinBild {
        private File file;
        private int extension;
        private boolean geladen = false;

        public EinBild(File file) {
            this.file = file;
            this.extension = -1;
            String[] stringArray = file.getName().split("_b");
            if (stringArray.length > 1) {
                String string = stringArray[stringArray.length - 1];
                this.extension = PM_Utils.stringToInt(string);
            }
        }

        public String getDatumString() {
            return PM_Utils.getDateString(new Date(this.getDatumLong()), "dd.MM.yyyy   HH:mm:ss");
        }

        public long getDatumLong() {
            long l = 0L;
            l = this.file.exists() ? this.file.lastModified() : PM_PictureExternalModify.this.picture.getFileOriginal().lastModified();
            return l;
        }

        public void setGeladen(boolean bl) {
            this.geladen = bl;
        }

        public boolean getGeladen() {
            return this.geladen;
        }

        public File getFile() {
            return this.file;
        }

        public int getExtension() {
            return this.extension;
        }
    }
}

