/*
 * Decompiled with CFR 0.152.
 */
package pm.print;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import javax.swing.JOptionPane;
import pm.picture.PM_Picture;
import pm.print.PM_PaperFormat;
import pm.print.PM_PictureFormat;
import pm.print.PM_PicturePrint;
import pm.print.PM_SystemPrinter;
import pm.print.PM_WindowPrint;
import pm.utilities.PM_Interface;
import pm.utilities.PM_MSG;

public class PM_PmPrinter
implements PM_Interface,
Printable {
    private PM_SystemPrinter systemPrinter;
    private String pmName;
    private PM_PaperFormat papierFormat;
    private Rectangle2D printArea;
    private PM_PicturePrint[] picturesToPrint = null;
    private PM_WindowPrint windowDrucken = null;
    private boolean gedruckt = false;

    public PM_PmPrinter(PM_SystemPrinter pM_SystemPrinter, String string) {
        this.pmName = string;
        this.systemPrinter = pM_SystemPrinter;
        this.printArea = new Rectangle2D.Double();
        this.printArea.setRect(pM_SystemPrinter.getPapierBereichGesamt());
    }

    public void init(PM_PmPrinter pM_PmPrinter, PM_PaperFormat pM_PaperFormat) {
        if (pM_PmPrinter == this) {
            this.papierFormat = pM_PaperFormat;
            this.papierFormat.init(this);
            this.picturesToPrint = this.papierFormat.getAllePictureDrucken();
        } else {
            pM_PaperFormat = null;
        }
    }

    public Point2D getAufloesung() {
        return this.systemPrinter.getAufloesung();
    }

    public double getPixelBreiteMillimeter() {
        return this.systemPrinter.getPixelBreiteMillimeter();
    }

    public double getPixelHoeheMillimeter() {
        return this.systemPrinter.getPixelHoeheMillimeter();
    }

    public void setPapierFormat(PM_PaperFormat pM_PaperFormat) {
        this.papierFormat = pM_PaperFormat;
    }

    public PM_SystemPrinter getSystemPrinter() {
        return this.systemPrinter;
    }

    public int addToPaperArea(PM_Picture pM_Picture, PM_PictureFormat pM_PictureFormat, String string) {
        for (int i = 0; i < this.picturesToPrint.length; ++i) {
            if (!this.picturesToPrint[i].isEmpty()) continue;
            return this.picturesToPrint[i].init(pM_Picture, pM_PictureFormat, string);
        }
        return -1;
    }

    public void clear() {
        for (int i = 0; i < this.picturesToPrint.length; ++i) {
            this.picturesToPrint[i].delete();
        }
    }

    public void setDruckBereichGesamtRaender(double d, double d2, double d3, double d4) {
        Rectangle2D rectangle2D = this.systemPrinter.getPapierBereichGesamt();
        this.printArea = new Rectangle2D.Double(d4 /= this.systemPrinter.getPixelBreiteMillimeter(), d /= this.systemPrinter.getPixelHoeheMillimeter(), rectangle2D.getWidth() - (d2 /= this.systemPrinter.getPixelBreiteMillimeter()) - d4, rectangle2D.getHeight() - d - (d3 /= this.systemPrinter.getPixelHoeheMillimeter()));
    }

    public int getAnzahlFreieBilder() {
        int n = 0;
        if (this.picturesToPrint == null) {
            return 0;
        }
        for (int i = 0; i < this.picturesToPrint.length; ++i) {
            if (this.picturesToPrint[i].isEmpty()) continue;
            ++n;
        }
        return n;
    }

    public PM_PicturePrint[] getAlleBilder() {
        return this.picturesToPrint;
    }

    public PM_PaperFormat getPapierFormat() {
        return this.papierFormat;
    }

    public Rectangle2D getPapierBereichGesamt() {
        Rectangle2D.Double double_ = new Rectangle2D.Double();
        ((Rectangle2D)double_).setRect(this.systemPrinter.getPapierBereichGesamt());
        return double_;
    }

    public Rectangle2D getDruckBereichGesamt() {
        Rectangle2D.Double double_ = new Rectangle2D.Double();
        ((Rectangle2D)double_).setRect(this.printArea);
        return double_;
    }

    public String toString() {
        return this.pmName;
    }

    public void doPrint(PM_WindowPrint pM_WindowPrint) {
        this.windowDrucken = pM_WindowPrint;
        this.drucken();
    }

    private int getAnzahlBilder() {
        int n = 0;
        for (int i = 0; i < this.picturesToPrint.length; ++i) {
            PM_PicturePrint pM_PicturePrint = this.picturesToPrint[i];
            if (pM_PicturePrint.isEmpty()) continue;
            ++n;
        }
        return n;
    }

    private void drucken() {
        Object object;
        if (this.getAnzahlBilder() == 0 ? JOptionPane.showConfirmDialog(null, PM_MSG.getMsg("pmPrinterNoPictures"), "Print", 0, 3) == 1 : JOptionPane.showConfirmDialog(null, object = this.windowDrucken.hilfslinienDrucken() ? PM_MSG.getMsg("pmPrinterWithSubLines") : PM_MSG.getMsg("pmPrinterNoSubLines"), "Print", 0, 3) == 1) {
            return;
        }
        object = this.systemPrinter.getPrinterJob();
        PageFormat pageFormat = ((PrinterJob)object).defaultPage();
        Paper paper = pageFormat.getPaper();
        double d = paper.getImageableX();
        double d2 = paper.getImageableY();
        double d3 = paper.getImageableWidth();
        double d4 = paper.getImageableHeight();
        paper.setImageableArea(0.0, 0.0, paper.getWidth(), paper.getHeight());
        pageFormat.setPaper(paper);
        ((PrinterJob)object).setPrintable(this, pageFormat);
        this.gedruckt = false;
        try {
            ((PrinterJob)object).print();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        paper.setImageableArea(d, d2, d3, d4);
        pageFormat.setPaper(paper);
    }

    public int print(Graphics graphics, PageFormat pageFormat, int n) throws PrinterException {
        if (n >= 1) {
            return 1;
        }
        if (this.gedruckt) {
            this.aufbereitenDruckausgabe(graphics);
        }
        this.gedruckt = true;
        return 0;
    }

    private void aufbereitenDruckausgabe(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.setToScale(1.0, 1.0);
        if (this.windowDrucken.hilfslinienDrucken()) {
            this.windowDrucken.hilfslinienAufbereiten(graphics2D, affineTransform);
        }
        for (int i = 0; i < this.picturesToPrint.length; ++i) {
            PM_PicturePrint pM_PicturePrint = this.picturesToPrint[i];
            if (pM_PicturePrint.isEmpty()) continue;
            this.windowDrucken.einBildAufbereiten(graphics2D, pM_PicturePrint, affineTransform);
        }
    }
}

