/*
 * Decompiled with CFR 0.152.
 */
package pm.print;

import java.awt.print.PrinterJob;
import javax.print.PrintService;
import javax.swing.JOptionPane;
import pm.gui.PM_IndexView;
import pm.gui.PM_PictureView;
import pm.gui.PM_WindowMain;
import pm.print.PM_PaperFormat;
import pm.print.PM_PictureFormat;
import pm.print.PM_PmPrinter;
import pm.print.PM_WindowPrintUI;
import pm.utilities.PM_Interface;
import pm.utilities.PM_MSG;

public class PM_WindowPrint
extends PM_WindowPrintUI
implements PM_Interface {
    public PM_WindowPrint(PM_WindowMain pM_WindowMain, int n) {
        super(pM_WindowMain, n);
    }

    protected void noPrinterAvailable() {
        JOptionPane.showConfirmDialog(this, PM_MSG.getMsg("winPrtMsgNoPrinter"), "Print", -1, 0);
    }

    protected void addPictureView(PM_PictureView pM_PictureView) {
        if (this.pmPrinter == null) {
            this.noPrinterAvailable();
            return;
        }
        if (!this.getIndexView().addPicture(pM_PictureView.getPicture())) {
            return;
        }
        this.windowMain.getWindowThumbnails().getIndexView().repaintPicture(pM_PictureView.getPicture());
        this.doRepaint();
    }

    public void getAllThumbs(PM_IndexView pM_IndexView) {
        if (this.pmPrinter == null) {
            this.noPrinterAvailable();
            return;
        }
        super.getAllThumbs(pM_IndexView);
    }

    public boolean appendAllThumbs(PM_IndexView pM_IndexView) {
        if (this.pmPrinter == null) {
            this.noPrinterAvailable();
            return false;
        }
        return super.appendAllThumbs(pM_IndexView);
    }

    public void doubleClickOnPictureView(PM_PictureView pM_PictureView) {
        if (this.pmPrinter == null) {
            this.noPrinterAvailable();
            return;
        }
        int n = this.pmPrinter.addToPaperArea(pM_PictureView.getPicture(), this.pictureFormat, this.getItemBildBeschriftung());
        if (n == -1) {
            JOptionPane.showConfirmDialog(this, PM_MSG.getMsg("winPrtMsgNoSpace"), "Print", -1, 0);
            return;
        }
        this.doRepaint();
    }

    protected void setDefaultZooming() {
        this.sliderValue = this.bildschirmAufloesung / 72.0f;
    }

    protected void doClear() {
        if (this.pmPrinter == null) {
            return;
        }
        this.pmPrinter.clear();
        this.doRepaint();
    }

    protected void doPrint() {
        this.pmPrinter.doPrint(this);
    }

    protected void setPictureFormat(PM_PictureFormat pM_PictureFormat) {
        this.pictureFormat = pM_PictureFormat;
    }

    protected void setPaperFormat(PM_PaperFormat pM_PaperFormat) {
        this.paperFormat = pM_PaperFormat;
        this.selectPrinter();
    }

    protected void setPmPrinter(PM_PmPrinter pM_PmPrinter) {
        this.pmPrinter = pM_PmPrinter;
        this.selectPrinter();
    }

    protected void doSetupSystemPrinter() {
        if (this.pmPrinter == null) {
            this.noPrinterAvailable();
            return;
        }
        PrinterJob printerJob = this.pmPrinter.getSystemPrinter().getPrinterJob();
        PrintService printService = printerJob.getPrintService();
        if (printerJob.printDialog()) {
            PrintService printService2 = printerJob.getPrintService();
            if (printService == printService2) {
                this.pmPrinter.getSystemPrinter().setEingestellt(true);
                this.setHinweisDruckerEinstellen();
            } else {
                String string = PM_MSG.getMsg("winPrtMsgError");
                JOptionPane.showConfirmDialog(this, string, "Error", -1, 0);
                return;
            }
        }
    }

    private void selectPrinter() {
        this.allSystemPrinter.init(this.pmPrinter, this.paperFormat);
        this.setBildFormatListe(this.paperFormat);
        this.maxPapierBereich.setText(this.paperFormat.getAbmessungPapierBereich());
        this.doRepaint();
    }
}

