/*
 * Decompiled with CFR 0.152.
 */
package pm.print;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.print.PrinterJob;
import java.util.List;
import java.util.Vector;
import javax.print.PrintService;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import pm.gui.PM_IndexView;
import pm.gui.PM_PictureView;
import pm.gui.PM_WindowBase;
import pm.gui.PM_WindowMain;
import pm.inout.PM_All_InitValues;
import pm.print.PM_AllSystemPrinter;
import pm.print.PM_PaperFormat;
import pm.print.PM_PictureFormat;
import pm.print.PM_PictureFormatCollection;
import pm.print.PM_PicturePrint;
import pm.print.PM_PmPrinter;
import pm.print.PM_SystemPrinter;
import pm.utilities.PM_Action;
import pm.utilities.PM_Configuration;
import pm.utilities.PM_Interface;
import pm.utilities.PM_Listener;
import pm.utilities.PM_MSG;
import pm.utilities.PM_Utils;
import pm.utilities.PM_UtilsGrafik;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PM_WindowPrintUI
extends PM_WindowBase
implements PM_Interface,
MouseListener {
    protected final PM_IndexView indexViewThumbnails;
    protected JPanel windowPaper = null;
    protected PrintService printService = null;
    protected PrinterJob printerJob = null;
    protected PM_PmPrinter pmPrinter = null;
    protected PM_PictureFormat pictureFormat = null;
    protected PM_AllSystemPrinter allSystemPrinter;
    protected PM_Configuration properties;
    protected PM_PaperFormat paperFormat = PM_PaperFormat.getPaperFormat("F1");
    private JButton buttonEinstellen = null;
    private JLabel hinweisDruckerEinstellen = null;
    private JComboBox bildFormatListe = null;
    protected JComboBox listSystemPrinter = null;
    private JComboBox listePmDrucker = null;
    private JComboBox bildBeschriftungsListe = null;
    protected JTextField maxPapierBereich = null;
    protected JCheckBox hilfslinien = null;
    protected float bildschirmAufloesung;
    private JSplitPane splitPane = null;
    private JLabel labelSystemPrinter;
    private JLabel labelPMprinter;
    private JButton buttonPrint;
    private JLabel labelFormat;
    private JLabel labelRemark;
    private JLabel labelPaperArea;
    protected float sliderValue = 0.4f;

    public PM_WindowPrintUI(PM_WindowMain pM_WindowMain, int n) {
        super(pM_WindowMain, n, true);
        this.properties = PM_Configuration.getInstance();
        this.bildschirmAufloesung = this.properties.getMonitorResolution();
        this.indexViewThumbnails = pM_WindowMain.getIndexViewThumbnails();
        this.buildUI();
        this.allSystemPrinter = this.properties.getAllSystemPrinter();
        List<PM_SystemPrinter> list = this.allSystemPrinter.getSystemPrinters();
        if (!list.isEmpty()) {
            this.listSystemPrinter.setModel(new DefaultComboBoxModel<Object>(list.toArray()));
            this.listSystemPrinter.setSelectedItem(list.get(0));
            this.setListPmPrinter(list.get(0));
            this.setHinweisDruckerEinstellen();
            this.setBildFormatListe(PM_PaperFormat.getPaperFormat("F1"));
            this.pictureFormat = (PM_PictureFormat)this.bildFormatListe.getSelectedItem();
        }
        PM_Listener pM_Listener = new PM_Listener(){

            public void actionPerformed(PM_Action pM_Action) {
                PM_WindowPrintUI.this.setMsg();
            }
        };
        PM_MSG.addChangeListener(pM_Listener);
        this.setMsg();
    }

    private void setMsg() {
        this.labelSystemPrinter.setText(PM_MSG.getMsg("winPrtSysPrinter"));
        this.buttonEinstellen.setText(PM_MSG.getMsg("winPrtButtonConfigure"));
        this.labelPMprinter.setText(PM_MSG.getMsg("winPrtPMprinter"));
        this.buttonPrint.setText(PM_MSG.getMsg("winPrtButtonPrint"));
        this.labelFormat.setText(PM_MSG.getMsg("winPrtLabelFormat"));
        this.labelRemark.setText(PM_MSG.getMsg("winPrtLabelRemark"));
        this.labelPaperArea.setText(PM_MSG.getMsg("winPrtLabelPaperArea"));
        this.hilfslinien.setText(PM_MSG.getMsg("winPrtCheckBoxSubLine"));
    }

    @Override
    public boolean requestToChange() {
        return true;
    }

    @Override
    public void closeAlbum() {
    }

    @Override
    public void close() {
        PM_All_InitValues.getInstance().putValueInt(this, "vertical-devider", this.splitPane.getDividerLocation());
    }

    @Override
    public boolean flush() {
        this.getIndexView().removeAllThumbs();
        this.doClear();
        this.doRepaint();
        return true;
    }

    protected void buildUI() {
        this.setBackground(Color.green);
        JScrollPane jScrollPane = new JScrollPane(this.getRightPanel());
        this.splitPane = new JSplitPane(1, this.getLeftPanel(), jScrollPane);
        int n = PM_All_InitValues.getInstance().getValueInt(this, "vertical-devider");
        if (n == 0) {
            n = 100;
        }
        this.splitPane.setDividerLocation(n);
        this.setLayout(new BorderLayout());
        JScrollPane jScrollPane2 = new JScrollPane(this.getUpperPanel());
        this.add((Component)jScrollPane2, "North");
        this.add((Component)this.splitPane, "Center");
    }

    protected void addPictureView(PM_PictureView pM_PictureView) {
    }

    protected void doSetupSystemPrinter() {
    }

    protected void doPrint() {
    }

    protected void setDefaultZooming() {
    }

    protected void doClear() {
    }

    protected void setPaperFormat(PM_PaperFormat pM_PaperFormat) {
    }

    protected void setPictureFormat(PM_PictureFormat pM_PictureFormat) {
    }

    private JPanel getUpperPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setBackground(Color.yellow);
        jPanel.setPreferredSize(new Dimension(0, 100));
        jPanel.setAlignmentX(0.0f);
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        JPanel jPanel2 = new JPanel(new FlowLayout(0));
        JPanel jPanel3 = new JPanel(new FlowLayout(0));
        this.labelSystemPrinter = new JLabel("System Drucker:");
        jPanel2.add(this.labelSystemPrinter);
        this.listSystemPrinter = new JComboBox();
        jPanel2.add(this.listSystemPrinter);
        ItemListener itemListener = new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() != 1) {
                    return;
                }
                Object object = itemEvent.getItem();
                if (object instanceof PM_SystemPrinter) {
                    PM_SystemPrinter pM_SystemPrinter = (PM_SystemPrinter)object;
                    PM_WindowPrintUI.this.setListPmPrinter(pM_SystemPrinter);
                    PM_WindowPrintUI.this.setHinweisDruckerEinstellen();
                }
            }
        };
        this.listSystemPrinter.addItemListener(itemListener);
        this.buttonEinstellen = new JButton("Einstellen");
        jPanel2.add(this.buttonEinstellen);
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = PM_MSG.getMsg("winPrtMsgSelectPrinter");
                JOptionPane.showConfirmDialog(null, string, "Info", -1, 1);
            }
        };
        this.buttonEinstellen.addActionListener(actionListener);
        this.hinweisDruckerEinstellen = new JLabel(" ");
        jPanel2.add(this.hinweisDruckerEinstellen);
        this.labelPMprinter = new JLabel("PM Drucker:");
        jPanel3.add(this.labelPMprinter);
        this.listePmDrucker = new JComboBox();
        jPanel3.add(this.listePmDrucker);
        ItemListener itemListener2 = new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() != 1) {
                    return;
                }
                Object object = itemEvent.getItem();
                if (object instanceof PM_PmPrinter) {
                    PM_WindowPrintUI.this.setPmPrinter((PM_PmPrinter)object);
                }
            }
        };
        this.listePmDrucker.addItemListener(itemListener2);
        JPanel jPanel4 = new JPanel();
        jPanel3.add(jPanel4);
        jPanel4.setLayout(new FlowLayout(0));
        JRadioButton jRadioButton = new JRadioButton("F1");
        JRadioButton jRadioButton2 = new JRadioButton("F2");
        JRadioButton jRadioButton3 = new JRadioButton("F4");
        JRadioButton jRadioButton4 = new JRadioButton("F6");
        jRadioButton.setActionCommand("F1");
        jRadioButton2.setActionCommand("F2");
        jRadioButton3.setActionCommand("F4");
        jRadioButton4.setActionCommand("F6");
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton);
        buttonGroup.add(jRadioButton2);
        buttonGroup.add(jRadioButton3);
        buttonGroup.add(jRadioButton4);
        jPanel4.add(jRadioButton);
        jPanel4.add(jRadioButton2);
        jPanel4.add(jRadioButton3);
        jPanel4.add(jRadioButton4);
        jRadioButton.setSelected(true);
        ActionListener actionListener2 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PM_WindowPrintUI.this.setPaperFormat(PM_PaperFormat.getPaperFormat(actionEvent.getActionCommand()));
                PM_WindowPrintUI.this.doRepaint();
            }
        };
        jRadioButton.addActionListener(actionListener2);
        jRadioButton2.addActionListener(actionListener2);
        jRadioButton3.addActionListener(actionListener2);
        jRadioButton4.addActionListener(actionListener2);
        jPanel.add(jPanel2);
        jPanel.add(jPanel3);
        return jPanel;
    }

    private JPanel getRightPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        JPanel jPanel2 = new JPanel(new FlowLayout(0));
        JPanel jPanel3 = new JPanel(new FlowLayout(0));
        this.buttonPrint = new JButton("drucken");
        jPanel2.add(this.buttonPrint);
        this.buttonPrint.setBackground(Color.red);
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PM_WindowPrintUI.this.doPrint();
            }
        };
        this.buttonPrint.addActionListener(actionListener);
        this.labelFormat = new JLabel("Format:");
        jPanel2.add(this.labelFormat);
        this.bildFormatListe = new JComboBox();
        jPanel2.add(this.bildFormatListe);
        ItemListener itemListener = new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() != 1) {
                    return;
                }
                Object object = itemEvent.getItem();
                if (object instanceof PM_PictureFormat) {
                    PM_WindowPrintUI.this.setPictureFormat((PM_PictureFormat)object);
                }
            }
        };
        this.bildFormatListe.addItemListener(itemListener);
        this.labelRemark = new JLabel("Beschriftung:");
        jPanel2.add(this.labelRemark);
        this.bildBeschriftungsListe = new JComboBox<String>(this.getBildBeschriftungsListe());
        jPanel2.add(this.bildBeschriftungsListe);
        JButton jButton = PM_Utils.getJButon("button_cancel.png");
        jPanel3.add(jButton);
        ActionListener actionListener2 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PM_WindowPrintUI.this.doClear();
                PM_WindowPrintUI.this.doRepaint();
            }
        };
        jButton.addActionListener(actionListener2);
        JButton jButton2 = new JButton("100 %");
        jPanel3.add(jButton2);
        ActionListener actionListener3 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PM_WindowPrintUI.this.setDefaultZooming();
                PM_WindowPrintUI.this.doRepaint();
            }
        };
        jButton2.addActionListener(actionListener3);
        this.labelPaperArea = new JLabel("Papierbereich:");
        jPanel3.add(this.labelPaperArea);
        this.maxPapierBereich = new JTextField("  ");
        this.maxPapierBereich.setEditable(false);
        jPanel3.add(this.maxPapierBereich);
        jPanel3.add(new JLabel("mm"));
        this.hilfslinien = new JCheckBox("Hilfslinien Drucken");
        jPanel3.add(this.hilfslinien);
        JPanel jPanel4 = new JPanel();
        jPanel4.setBackground(Color.yellow);
        jPanel4.setLayout(new BoxLayout(jPanel4, 1));
        jPanel4.add(jPanel2);
        jPanel4.add(jPanel3);
        this.windowPaper = new JPanel(){

            public void paintComponent(Graphics graphics) {
                super.paintComponent(graphics);
                if (PM_WindowPrintUI.this.pmPrinter == null) {
                    return;
                }
                PM_WindowPrintUI.this.windowPaperPaint(graphics);
            }
        };
        this.windowPaper.addMouseListener(this);
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new BorderLayout());
        jPanel5.add((Component)this.windowPaper, "Center");
        jPanel5.add((Component)this.getSliderWindowPaper(), "South");
        JScrollPane jScrollPane = new JScrollPane(jPanel5);
        jPanel.add((Component)jPanel4, "North");
        jPanel.add((Component)jScrollPane, "Center");
        return jPanel;
    }

    private JPanel getLeftPanel() {
        JPanel jPanel = new JPanel();
        JScrollPane jScrollPane = new JScrollPane(jPanel);
        jScrollPane.setHorizontalScrollBarPolicy(31);
        jScrollPane.setVerticalScrollBarPolicy(21);
        jPanel.setBackground(Color.yellow);
        jPanel.setLayout(new FlowLayout(0));
        PM_UtilsGrafik.getRightPanelOverThumbs(jPanel);
        this.getIndexView().setAllowGetFromRight(true);
        this.getIndexView().setPopUpDiaShow(true);
        this.getIndexView().setPopUpLoeschen(true);
        this.getIndexView().setPopUpLoeschenAufheben(true);
        this.getIndexView().setPopUpAendern(true);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout());
        jPanel2.add((Component)jScrollPane, "North");
        jPanel2.add((Component)this.indexViewScrollPane, "Center");
        jPanel2.add((Component)this.getIndexView().getSlider(), "South");
        return jPanel2;
    }

    protected void setPmPrinter(PM_PmPrinter pM_PmPrinter) {
    }

    protected void doRepaint() {
        this.windowPaper.repaint();
    }

    protected void setBildFormatListe(PM_PaperFormat pM_PaperFormat) {
        PM_PictureFormatCollection pM_PictureFormatCollection = PM_PictureFormatCollection.getInstance();
        PM_PictureFormat[] pM_PictureFormatArray = pM_PictureFormatCollection.getBildFormate(pM_PaperFormat);
        this.bildFormatListe.removeAllItems();
        for (int i = 0; i < pM_PictureFormatArray.length; ++i) {
            this.bildFormatListe.addItem(pM_PictureFormatArray[i]);
        }
    }

    protected String getDruckerName() {
        PrintService printService = this.printerJob.getPrintService();
        return printService.getName();
    }

    protected void setHinweisDruckerEinstellen() {
    }

    private void setListPmPrinter(PM_SystemPrinter pM_SystemPrinter) {
        if (pM_SystemPrinter == null) {
            return;
        }
        this.listePmDrucker.setModel(new DefaultComboBoxModel<PM_PmPrinter>(pM_SystemPrinter.getAllePmDrucker()));
        Object object = this.listePmDrucker.getSelectedItem();
        if (object instanceof PM_PmPrinter) {
            this.setPmPrinter((PM_PmPrinter)object);
        }
    }

    private void windowPaperPaint(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.translate(20, 20);
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.setToScale(this.sliderValue, this.sliderValue);
        this.hilfslinienAufbereiten(graphics2D, affineTransform);
        PM_PicturePrint[] pM_PicturePrintArray = this.pmPrinter.getAlleBilder();
        for (int i = 0; i < pM_PicturePrintArray.length; ++i) {
            PM_PicturePrint pM_PicturePrint = pM_PicturePrintArray[i];
            if (pM_PicturePrint.isEmpty()) continue;
            this.einBildAufbereiten(graphics2D, pM_PicturePrint, affineTransform);
        }
    }

    public boolean hilfslinienDrucken() {
        return this.hilfslinien.isSelected();
    }

    public void hilfslinienAufbereiten(Graphics2D graphics2D, AffineTransform affineTransform) {
        graphics2D.draw(affineTransform.createTransformedShape(this.pmPrinter.getPapierBereichGesamt()));
        graphics2D.draw(affineTransform.createTransformedShape(this.pmPrinter.getDruckBereichGesamt()));
        List list = this.pmPrinter.getPapierFormat().getHilfsLinien();
        for (Object e : list) {
            if (!(e instanceof Line2D)) continue;
            graphics2D.draw(affineTransform.createTransformedShape((Line2D)e));
        }
    }

    public void einBildAufbereiten(Graphics2D graphics2D, PM_PicturePrint pM_PicturePrint, AffineTransform affineTransform) {
        Cloneable cloneable;
        double d;
        boolean bl;
        Image image = pM_PicturePrint.getImage();
        Rectangle2D rectangle2D = pM_PicturePrint.getDruckBereich();
        Rectangle2D rectangle2D2 = pM_PicturePrint.getCutRectangle();
        double d2 = rectangle2D.getWidth() / rectangle2D.getHeight();
        boolean bl2 = bl = !PM_UtilsGrafik.istSelbeDarstellung(d2, d = rectangle2D2.getWidth() / rectangle2D2.getHeight());
        if (bl) {
            rectangle2D2 = this.getCutRectangleGedreht(image, rectangle2D2);
        }
        rectangle2D = affineTransform.createTransformedShape(rectangle2D).getBounds();
        rectangle2D2 = affineTransform.createTransformedShape(rectangle2D2).getBounds();
        AffineTransform affineTransform2 = new AffineTransform();
        affineTransform2.translate(rectangle2D.getX(), rectangle2D.getY());
        double d3 = rectangle2D.getWidth() / rectangle2D2.getWidth();
        affineTransform2.scale(d3, d3);
        affineTransform2.translate(-rectangle2D2.getX(), -rectangle2D2.getY());
        affineTransform2.concatenate(affineTransform);
        if (bl) {
            cloneable = PM_UtilsGrafik.getImageSize(image);
            affineTransform2.translate(((Dimension)cloneable).getHeight(), 0.0);
            affineTransform2.rotate(1.5707963267948966);
        }
        cloneable = graphics2D.getClipBounds();
        graphics2D.setClip(rectangle2D);
        graphics2D.drawImage(image, affineTransform2, this);
        String string = pM_PicturePrint.getBeschriftung();
        if (string != null && string.length() != 0) {
            graphics2D.setFont(new Font("Arial", 0, 11));
            graphics2D.setColor(Color.YELLOW);
            graphics2D.drawString(string, (int)(rectangle2D.getX() + 20.0), (int)(rectangle2D.getY() + rectangle2D.getHeight() - 20.0));
        }
        graphics2D.setClip((Shape)((Object)cloneable));
    }

    public JSlider getSliderWindowPaper() {
        ChangeListener changeListener = new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                JSlider jSlider = (JSlider)changeEvent.getSource();
                if (!jSlider.getValueIsAdjusting()) {
                    PM_WindowPrintUI.this.setSliderValue(jSlider.getValue());
                }
            }
        };
        JSlider jSlider = new JSlider(0, 1, 100, 40);
        jSlider.addChangeListener(changeListener);
        return jSlider;
    }

    private void setSliderValue(int n) {
        this.sliderValue = (float)n / 100.0f;
        this.doRepaint();
    }

    public Rectangle2D getCutRectangleGedreht(Image image, Rectangle2D rectangle2D) {
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.translate(PM_UtilsGrafik.getImageSize(image).getHeight(), 0.0);
        affineTransform.rotate(1.5707963267948966);
        return affineTransform.createTransformedShape(rectangle2D).getBounds2D();
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getButton() == 3 && mouseEvent.getClickCount() == 1) {
            PM_PicturePrint[] pM_PicturePrintArray = this.pmPrinter.getAlleBilder();
            AffineTransform affineTransform = new AffineTransform();
            affineTransform.setToScale(this.sliderValue, this.sliderValue);
            for (int i = 0; i < pM_PicturePrintArray.length; ++i) {
                PM_PicturePrint pM_PicturePrint = pM_PicturePrintArray[i];
                if (pM_PicturePrint.isEmpty()) continue;
                Rectangle2D rectangle2D = pM_PicturePrint.getPapierBereich();
                if (!(rectangle2D = affineTransform.createTransformedShape(rectangle2D).getBounds()).contains(mouseEvent.getPoint())) continue;
                this.doPopUp(pM_PicturePrint, mouseEvent);
            }
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    private void doPopUp(final PM_PicturePrint pM_PicturePrint, MouseEvent mouseEvent) {
        JPopupMenu jPopupMenu = new JPopupMenu();
        JMenuItem jMenuItem = new JMenuItem("Bild \u00c4ndern");
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PM_WindowPrintUI.this.windowMain.doBildAendernDrucken(pM_PicturePrint);
            }
        };
        jMenuItem.addActionListener(actionListener);
        jPopupMenu.add(jMenuItem);
        JMenuItem jMenuItem2 = new JMenuItem("Bild L\u00f6schen");
        ActionListener actionListener2 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                pM_PicturePrint.delete();
                PM_WindowPrintUI.this.doRepaint();
            }
        };
        jMenuItem2.addActionListener(actionListener2);
        jPopupMenu.add(jMenuItem2);
        jPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
    }

    private Vector<String> getBildBeschriftungsListe() {
        Vector<String> vector = new Vector<String>();
        vector.add("");
        vector.add("Datum");
        return vector;
    }

    protected String getItemBildBeschriftung() {
        this.bildBeschriftungsListe.getSelectedItem();
        Object object = this.bildBeschriftungsListe.getSelectedItem();
        if (object instanceof String) {
            return (String)object;
        }
        return "";
    }
}

