/*
 * Decompiled with CFR 0.152.
 */
package pm.search;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;
import org.apache.lucene.store.FSDirectory;
import pm.gui.PM_WindowMain;
import pm.picture.PM_MetadataContainer;
import pm.picture.PM_Picture;
import pm.picture.PM_PictureMetadaten;
import pm.search.PM_LuceneDocument;
import pm.utilities.PM_Action;
import pm.utilities.PM_Configuration;
import pm.utilities.PM_Interface;
import pm.utilities.PM_Listener;
import pm.utilities.PM_ListenerX;

public class PM_DatabaseLucene
implements PM_Interface {
    private File luceneDB = null;
    private IndexWriter indexWriter = null;
    private PM_MetadataContainer metaContainer = null;
    private FSDirectory directory;
    private JProgressBar progressionBar = null;
    private PM_Listener metadatenChangeListener;
    private List<PM_Picture> listePictureMetadaten = new ArrayList<PM_Picture>();
    private boolean gesperrt = true;
    private boolean neuErzeugen = false;
    private int mergeFactor = 500;
    private static PM_DatabaseLucene instance = null;
    int anzahlFuerProgressionBar = 0;

    public static PM_DatabaseLucene getInstance() {
        if (instance == null) {
            instance = new PM_DatabaseLucene();
        }
        return instance;
    }

    public void open() {
        String string = "";
        try {
            this.directory = FSDirectory.getDirectory(this.luceneDB.getPath());
        }
        catch (IOException iOException) {
            string = "ERROR: lucene IOException bei getDirectory. ";
            JOptionPane.showConfirmDialog(null, string, "Fehler Lucene", -1, 0);
            System.exit(0);
        }
        try {
            this.indexWriter = new IndexWriter(this.directory, (Analyzer)new StandardAnalyzer(), false);
            this.indexWriter.setMaxMergeDocs(this.mergeFactor);
        }
        catch (IOException iOException) {
            try {
                this.neuErzeugen = true;
                this.indexWriter = new IndexWriter(this.directory, (Analyzer)new StandardAnalyzer(), true);
                this.indexWriter.setMaxMergeDocs(this.mergeFactor);
            }
            catch (IOException iOException2) {
                string = "ERROR: lucene IOException bei open IndexWriter. ";
                JOptionPane.showConfirmDialog(null, string, "Fehler Lucene", -1, 0);
                System.exit(0);
            }
        }
    }

    public void initBatch() {
        String string = "";
        try {
            this.directory = FSDirectory.getDirectory(this.luceneDB.getPath());
        }
        catch (IOException iOException) {
            string = "ERROR: lucene IOException bei getDirectory. ";
            System.out.println(string);
            System.exit(0);
        }
        try {
            this.indexWriter = new IndexWriter(this.directory, (Analyzer)new StandardAnalyzer(), false);
            this.indexWriter.setMaxMergeDocs(this.mergeFactor);
        }
        catch (IOException iOException) {
            try {
                this.neuErzeugen = true;
                this.indexWriter = new IndexWriter(this.directory, (Analyzer)new StandardAnalyzer(), true);
                this.indexWriter.setMaxMergeDocs(this.mergeFactor);
            }
            catch (IOException iOException2) {
                string = "ERROR: lucene IOException bei open IndexWriter. ";
                System.out.println(string);
                System.exit(0);
            }
        }
    }

    public boolean getNeuErzeugen() {
        return this.neuErzeugen;
    }

    public void setNeuErzeugen(boolean bl) {
        this.neuErzeugen = bl;
    }

    public void close() {
        this.flush();
        try {
            this.indexWriter.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void createEintrag(PM_Picture pM_Picture) {
        PM_LuceneDocument pM_LuceneDocument = PM_LuceneDocument.create(pM_Picture);
        if (pM_LuceneDocument != null) {
            this.addDocument(pM_LuceneDocument.getDocument());
        }
    }

    public void flush() {
        if (this.listePictureMetadaten.size() == 0) {
            this.gesperrt = false;
            return;
        }
        this.gesperrt = true;
        this.doFlush();
        this.listePictureMetadaten.clear();
        this.gesperrt = false;
    }

    private void doFlush() {
        Object object;
        int n = 0;
        for (PM_Picture pM_Picture : this.listePictureMetadaten) {
            object = pM_Picture.getFileOriginal().getPath();
            Term term = new Term("id", (String)object);
            try {
                this.indexWriter.deleteDocuments(term);
            }
            catch (IOException iOException) {}
        }
        for (PM_Picture pM_Picture : this.listePictureMetadaten) {
            if (pM_Picture.meta.isInvalid()) {
                ++n;
                continue;
            }
            object = PM_LuceneDocument.create(pM_Picture);
            if (object == null) continue;
            try {
                this.indexWriter.addDocument(((PM_LuceneDocument)object).getDocument());
            }
            catch (IOException iOException) {}
        }
        try {
            this.indexWriter.optimize();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void alleLuceneEintraegeNeuErstellen() {
        this.alleLuceneEintraegeNeuErstellenWithDialog();
    }

    public void alleLuceneEintraegeNeuErstellen(PM_ListenerX pM_ListenerX) {
        this.luceneDBneuErstellen(pM_ListenerX);
    }

    private PM_DatabaseLucene() {
        this.metaContainer = PM_MetadataContainer.getInstance();
        PM_Configuration pM_Configuration = PM_Configuration.getInstance();
        this.luceneDB = pM_Configuration.getFileHomeLuceneDB();
        this.metadatenChangeListener = new PM_Listener(){

            public void actionPerformed(PM_Action pM_Action) {
                if (PM_DatabaseLucene.this.gesperrt) {
                    return;
                }
                if (pM_Action.getObject() instanceof PM_Picture) {
                    PM_Picture pM_Picture = (PM_Picture)pM_Action.getObject();
                    int n = pM_Action.getType();
                    if (!PM_LuceneDocument.isRelevant(n)) {
                        return;
                    }
                    if (!PM_DatabaseLucene.this.listePictureMetadaten.contains(pM_Picture)) {
                        PM_DatabaseLucene.this.listePictureMetadaten.add(pM_Picture);
                    }
                }
            }
        };
        PM_PictureMetadaten.addChangeListener(this.metadatenChangeListener);
    }

    private void addDocument(Document document) {
        try {
            this.indexWriter.addDocument(document);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void alleLuceneEintraegeNeuErstellenWithDialog() {
        JDialog jDialog = new JDialog((Frame)PM_WindowMain.getInstance(), true);
        JPanel jPanel = new JPanel();
        jPanel.setPreferredSize(new Dimension(300, 200));
        jPanel.setLayout(new BorderLayout());
        int n = this.metaContainer.getPictureSizeValid();
        if (n <= 0) {
            return;
        }
        this.progressionBar = new JProgressBar(1, n);
        jPanel.add((Component)this.progressionBar, "North");
        jDialog.getContentPane().add(jPanel);
        jDialog.pack();
        PM_ListenerX pM_ListenerX = new PM_ListenerX(){

            public boolean actionPerformed(PM_Action pM_Action) {
                PM_DatabaseLucene.this.progressionBar.setValue(PM_DatabaseLucene.this.anzahlFuerProgressionBar++);
                return true;
            }
        };
        this.anzahlFuerProgressionBar = 0;
        Indexieren indexieren = new Indexieren(pM_ListenerX, jDialog);
        indexieren.start();
        jDialog.setVisible(true);
    }

    private void luceneDBneuErstellen(PM_ListenerX pM_ListenerX) {
        this.listePictureMetadaten.clear();
        this.gesperrt = true;
        this.luceneDBneuErstellenXXX(pM_ListenerX);
        this.gesperrt = false;
    }

    private void luceneDBneuErstellenXXX(PM_ListenerX pM_ListenerX) {
        try {
            this.indexWriter.close();
            this.indexWriter = new IndexWriter(this.directory, (Analyzer)new StandardAnalyzer(), true);
            this.indexWriter.setMaxMergeDocs(this.mergeFactor);
        }
        catch (IOException iOException) {
            JOptionPane.showConfirmDialog(null, "FEHLER: Lucene-DB kann nicht neu  erstellt werden", "Fehler LuceneDB", -1, 0);
            return;
        }
        Date date = new Date();
        this.listePictureMetadaten.clear();
        this.metaContainer.flush();
        this.metaContainer.alleLuceneEintraegeNeuErstellen(pM_ListenerX);
        Date date2 = new Date();
        int n = 0;
        try {
            this.indexWriter.optimize();
            n = this.indexWriter.docCount();
        }
        catch (IOException iOException) {
            System.exit(0);
        }
        long l = date2.getTime() - date.getTime();
        System.out.println("======================================================");
        System.out.println("Lucene DB neu indexiert. Anzahl Eintraege = " + n);
        System.out.println("                         Dauer = " + l + " Millisekunden");
        System.out.println("                         Pfad = " + this.luceneDB.getPath());
        System.out.println("======================================================");
    }

    private class Indexieren
    extends Thread {
        private PM_ListenerX listener;
        private JDialog dialog;

        public Indexieren(PM_ListenerX pM_ListenerX, JDialog jDialog) {
            this.listener = pM_ListenerX;
            this.dialog = jDialog;
        }

        public void run() {
            PM_DatabaseLucene.this.luceneDBneuErstellen(this.listener);
            if (this.dialog != null) {
                this.dialog.dispose();
            }
        }
    }
}

