/*
 * Decompiled with CFR 0.152.
 */
package pm.sequence;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import pm.picture.PM_Picture;
import pm.sequence.PM_Sequence;
import pm.sequence.PM_TreeModelNew;
import pm.utilities.PM_Configuration;
import pm.utilities.PM_Interface;
import pm.utilities.PM_MSG;
import pm.utilities.PM_Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PM_SequenceNew
extends PM_Sequence {
    private List<PM_Picture> pictureList;

    public PM_SequenceNew(String string, String string2) {
        this.initPath = string;
        this.shortName = string2;
        this.numberOfShortName = this.getSequenceNumberFromName(string2);
        this.longName = this.getLongNameFromInitPath(string);
    }

    public PM_SequenceNew(String string, List<PM_Picture> list) {
        this.pictureList = list;
        this.initPath = string;
        this.longName = this.getLongNameFromInitPath(string);
        this.makeSequence();
    }

    @Override
    public boolean makeSequence() {
        if (this.pictureList != null) {
            this.numberOfShortName = PM_SequenceNew.getNextFreeSequenceNumber();
            this.shortName = this.getSequenceCharacter() + this.numberOfShortName;
            this.newPictureChain(this.pictureList);
            this.pictureList = null;
            return true;
        }
        return false;
    }

    @Override
    public List<PM_Sequence> getSequenceList() {
        return PM_TreeModelNew.getInstance().getSequenceList();
    }

    @Override
    public String getSequenceCharacter() {
        return "n";
    }

    @Override
    public File getTextFile() {
        return new File(PM_Configuration.getInstance().getSequencesDirNew(), "???.txt");
    }

    @Override
    public List<PM_Picture> getAlleBilder() {
        return this.getPictureListFromLucene();
    }

    public String toString() {
        String string = this.getLongName() + "  ";
        Long l = System.currentTimeMillis();
        try {
            l = new Long(this.initPath);
            if (PM_Utils.isToDay(l)) {
                Date date = new Date(l);
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("HH:mm");
                String string2 = "    " + PM_MSG.getMsg("sequNewToDay") + "    ";
                string = string2 + simpleDateFormat.format(date);
            } else {
                Date date = new Date(l);
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd.MM.yyyy HH:mm");
                string = simpleDateFormat.format(date);
            }
        }
        catch (NumberFormatException numberFormatException) {
            string = "ERROR. path = " + this.initPath;
        }
        return string + " (" + this.shortName + ": " + this.toStringBilder(this.getAnzahlBilder()) + ")";
    }

    @Override
    public String getTypeString() {
        return "Neue Bilder";
    }

    @Override
    public PM_Interface.SequenceType getSequenceType() {
        return PM_Interface.SequenceType.NEW;
    }
}

