/*
 * Decompiled with CFR 0.152.
 */
package pm.sequence;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceContext;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import pm.gui.PM_WindowBase;
import pm.inout.PM_SequencesInout;
import pm.picture.PM_Picture;
import pm.sequence.PM_Sequence;
import pm.sequence.PM_SequenceAlbum;
import pm.sequence.PM_SequenceBase;
import pm.sequence.PM_SequenceExtended;
import pm.sequence.PM_TreeModel;
import pm.sequence.PM_TreeWindow;
import pm.sequence.PM_TreeWindowAlbum;
import pm.sequence.PM_TreeWindowBase;
import pm.sequence.PM_TreeWindowExtended;
import pm.utilities.PM_Interface;
import pm.utilities.PM_MSG;
import pm.utilities.PM_Transferable;

public class PM_TreeWindowDragAndDrop
extends PM_TreeWindow
implements PM_Interface,
DragSourceListener,
DropTargetListener,
DragGestureListener {
    static DataFlavor localObjectFlavor;
    static DataFlavor[] supportedFlavors;
    private DragSource dragSource = new DragSource();
    private TreeNode dropTargetNode;
    private int margin = 12;

    public PM_TreeWindowDragAndDrop(PM_WindowBase pM_WindowBase, PM_TreeModel pM_TreeModel) {
        super(pM_WindowBase, pM_TreeModel);
        this.dragSource.createDefaultDragGestureRecognizer(this, 2, this);
        new DropTarget(this, this);
    }

    protected boolean canDrag(TreeNode treeNode) {
        return false;
    }

    private void _dragGestureRecognized(DragGestureEvent dragGestureEvent) {
        Point point = dragGestureEvent.getDragOrigin();
        TreePath treePath = this.getPathForLocation(point.x, point.y);
        if (treePath == null) {
            return;
        }
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
        if (defaultMutableTreeNode.getParent() == null) {
            return;
        }
        if (!this.canDrag(defaultMutableTreeNode)) {
            return;
        }
        ArrayList<Serializable> arrayList = new ArrayList<Serializable>();
        arrayList.add(this);
        arrayList.add(defaultMutableTreeNode);
        PM_Transferable pM_Transferable = new PM_Transferable(arrayList);
        this.dragSource.startDrag(dragGestureEvent, DragSource.DefaultMoveDrop, pM_Transferable, this);
    }

    private void _dragOver(DropTargetDragEvent dropTargetDragEvent) {
        Transferable transferable = dropTargetDragEvent.getTransferable();
        PM_Interface.DragAndDropType dragAndDropType = PM_Transferable.getDragAndDropType(transferable);
        if (dragAndDropType == PM_Interface.DragAndDropType.NEW_SEQUENCE_B_X || dragAndDropType == PM_Interface.DragAndDropType.NEW_SEQUENCE_ALBUM && this instanceof PM_TreeWindowAlbum) {
            Point point = dropTargetDragEvent.getLocation();
            TreePath treePath = this.getPathForLocation(point.x, point.y);
            if (treePath == null) {
                dropTargetDragEvent.rejectDrag();
                return;
            }
            dropTargetDragEvent.acceptDrag(2);
            return;
        }
        DefaultMutableTreeNode defaultMutableTreeNode = this.getSourceNode(transferable);
        JTree jTree = this.getSourceTree(transferable);
        Point point = dropTargetDragEvent.getLocation();
        TreePath treePath = this.getPathForLocation(point.x, point.y);
        if (treePath == null || defaultMutableTreeNode == null || jTree == null) {
            dropTargetDragEvent.rejectDrag();
            return;
        }
        DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)treePath.getLastPathComponent();
        if (jTree instanceof PM_TreeWindowAlbum && this == jTree || jTree instanceof PM_TreeWindowBase && this == jTree || jTree instanceof PM_TreeWindowExtended && this == jTree) {
            if (defaultMutableTreeNode2 == defaultMutableTreeNode) {
                dropTargetDragEvent.rejectDrag();
                return;
            }
            if (defaultMutableTreeNode.getParent() == null || defaultMutableTreeNode2.getParent() == null) {
                dropTargetDragEvent.rejectDrag();
                return;
            }
            if (!this.dragOverMoveSameTree(defaultMutableTreeNode, defaultMutableTreeNode2)) {
                dropTargetDragEvent.rejectDrag();
                return;
            }
            dropTargetDragEvent.acceptDrag(2);
            return;
        }
        if (jTree instanceof PM_TreeWindowAlbum && this instanceof PM_TreeWindowAlbum && this != jTree) {
            dropTargetDragEvent.acceptDrag(2);
            return;
        }
        if ((jTree instanceof PM_TreeWindowExtended || jTree instanceof PM_TreeWindowBase) && this instanceof PM_TreeWindowAlbum) {
            dropTargetDragEvent.acceptDrag(2);
            return;
        }
        dropTargetDragEvent.rejectDrag();
    }

    private void _drop(DropTargetDropEvent dropTargetDropEvent) {
        PM_SequencesInout.getInstance().setChanged(true);
        Transferable transferable = dropTargetDropEvent.getTransferable();
        PM_Interface.DragAndDropType dragAndDropType = PM_Transferable.getDragAndDropType(transferable);
        if (dragAndDropType == PM_Interface.DragAndDropType.NEW_SEQUENCE_B_X) {
            this.dropNewSequence(transferable, dropTargetDropEvent);
        }
        if (dragAndDropType == PM_Interface.DragAndDropType.NEW_SEQUENCE_ALBUM) {
            this.dropNewAlbum(transferable, dropTargetDropEvent);
        }
        DefaultMutableTreeNode defaultMutableTreeNode = this.getSourceNode(transferable);
        JTree jTree = this.getSourceTree(transferable);
        Point point = dropTargetDropEvent.getLocation();
        TreePath treePath = this.getPathForLocation(point.x, point.y);
        if (treePath == null || defaultMutableTreeNode == null || jTree == null) {
            dropTargetDropEvent.dropComplete(false);
            return;
        }
        DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)treePath.getLastPathComponent();
        if (jTree instanceof PM_TreeWindowAlbum && this instanceof PM_TreeWindowAlbum && this != jTree) {
            if (defaultMutableTreeNode.getParent() == null || defaultMutableTreeNode2.getParent() == null) {
                dropTargetDropEvent.dropComplete(false);
                return;
            }
            if (this.dropCopy(defaultMutableTreeNode, defaultMutableTreeNode2, dropTargetDropEvent)) {
                dropTargetDropEvent.dropComplete(true);
                return;
            }
            dropTargetDropEvent.dropComplete(false);
            return;
        }
        if (jTree instanceof PM_TreeWindowAlbum && this == jTree || jTree instanceof PM_TreeWindowBase && this == jTree || jTree instanceof PM_TreeWindowExtended && this == jTree) {
            if (defaultMutableTreeNode.getParent() == null || defaultMutableTreeNode2.getParent() == null) {
                dropTargetDropEvent.dropComplete(false);
                return;
            }
            if (this.dropMove(defaultMutableTreeNode, defaultMutableTreeNode2, dropTargetDropEvent)) {
                dropTargetDropEvent.dropComplete(true);
                return;
            }
            dropTargetDropEvent.dropComplete(false);
            return;
        }
        if ((jTree instanceof PM_TreeWindowExtended || jTree instanceof PM_TreeWindowBase) && this instanceof PM_TreeWindowAlbum) {
            this.dropCopyBaseExtendedToAlbum(defaultMutableTreeNode, defaultMutableTreeNode2, dropTargetDropEvent);
            return;
        }
        dropTargetDropEvent.dropComplete(false);
    }

    private void dropNewSequence(Transferable transferable, DropTargetDropEvent dropTargetDropEvent) {
        int n;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Point point = dropTargetDropEvent.getLocation();
        TreePath treePath = this.getPathForLocation(point.x, point.y);
        if (treePath == null) {
            dropTargetDropEvent.dropComplete(false);
            return;
        }
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
        PM_Sequence pM_Sequence = PM_Transferable.getSequence(transferable);
        if (pM_Sequence == null) {
            dropTargetDropEvent.dropComplete(false);
            return;
        }
        if (pM_Sequence instanceof PM_SequenceBase) {
            object5 = (PM_SequenceBase)pM_Sequence;
            object4 = ((PM_SequenceBase)object5).getPictureList();
            object3 = object4.iterator();
            while (object3.hasNext()) {
                object2 = (PM_Picture)object3.next();
                if (!((PM_Picture)object2).meta.hasBaseSequence()) continue;
                object = PM_MSG.getMsg("winTreeNotUnique");
                n = JOptionPane.showConfirmDialog(null, object, "Sicherheitsabfrage", 0, 3);
                if (n != 1) break;
                dropTargetDropEvent.dropComplete(false);
                return;
            }
        }
        object5 = PM_MSG.getMsg("winTreeNewShortName");
        object4 = "????????";
        object3 = JOptionPane.showInputDialog(object5, (Object)"neu");
        if (object3 == null) {
            dropTargetDropEvent.dropComplete(false);
            return;
        }
        if (!(object3 instanceof String)) {
            object4 = "????????";
        } else {
            object4 = (String)object3;
            object4 = ((String)object4).trim();
        }
        if (!pM_Sequence.makeSequence()) {
            dropTargetDropEvent.dropComplete(false);
            return;
        }
        pM_Sequence.setLongName((String)object4);
        object2 = new DefaultMutableTreeNode(pM_Sequence);
        pM_Sequence.setPath(PM_TreeModel.getPathFromNode((DefaultMutableTreeNode)object2));
        object = (DefaultMutableTreeNode)defaultMutableTreeNode.getParent();
        if (object != null && defaultMutableTreeNode.isLeaf() && defaultMutableTreeNode.getUserObject() instanceof PM_Sequence) {
            n = ((DefaultMutableTreeNode)object).getIndex(defaultMutableTreeNode);
            this.treeModel.insertNodeInto((MutableTreeNode)object2, (MutableTreeNode)object, n);
        } else {
            this.treeModel.insertNodeInto((MutableTreeNode)object2, defaultMutableTreeNode, 0);
            TreePath treePath2 = this.getTreePath(defaultMutableTreeNode);
            if (this.isCollapsed(treePath2)) {
                this.expandPath(treePath2);
            }
        }
        this.treeModel.nodeChanged(this.treeModel.getRootNode());
        dropTargetDropEvent.dropComplete(true);
    }

    private void dropNewAlbum(Transferable transferable, DropTargetDropEvent dropTargetDropEvent) {
        Point point = dropTargetDropEvent.getLocation();
        TreePath treePath = this.getPathForLocation(point.x, point.y);
        if (treePath == null) {
            dropTargetDropEvent.dropComplete(false);
            return;
        }
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
        PM_Sequence pM_Sequence = PM_Transferable.getSequence(transferable);
        if (pM_Sequence == null) {
            dropTargetDropEvent.dropComplete(false);
            return;
        }
        String string = PM_MSG.getMsg("winTreeNewShortName");
        String string2 = "????????";
        String string3 = JOptionPane.showInputDialog(string, (Object)"neu");
        if (string3 == null) {
            dropTargetDropEvent.dropComplete(false);
            return;
        }
        if (!(string3 instanceof String)) {
            string2 = "????????";
        } else {
            string2 = string3;
            string2 = string2.trim();
        }
        pM_Sequence.setLongName(string2);
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(pM_Sequence);
        pM_Sequence.setPath(PM_TreeModel.getPathFromNode(defaultMutableTreeNode2));
        DefaultMutableTreeNode defaultMutableTreeNode3 = (DefaultMutableTreeNode)defaultMutableTreeNode.getParent();
        if (defaultMutableTreeNode3 != null && defaultMutableTreeNode.isLeaf() && defaultMutableTreeNode.getUserObject() instanceof PM_Sequence) {
            int n = defaultMutableTreeNode3.getIndex(defaultMutableTreeNode);
            this.treeModel.insertNodeInto(defaultMutableTreeNode2, defaultMutableTreeNode3, n);
        } else {
            this.treeModel.insertNodeInto(defaultMutableTreeNode2, defaultMutableTreeNode, 0);
            TreePath treePath2 = this.getTreePath(defaultMutableTreeNode);
            if (this.isCollapsed(treePath2)) {
                this.expandPath(treePath2);
            }
        }
        this.treeModel.nodeChanged(this.treeModel.getRootNode());
        dropTargetDropEvent.dropComplete(true);
    }

    private boolean dropMove(DefaultMutableTreeNode defaultMutableTreeNode, DefaultMutableTreeNode defaultMutableTreeNode2, DropTargetDropEvent dropTargetDropEvent) {
        int n;
        Object object;
        if (defaultMutableTreeNode.getUserObject() instanceof PM_Sequence) {
            PM_Sequence pM_Sequence = (PM_Sequence)defaultMutableTreeNode.getUserObject();
            object = PM_TreeModel.getPathFromNode((DefaultMutableTreeNode)defaultMutableTreeNode2.getParent());
            if (((String)object).length() == 0) {
                pM_Sequence.setPath(pM_Sequence.getLongName());
            } else {
                pM_Sequence.setPath((String)object + "." + pM_Sequence.getLongName());
            }
        }
        int n2 = defaultMutableTreeNode.getParent().getIndex(defaultMutableTreeNode);
        this.treeModel.removeNodeFromParent(defaultMutableTreeNode);
        if (defaultMutableTreeNode2.isLeaf() && defaultMutableTreeNode2.getUserObject() instanceof String) {
            object = defaultMutableTreeNode2;
            n = 0;
        } else {
            object = (MutableTreeNode)defaultMutableTreeNode2.getParent();
            n = defaultMutableTreeNode2.getParent().getIndex(defaultMutableTreeNode2);
            if (n2 <= n) {
                ++n;
            }
        }
        this.treeModel.insertNodeInto(defaultMutableTreeNode, (MutableTreeNode)object, n);
        this.setSelectionPath(this.getTreePath(defaultMutableTreeNode));
        return true;
    }

    private boolean dropCopy(DefaultMutableTreeNode defaultMutableTreeNode, DefaultMutableTreeNode defaultMutableTreeNode2, DropTargetDropEvent dropTargetDropEvent) {
        Object object = defaultMutableTreeNode.getUserObject();
        if (object instanceof PM_SequenceAlbum) {
            PM_SequenceAlbum pM_SequenceAlbum = (PM_SequenceAlbum)object;
            PM_SequenceAlbum pM_SequenceAlbum2 = new PM_SequenceAlbum(pM_SequenceAlbum.getLongName());
            pM_SequenceAlbum2.setSeqClosed(pM_SequenceAlbum.getSeqClosed());
            pM_SequenceAlbum2.setIndex(pM_SequenceAlbum2.getIndex());
            pM_SequenceAlbum2.setOrt(pM_SequenceAlbum2.getOrt());
            pM_SequenceAlbum2.setQual(pM_SequenceAlbum2.getQual());
            pM_SequenceAlbum2.setVon(pM_SequenceAlbum2.getVon());
            pM_SequenceAlbum2.setBis(pM_SequenceAlbum2.getBis());
            DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode(pM_SequenceAlbum2);
            if (defaultMutableTreeNode2.isLeaf() && !(defaultMutableTreeNode2.getUserObject() instanceof PM_Sequence)) {
                this.treeModel.insertNodeInto(defaultMutableTreeNode3, defaultMutableTreeNode2, 0);
                dropTargetDropEvent.dropComplete(true);
                return true;
            }
            int n = 0;
            if (defaultMutableTreeNode2.isLeaf()) {
                TreeNode treeNode = defaultMutableTreeNode2.getParent();
                n = treeNode.getIndex(defaultMutableTreeNode2);
                defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode2.getParent();
            } else {
                n = defaultMutableTreeNode2.getChildCount();
            }
            this.treeModel.insertNodeInto(defaultMutableTreeNode3, defaultMutableTreeNode2, n);
            dropTargetDropEvent.dropComplete(true);
            return true;
        }
        dropTargetDropEvent.dropComplete(false);
        return false;
    }

    private void dropCopyBaseExtendedToAlbum(DefaultMutableTreeNode defaultMutableTreeNode, DefaultMutableTreeNode defaultMutableTreeNode2, DropTargetDropEvent dropTargetDropEvent) {
        Object object = defaultMutableTreeNode.getUserObject();
        if (object instanceof PM_SequenceExtended || object instanceof PM_SequenceBase) {
            PM_Sequence pM_Sequence = (PM_Sequence)object;
            String string = PM_TreeModel.getPathFromNode(defaultMutableTreeNode);
            string = string.replaceAll("\\.", " ");
            PM_SequenceAlbum pM_SequenceAlbum = new PM_SequenceAlbum(string);
            pM_SequenceAlbum.setSeqClosed(pM_Sequence);
            DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode(pM_SequenceAlbum);
            if (defaultMutableTreeNode2.isLeaf() && !(defaultMutableTreeNode2.getUserObject() instanceof PM_Sequence)) {
                this.treeModel.insertNodeInto(defaultMutableTreeNode3, defaultMutableTreeNode2, 0);
                this.expandPath(this.getTreePath(defaultMutableTreeNode2));
                this.setSelectionPath(this.getTreePath(defaultMutableTreeNode3));
                dropTargetDropEvent.dropComplete(false);
                return;
            }
            int n = 0;
            if (defaultMutableTreeNode2.isLeaf()) {
                TreeNode treeNode = defaultMutableTreeNode2.getParent();
                n = treeNode.getIndex(defaultMutableTreeNode2);
                defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode2.getParent();
            } else {
                n = defaultMutableTreeNode2.getChildCount();
            }
            this.treeModel.insertNodeInto(defaultMutableTreeNode3, defaultMutableTreeNode2, n);
            this.setSelectionPath(this.getTreePath(defaultMutableTreeNode3));
            dropTargetDropEvent.dropComplete(true);
            return;
        }
        dropTargetDropEvent.dropComplete(false);
    }

    private boolean dragOverMoveSameTree(DefaultMutableTreeNode defaultMutableTreeNode, DefaultMutableTreeNode defaultMutableTreeNode2) {
        for (TreeNode treeNode = defaultMutableTreeNode2.getParent(); treeNode != null; treeNode = treeNode.getParent()) {
            if (treeNode != defaultMutableTreeNode) continue;
            return false;
        }
        return true;
    }

    private DefaultMutableTreeNode getSourceNode(Transferable transferable) {
        List list;
        Object e;
        Object object;
        try {
            object = transferable.getTransferData(localObjectFlavor);
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
            return null;
        }
        catch (IOException iOException) {
            return null;
        }
        if (object instanceof List && (e = (list = (List)object).get(1)) instanceof TreeNode) {
            return (DefaultMutableTreeNode)e;
        }
        return null;
    }

    private JTree getSourceTree(Transferable transferable) {
        List list;
        Object e;
        Object object;
        try {
            object = transferable.getTransferData(localObjectFlavor);
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
            return null;
        }
        catch (IOException iOException) {
            return null;
        }
        if (object instanceof List && (e = (list = (List)object).get(0)) instanceof JTree) {
            return (JTree)e;
        }
        return null;
    }

    public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
        this._dragGestureRecognized(dragGestureEvent);
    }

    public void dragDropEnd(DragSourceDropEvent dragSourceDropEvent) {
    }

    public void dragEnter(DragSourceDragEvent dragSourceDragEvent) {
        DragSourceContext dragSourceContext = dragSourceDragEvent.getDragSourceContext();
        dragSourceContext.setCursor(DragSource.DefaultMoveDrop);
    }

    public void dragExit(DragSourceEvent dragSourceEvent) {
        DragSourceContext dragSourceContext = dragSourceEvent.getDragSourceContext();
        dragSourceContext.setCursor(DragSource.DefaultMoveNoDrop);
    }

    public void dragOver(DragSourceDragEvent dragSourceDragEvent) {
    }

    public void dropActionChanged(DragSourceDragEvent dragSourceDragEvent) {
    }

    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
        dropTargetDragEvent.acceptDrag(2);
    }

    public void dragExit(DropTargetEvent dropTargetEvent) {
    }

    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
        this._dragOver(dropTargetDragEvent);
    }

    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        this._drop(dropTargetDropEvent);
    }

    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
    }

    public void autoscroll(Point point) {
        int n = this.getRowForLocation(point.x, point.y);
        Rectangle rectangle = this.getBounds();
        n = point.y + rectangle.y <= this.margin ? (n < 1 ? 0 : n - 1) : (n < this.getRowCount() - 1 ? n + 1 : n);
        this.scrollRowToVisible(n);
    }

    public Insets getAutoscrollInsets() {
        Rectangle rectangle = this.getBounds();
        Rectangle rectangle2 = this.getParent().getBounds();
        Insets insets = new Insets(rectangle2.y - rectangle.y + this.margin, rectangle2.x - rectangle.x + this.margin, rectangle.height - rectangle2.height - rectangle2.y + rectangle.y + this.margin, rectangle.width - rectangle2.width - rectangle2.x + rectangle.x + this.margin);
        return insets;
    }

    static {
        try {
            localObjectFlavor = new DataFlavor("application/x-java-jvm-local-objectref");
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
        }
        supportedFlavors = new DataFlavor[]{localObjectFlavor};
    }

    class DnDTreeCellRenderer
    extends DefaultTreeCellRenderer {
        private boolean isTargetNode;
        private boolean isTargetNodeLeaf;

        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            this.isTargetNode = object == PM_TreeWindowDragAndDrop.this.dropTargetNode;
            this.isTargetNodeLeaf = this.isTargetNode && ((TreeNode)object).isLeaf();
            return super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
        }

        public void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            if (this.isTargetNode) {
                graphics.setColor(Color.black);
                if (this.isTargetNodeLeaf) {
                    graphics.drawLine(0, 0, this.getSize().width, 0);
                } else {
                    graphics.drawRect(0, 0, this.getSize().width - 1, this.getSize().height - 1);
                }
            }
        }
    }
}

