/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JTextPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;

public class IconToolBar
extends JToolBar {
    public static final int LOGO_SPACING = 3;
    public static final int LOGO_PADDING = 2;
    ImageIcon logoIcon;
    boolean paintLogo;

    public IconToolBar(URL uRL) {
        this.logoIcon = new ImageIcon(uRL);
    }

    public void validateTree() {
        super.validateTree();
        this.updatePaintingLogo();
    }

    public void updatePaintingLogo() {
        Dimension dimension = this.getSize();
        Dimension dimension2 = new Dimension();
        Component[] componentArray = this.getComponents();
        int n = 0;
        while (n < componentArray.length) {
            dimension2.setSize((int)(Math.max(dimension2.getWidth(), componentArray[n].getBounds().getX() + componentArray[n].getBounds().getWidth()) + 0.5), (int)(dimension2.getHeight() + 0.5));
            ++n;
        }
        double d = dimension.getHeight() / (double)this.logoIcon.getIconHeight();
        this.paintLogo = dimension.getWidth() - dimension2.getWidth() > (double)((int)(d * (double)this.logoIcon.getIconWidth() + 2.0));
        this.repaint();
    }

    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        if (this.paintLogo) {
            Dimension dimension = this.getSize();
            Image image = this.logoIcon.getImage();
            double d = dimension.getHeight() / (double)image.getHeight(this);
            int n = (int)(dimension.getWidth() - d * (double)image.getWidth(this) + 2.0 - 3.0);
            int n2 = 2;
            int n3 = (int)(dimension.getWidth() - 2.0 - 3.0);
            int n4 = (int)(dimension.getHeight() - 2.0);
            graphics.drawImage(image, n, n2, n3, n4, 0, 0, image.getWidth(this), image.getHeight(this), this);
            graphics.setColor(Color.black);
            graphics.drawRect((int)(dimension.getWidth() - d * (double)image.getWidth(this) + 2.0 - 3.0), 2, (int)(d * (double)image.getWidth(this) - 4.0), (int)(dimension.getHeight() - 4.0));
        }
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame();
        URL uRL = null;
        try {
            uRL = Class.forName("IconToolBar").getClassLoader().getResource("HCIL-logo.gif");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        IconToolBar iconToolBar = new IconToolBar(uRL);
        JToggleButton jToggleButton = new JToggleButton("A");
        iconToolBar.add(jToggleButton);
        jToggleButton.setPreferredSize(new Dimension(40, 40));
        JTextPane jTextPane = new JTextPane();
        jFrame.getContentPane().add(jTextPane);
        jFrame.getContentPane().add((Component)iconToolBar, "North");
        jFrame.setSize(300, 300);
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
        jFrame.show();
    }
}

