/*
 * Decompiled with CFR 0.152.
 */
import edu.umd.cs.jazz.ZCamera;
import edu.umd.cs.jazz.ZSceneGraphObject;
import edu.umd.cs.jazz.event.ZFilteredEventHandler;
import edu.umd.cs.jazz.event.ZMouseEvent;
import edu.umd.cs.jazz.event.ZMouseFilter;
import edu.umd.cs.jazz.util.ZSceneGraphPath;
import java.awt.geom.Point2D;

class ImageEventHandler
extends ZFilteredEventHandler {
    ImagePane imagePane;
    ImageItem singleClickItem = null;
    ZMouseEvent moveEvent = null;

    public ImageEventHandler(ImagePane imagePane, ZSceneGraphObject zSceneGraphObject) {
        super(zSceneGraphObject);
        this.imagePane = imagePane;
    }

    public ZMouseFilter getMouseFilter() {
        if (this.fMouseFilter == null) {
            this.fMouseFilter = new ZMouseFilter();
            this.fMouseFilter.setOrMask(28);
        }
        return this.fMouseFilter;
    }

    public void filteredMouseMoved(ZMouseEvent zMouseEvent) {
        ImageItem imageItem;
        PhotoMesa photoMesa = this.imagePane.photomesa;
        Point2D.Double double_ = new Point2D.Double();
        ZSceneGraphPath zSceneGraphPath = zMouseEvent.getPath();
        PMImage pMImage = (PMImage)zSceneGraphPath.getObject();
        this.moveEvent = zMouseEvent;
        if (pMImage != null && (imageItem = pMImage.getImageItem()) != null) {
            if (imageItem.imageWidth > 0 && imageItem.imageHeight > 0) {
                photoMesa.setStatusBarAuxText(imageItem.getImagePath() + "       (" + imageItem.imageWidth + "x" + imageItem.imageHeight + " pixels)");
            } else {
                photoMesa.setStatusBarAuxText(imageItem.getImagePath());
            }
        }
        ((Point2D)double_).setLocation(zMouseEvent.getX(), zMouseEvent.getY());
        zSceneGraphPath.screenToGlobal(double_);
        this.imagePane.computeHiliteArea(double_);
        this.imagePane.startDelayedHiliteFade();
    }

    public void filteredMousePressed(ZMouseEvent zMouseEvent) {
        ZSceneGraphPath zSceneGraphPath = zMouseEvent.getPath();
        PMImage pMImage = (PMImage)zSceneGraphPath.getObject();
        this.imagePane.setPressObj(pMImage);
        if (zMouseEvent.getClickCount() == 1) {
            this.singleClickItem = pMImage == null ? null : pMImage.getImageItem();
        }
    }

    public void filteredMouseReleased(ZMouseEvent zMouseEvent) {
        ZCamera zCamera = this.imagePane.getCamera();
        if (this.imagePane.eventHandlers.isInteracting()) {
            return;
        }
        if ((zMouseEvent.getModifiers() & 0x10) == 16) {
            if (zMouseEvent.getClickCount() == 1 && !this.imagePane.hiliteEmpty) {
                if (!this.imagePane.singleImageHilite) {
                    this.imagePane.magnificationPush();
                    this.imagePane.interruptableZoom = true;
                    this.imagePane.center(this.imagePane.getHiliteBounds());
                    this.filteredMouseMoved(this.moveEvent);
                    zMouseEvent.consume();
                }
            } else if (zMouseEvent.getClickCount() == 2 && this.singleClickItem != null) {
                if (this.imagePane.hiresImageLoaded && this.singleClickItem != this.imagePane.hiresImageItem) {
                    this.imagePane.unloadHiResImage();
                }
                if (this.singleClickItem != this.imagePane.hiresImageItem) {
                    this.imagePane.showHiResImage(this.singleClickItem);
                }
                zMouseEvent.consume();
            }
        } else if (((zMouseEvent.getModifiers() & 4) != 4 || !this.imagePane.photomesa.state.getRightButtonMenu() && this.imagePane.eventHandlers.getEventMode() != 2) && (zMouseEvent.getModifiers() & 4) == 4 && !this.imagePane.hiresImageLoaded) {
            if (zMouseEvent.getClickCount() > 1) {
                this.imagePane.zoomOut();
            } else {
                this.imagePane.zoomOutStep();
            }
            this.imagePane.setFocus(this.moveEvent);
        }
    }
}

