/*
 * Decompiled with CFR 0.152.
 */
import edu.umd.cs.jazz.ZCamera;
import edu.umd.cs.jazz.ZDrawingSurface;
import edu.umd.cs.jazz.ZGroup;
import edu.umd.cs.jazz.ZLayerGroup;
import edu.umd.cs.jazz.ZVisualLeaf;
import edu.umd.cs.jazz.component.ZBasicVisualComponent;
import edu.umd.cs.jazz.component.ZPolygon;
import edu.umd.cs.jazz.component.ZRectangle;
import edu.umd.cs.jazz.component.ZShape;
import edu.umd.cs.jazz.util.ZCanvas;
import edu.umd.cs.jazz.util.ZScrollPane;
import java.awt.AWTEvent;
import java.awt.ActiveEvent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.MenuComponent;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileSystemView;
import javax.swing.tree.TreePath;

public class PhotoMesa
extends JFrame {
    static final String VERSION = "1.3";
    static final int WINDOW_WIDTH = 1024;
    static final int WINDOW_HEIGHT = 720;
    static final int PREFERENCE_PANEL_WIDTH = 255;
    static final int[] THUMB_WIDTHS = new int[]{20, 50, 100, 200};
    static final double[] THUMB_MAGS = new double[]{1.0, 2.5, 5.0, 10.0};
    static final double THUMB_ASPECT_RATIO = 1.5;
    static final int THUMB_PEN_WIDTH = 1;
    static final int ANIMATION_TIME = 750;
    static final int MAX_ANIMATION_TIME = 2000;
    static final double ANIMATION_SPEED = 1.0;
    static final double SEARCH_AREA = 0.3;
    static final int DELAY_TIME = 2000;
    static final int PREVIEW_DWELL_TIME = 400;
    static final int PREVIEW_GROW_TIME = 100;
    static final int MIN_MOVEMENT = 5;
    static final Color SELECTION_COLOR = Color.blue;
    static final Color BORDER_COLOR = new Color(128, 128, 128);
    static final double BORDER_WIDTH = 2.0;
    static final int SELECTION_BORDER_WIDTH = 5;
    static final Color HILITE_PEN_COLOR = new Color(0.8f, 0.2f, 0.0f);
    static final Color HILITE_FILL_COLOR = null;
    static final int HILITE_FADE_TIME = 500;
    static final double HILITE_PEN_WIDTH = 7.0;
    static final int EXPORT_IMAGE_SIZE = 600;
    static final boolean EXPORT_IMAGE_SIZE_ENABLED = true;
    static final float JPEG_ENCODE_QUALITY = 0.5f;
    static final double GROUP_PADDING = 0.6;
    static final int IMAGE_PADDING = 2;
    static final int FEATHER_DEPTH = 5;
    static final boolean SHOW_LABELS = true;
    static final Color[] REGION_COLORS = new Color[]{new Color(255, 255, 255), new Color(220, 255, 255), new Color(255, 220, 255), new Color(255, 255, 190), new Color(220, 220, 255), new Color(220, 255, 190), new Color(255, 220, 190)};
    static final String COLOR_FILENAME = "photomesa-group-color";
    static final String THUMBS_DIRECTORY_FILENAME = ".photomesa-thumbs";
    static final String CONTROL_FILE_NAMES = "thumbs .xvpics";
    static final boolean TWO_LEVEL_NAMES = false;
    static final String SAFE_TO_DELETE_FILENAME = "SAFE-TO-DELETE-THIS-DIRECTORY.txt";
    static final double COLOR_BALANCE = 0.0;
    static final boolean RIGHT_BUTTON_MENU = false;
    static final boolean ASKING_BEFORE_DELETE = true;
    static final boolean LOCAL_THUMBNAILS = false;
    static final String THUMB_BASE_DIR = System.getProperties().getProperty("user.home");
    static final String DEFAULT_IMAGE_EDITOR = "";
    static final int SORT_BY_DATE = 1;
    static final int SORT_BY_NAME = 2;
    static final int SORT_BY_COLOR = 3;
    static final int GROUP_BY_DIRECTORY = 1;
    static final int GROUP_BY_YEAR = 2;
    static final int GROUP_BY_MONTH = 3;
    static final int GROUP_BY_FILENAME_WORDS = 4;
    static final int LAYOUT_BY_QUANTUM_TREEMAP = 1;
    static final int LAYOUT_BY_RECTANGULAR_BUBBLEMAP = 2;
    static final int LAYOUT_BY_COLUMN = 3;
    static final int PREVIEW_NO = 0;
    static final int PREVIEW_IMMEDIATE = 1;
    static final int PREVIEW_TOOLTIP = 2;
    static final int PREVIEW_DELAYED = 3;
    static final int TOOLTIP_OFFSET = 16;
    static final boolean DEBUG = false;
    static Image iconImage;
    static Cursor handCursor;
    static PhotoMesaSplash splash;
    static Font font;
    Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
    JSplitPane leftSplitPane;
    JSplitPane rightSplitPane;
    SelectionPane selectionPane;
    JToolBar toolBar;
    JTabbedPane tabbedPane;
    JTree fileTree;
    ImagePane imagePane;
    JLabel statusBar;
    ImageDragSource imageDragSource;
    ImageDropTarget imageDropTarget;
    String appDir;
    boolean openSubdirectories = true;
    String statusBarMainText = new String();
    String statusBarAuxText = new String();
    QuantumStripTreemap qt = null;
    BubbleMap bm = null;
    JList titleList = null;
    JTextField searchText = null;
    State state = null;
    Hashtable imageItemTable = null;
    ZScrollPane imageScrollPane = null;
    int columnWidth = 0;
    boolean showSpeed = false;
    boolean interrupted = false;
    Vector regions = null;
    Vector origRegions = null;
    private boolean loading = false;

    public PhotoMesa() {
        super("PhotoMesa");
        System.setSecurityManager(null);
        this.appDir = System.getProperties().getProperty("user.home");
        if (System.getProperty("SUH") != null && System.getProperty("SUH").equalsIgnoreCase("true")) {
            this.appDir = "c:";
        }
        this.state = State.restore(this);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Rectangle rectangle = new Rectangle(0, 0, (int)dimension.getWidth(), (int)dimension.getHeight());
        if (!rectangle.contains(this.state.getWindowBounds())) {
            this.state.setWindowBounds(rectangle);
        }
        this.setBounds(this.state.getWindowBounds());
        URL uRL = this.getClass().getClassLoader().getResource("resources/photomesa-logo.gif");
        iconImage = Toolkit.getDefaultToolkit().createImage(uRL);
        this.setIconImage(iconImage);
        URL uRL2 = this.getClass().getClassLoader().getResource("resources/hand.gif");
        ImageIcon imageIcon = new ImageIcon(uRL2);
        Image image = imageIcon.getImage();
        handCursor = Toolkit.getDefaultToolkit().createCustomCursor(image, new Point(8, 8), "none");
        this.regions = new Vector();
        this.origRegions = new Vector();
        this.imageItemTable = new Hashtable();
        this.setJMenuBar(new MenuBar(this));
        this.toolBar = this.createToolBar();
        this.statusBar = new JLabel(" ");
        this.statusBar.setForeground(Color.black);
        this.imagePane = new ImagePane(this);
        this.fileTree = new FileTree(this);
        this.titleList = new JList();
        this.titleList.setSelectionMode(0);
        JLabel jLabel = new JLabel("Search: ");
        jLabel.setForeground(Color.black);
        this.searchText = new JTextField(15);
        this.searchText.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PhotoMesa.this.searchGo();
            }
        });
        JButton jButton = new JButton("Go");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PhotoMesa.this.searchGo();
            }
        });
        JButton jButton2 = new JButton("Reset");
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PhotoMesa.this.searchReset();
            }
        });
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jPanel.setLayout(gridBagLayout);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.gridheight = 3;
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 1;
        gridBagLayout.setConstraints(this.searchText, gridBagConstraints);
        gridBagConstraints.gridwidth = 1;
        gridBagLayout.setConstraints(jButton, gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(jButton2, gridBagConstraints);
        jPanel.add(jLabel);
        jPanel.add(this.searchText);
        jPanel.add(jButton);
        jPanel.add(jButton2);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(2, 1));
        jPanel2.add((Component)jPanel, "North");
        jPanel2.add((Component)this.titleList, "Center");
        JScrollPane jScrollPane = new JScrollPane(jPanel2);
        jScrollPane.setMinimumSize(new Dimension(0, 0));
        this.imageScrollPane = new ZScrollPane(this.imagePane);
        this.imageScrollPane.setMinimumSize(new Dimension(100, 100));
        if (this.state.getLayoutType() == 3) {
            this.imageScrollPane.setHorizontalScrollBarPolicy(31);
            this.imageScrollPane.setVerticalScrollBarPolicy(22);
        } else {
            this.imageScrollPane.setHorizontalScrollBarPolicy(31);
            this.imageScrollPane.setVerticalScrollBarPolicy(21);
        }
        JScrollPane jScrollPane2 = new JScrollPane(this.fileTree);
        this.selectionPane = new SelectionPane(this);
        this.tabbedPane = new JTabbedPane();
        this.tabbedPane.setMinimumSize(new Dimension(0, 0));
        this.tabbedPane.addTab("Files", jScrollPane2);
        this.tabbedPane.addTab("Search", jScrollPane);
        this.tabbedPane.addTab("Selection", this.selectionPane);
        this.leftSplitPane = new JSplitPane(1, false, this.tabbedPane, this.imageScrollPane);
        this.leftSplitPane.setMinimumSize(new Dimension(100, 100));
        this.leftSplitPane.setOneTouchExpandable(true);
        this.leftSplitPane.setDividerLocation(0);
        Preferences preferences = Preferences.getPrefs(this);
        this.rightSplitPane = new JSplitPane(1, false, this.leftSplitPane, preferences);
        this.rightSplitPane.setResizeWeight(1.0);
        this.rightSplitPane.setOneTouchExpandable(true);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.toolBar, "North");
        this.getContentPane().add((Component)this.rightSplitPane, "Center");
        this.getContentPane().add((Component)this.statusBar, "South");
        this.setVisible(true);
        this.setPrefsVisible(false);
        this.imageDragSource = new ImageDragSource(this);
        this.imageDropTarget = new ImageDropTarget(this);
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public void run() {
                PhotoMesa.this.state.setWindowBounds(PhotoMesa.this.getBounds());
                PhotoMesa.this.state.save(PhotoMesa.this);
            }
        });
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                PhotoMesa.this.reLayout();
            }
        });
        MouseMotionAdapter mouseMotionAdapter = new MouseMotionAdapter(){

            public void mouseMoved(MouseEvent mouseEvent) {
                Region region;
                JList jList = PhotoMesa.this.titleList;
                int n = jList.locationToIndex(mouseEvent.getPoint());
                jList.setSelectedIndex(n);
                if (n != -1 && (region = (Region)PhotoMesa.this.regions.get(n)) != null) {
                    ImagePane imagePane = PhotoMesa.this.getImagePane();
                    if (imagePane.armedRegion != region) {
                        if (imagePane.armedRegion != null) {
                            imagePane.armedRegion.updateLabel(false);
                            imagePane.armedRegion.setActive(false);
                        }
                        if (region != null) {
                            region.updateLabel(true);
                            region.setActive(true);
                        }
                        imagePane.armedRegion = region;
                    }
                    imagePane.setHiliteBounds(region.getBorder().getParents()[0].getGlobalBounds());
                    PhotoMesa.this.setStatusBarAuxText(region.getDirectory());
                    imagePane.startDelayedHiliteFade();
                }
            }
        };
        MouseAdapter mouseAdapter = new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                JList jList = PhotoMesa.this.titleList;
                int n = jList.locationToIndex(mouseEvent.getPoint());
                if (n != -1) {
                    Region region = (Region)PhotoMesa.this.regions.get(n);
                    if (region != null) {
                        ImagePane imagePane = PhotoMesa.this.getImagePane();
                        if (imagePane.armedRegion != null) {
                            imagePane.setCurrentRegion(imagePane.armedRegion);
                            imagePane.center(imagePane.getHiliteBounds());
                        }
                    }
                } else {
                    PhotoMesa.this.getImagePane().zoomOut();
                }
            }
        };
        KeyAdapter keyAdapter = new KeyAdapter(){

            public void keyReleased(KeyEvent keyEvent) {
                Region region;
                boolean bl = false;
                boolean bl2 = false;
                switch (keyEvent.getKeyCode()) {
                    case 38: 
                    case 40: {
                        bl = true;
                        break;
                    }
                    case 10: {
                        bl2 = true;
                    }
                }
                JList jList = PhotoMesa.this.titleList;
                int n = jList.getSelectedIndex();
                if (n != -1 && (region = (Region)PhotoMesa.this.regions.get(n)) != null) {
                    ImagePane imagePane;
                    if (bl) {
                        imagePane = PhotoMesa.this.getImagePane();
                        if (imagePane.armedRegion != region) {
                            if (imagePane.armedRegion != null) {
                                imagePane.armedRegion.updateLabel(false);
                                imagePane.armedRegion.setActive(false);
                            }
                            if (region != null) {
                                region.updateLabel(true);
                                region.setActive(true);
                            }
                            imagePane.armedRegion = region;
                        }
                        imagePane.setHiliteBounds(region.getBorder().getParents()[0].getGlobalBounds());
                        imagePane.startDelayedHiliteFade();
                    }
                    if (bl2) {
                        imagePane = PhotoMesa.this.getImagePane();
                        if (imagePane.armedRegion != null) {
                            imagePane.setCurrentRegion(imagePane.armedRegion);
                            imagePane.center(imagePane.getHiliteBounds());
                        }
                    }
                }
            }
        };
        this.titleList.addMouseListener(mouseAdapter);
        this.titleList.addMouseMotionListener(mouseMotionAdapter);
        this.titleList.addKeyListener(keyAdapter);
    }

    JToolBar createToolBar() {
        URL uRL = this.getClass().getClassLoader().getResource("resources/hcil-logo-small.gif");
        IconToolBar iconToolBar = new IconToolBar(uRL);
        ButtonGroup buttonGroup = new ButtonGroup();
        uRL = this.getClass().getClassLoader().getResource("resources/hand-button.gif");
        JToggleButton jToggleButton = new JToggleButton(new ImageIcon(uRL), false);
        jToggleButton.setToolTipText("Pan and zoom");
        jToggleButton.setText(null);
        jToggleButton.setPreferredSize(new Dimension(34, 30));
        jToggleButton.setSelected(true);
        buttonGroup.add(jToggleButton);
        iconToolBar.add(jToggleButton);
        jToggleButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PhotoMesa.this.imagePane.eventHandlers.setEventMode(1);
                SwingUtilities.invokeLater(new Runnable(this){
                    private final /* synthetic */ 10 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void run() {
                        10.access$000(this.this$1).imagePane.requestFocus();
                    }
                });
            }

            static /* synthetic */ PhotoMesa access$000(10 var0) {
                return var0.PhotoMesa.this;
            }
        });
        uRL = this.getClass().getClassLoader().getResource("resources/select-button.gif");
        JToggleButton jToggleButton2 = new JToggleButton(new ImageIcon(uRL), false);
        jToggleButton2.setToolTipText("Select");
        jToggleButton2.setText(null);
        jToggleButton2.setPreferredSize(new Dimension(34, 30));
        buttonGroup.add(jToggleButton2);
        iconToolBar.add(jToggleButton2);
        jToggleButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PhotoMesa.this.imagePane.eventHandlers.setEventMode(2);
                SwingUtilities.invokeLater(new Runnable(this){
                    private final /* synthetic */ 12 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void run() {
                        12.access$100(this.this$1).imagePane.requestFocus();
                    }
                });
            }

            static /* synthetic */ PhotoMesa access$100(12 var0) {
                return var0.PhotoMesa.this;
            }
        });
        return iconToolBar;
    }

    static Image getPhotomesaIconImage() {
        return iconImage;
    }

    void setInterrupted(boolean bl) {
        this.interrupted = bl;
    }

    boolean isInterrupted() {
        return this.interrupted;
    }

    void setFilePaneVisible(boolean bl) {
        if (bl) {
            this.tabbedPane.setSelectedIndex(0);
            this.leftSplitPane.resetToPreferredSizes();
        } else {
            this.leftSplitPane.setDividerLocation(0);
        }
    }

    void setSearchPaneVisible(boolean bl) {
        if (bl) {
            this.tabbedPane.setSelectedIndex(1);
            this.leftSplitPane.resetToPreferredSizes();
            this.searchText.requestFocus();
        } else {
            this.leftSplitPane.setDividerLocation(0);
        }
    }

    void setSelectionPaneVisible(boolean bl) {
        if (bl) {
            this.tabbedPane.setSelectedIndex(2);
            this.leftSplitPane.resetToPreferredSizes();
        } else {
            this.leftSplitPane.setDividerLocation(0);
        }
    }

    void setPrefsVisible(boolean bl) {
        if (bl) {
            this.rightSplitPane.setResizeWeight(1.0);
            this.rightSplitPane.resetToPreferredSizes();
        } else {
            this.rightSplitPane.setDividerLocation(1.0);
        }
    }

    void setShowSpeed(boolean bl) {
        this.showSpeed = bl;
    }

    int getNumThumbLevels() {
        return THUMB_WIDTHS.length;
    }

    int getThumbLevel(double d) {
        int n = this.getNumThumbLevels() - 1;
        int n2 = 0;
        while (n2 < this.getNumThumbLevels()) {
            if (d < THUMB_MAGS[n2]) {
                n = n2;
                break;
            }
            ++n2;
        }
        return n;
    }

    String getAppDir() {
        return this.appDir;
    }

    public String getThumbDirectory() {
        String string = this.state.getThumbBaseDir() + File.separator + THUMBS_DIRECTORY_FILENAME;
        return string;
    }

    void clear() {
        this.imagePane.clear(true);
        this.regions.clear();
    }

    void sort() {
        Object[] objectArray = this.regions.toArray();
        switch (this.state.getSortType()) {
            case 1: {
                Arrays.sort(objectArray, new Comparator(){

                    public int compare(Object object, Object object2) {
                        long l;
                        long l2 = ((Region)object).getDate();
                        int n = l2 < (l = ((Region)object2).getDate()) ? -1 : (l2 == l ? 0 : 1);
                        return n;
                    }
                });
                break;
            }
            case 2: {
                Arrays.sort(objectArray, new Comparator(){

                    public int compare(Object object, Object object2) {
                        String string = ((Region)object).getName();
                        String string2 = ((Region)object2).getName();
                        return string.compareToIgnoreCase(string2);
                    }
                });
                break;
            }
        }
        this.regions.clear();
        int n = 0;
        while (n < objectArray.length) {
            this.regions.add(objectArray[n]);
            ++n;
        }
        Iterator iterator = this.regions.iterator();
        while (iterator.hasNext()) {
            Region region = (Region)iterator.next();
            region.sort(this.state.getSortType());
        }
    }

    void setStatusBarMainText(String string) {
        this.statusBarMainText = string;
        this.updateStatusBar();
    }

    void setStatusBarAuxText(String string) {
        this.statusBarAuxText = string;
        this.updateStatusBar();
    }

    void updateStatusBar() {
        this.statusBar.setText(this.statusBarMainText + this.statusBarAuxText);
    }

    void reFeather() {
        if (this.regions == null || this.regions.size() == 0) {
            return;
        }
        Iterator iterator = this.regions.iterator();
        while (iterator.hasNext()) {
            Region region = (Region)iterator.next();
            ZShape zShape = region.getBorder();
            if (!(zShape instanceof Feathered)) continue;
            ((Feathered)((Object)zShape)).updateFeatherDepth();
        }
    }

    void reGroup() {
        int n = 0;
        int n2 = 0;
        Iterator iterator = this.regions.iterator();
        while (iterator.hasNext()) {
            Region region = (Region)iterator.next();
            ++n;
            n2 += region.getNumImages();
        }
        String string = null;
        String string2 = null;
        switch (this.state.getGroupType()) {
            case 1: {
                if (n == 1) {
                    string = "directory";
                    break;
                }
                string = "directories";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                string = n == 1 ? "group" : "groups";
            }
        }
        string2 = n2 == 1 ? "image" : "images";
        this.setTitle("PhotoMesa - " + this.state.getCurrentDirectory().getAbsolutePath() + " (" + n + " " + string + ", " + n2 + " " + string2 + ")");
        this.updateTitleList();
        if (!this.regions.isEmpty()) {
            Cursor cursor = this.getCursor();
            this.setCursor(new Cursor(3));
            Progress progress = new Progress(this, "PhotoMesa");
            progress.setMinimum(0);
            this.sort();
            this.calculateLayout(this.regions);
            this.layoutImages(this.regions);
            if (this.state.getLayoutType() == 3) {
                int n3 = THUMB_WIDTHS.length - 1;
                double d = THUMB_WIDTHS[n3] / THUMB_WIDTHS[0];
                this.imagePane.getCamera().setViewTransform(AffineTransform.getScaleInstance(d, d));
                this.imagePane.updateThumbs(false, progress);
            } else {
                this.imagePane.zoomOut(0, false);
                this.imagePane.updateThumbs(false, progress);
            }
            this.imagePane.updateLabels();
            this.createThumbs(this.regions, progress);
            progress.dispose();
            this.setInterrupted(false);
            this.setCursor(cursor);
        }
    }

    void reLayout() {
        if (this.regions == null || this.regions.size() == 0) {
            return;
        }
        if (this.state.getLayoutType() == 3) {
            this.imageScrollPane.setHorizontalScrollBarPolicy(31);
            this.imageScrollPane.setVerticalScrollBarPolicy(22);
        } else {
            this.imageScrollPane.setHorizontalScrollBarPolicy(31);
            this.imageScrollPane.setVerticalScrollBarPolicy(21);
        }
        Cursor cursor = this.getCursor();
        this.setCursor(new Cursor(3));
        Progress progress = new Progress(this, "PhotoMesa");
        progress.setCursor(new Cursor(3));
        progress.setMinimum(0);
        this.imagePane.clear(false);
        this.calculateLayout(this.regions);
        this.layoutImages(this.regions);
        if (this.state.getLayoutType() == 3) {
            this.imagePane.setHilitePen(HILITE_PEN_COLOR);
            this.imagePane.setHiliteFill(null);
            Iterator iterator = this.regions.iterator();
            while (iterator.hasNext()) {
                Region region = (Region)iterator.next();
                region.setBorderColor(null);
            }
            int n = THUMB_WIDTHS.length - 1;
            double d = THUMB_WIDTHS[n] / THUMB_WIDTHS[0];
            this.imagePane.getCamera().setViewTransform(AffineTransform.getScaleInstance(d, d));
            this.imagePane.updateThumbs(true);
        } else {
            this.imagePane.setHilitePen(HILITE_PEN_COLOR);
            this.imagePane.setHiliteFill(HILITE_FILL_COLOR);
            this.imagePane.zoomOut(0, false);
        }
        this.imagePane.updateLabels();
        this.imagePane.eventHandlers.activateEventHandlers();
        progress.dispose();
        this.setInterrupted(false);
        this.setCursor(cursor);
    }

    void searchGo() {
        String string = this.searchText.getText().toLowerCase();
        this.imagePane.clear(true);
        this.regions = new Vector();
        Iterator iterator = this.origRegions.iterator();
        while (iterator.hasNext()) {
            Region region = (Region)iterator.next();
            Vector<ImageItem> vector = new Vector<ImageItem>();
            boolean bl = false;
            Iterator iterator2 = region.getImageItems().iterator();
            while (iterator2.hasNext()) {
                ImageItem imageItem = (ImageItem)iterator2.next();
                int n = imageItem.getFile().getAbsolutePath().toLowerCase().indexOf(string);
                if (n == -1) continue;
                bl = true;
                vector.add(imageItem);
            }
            if (!bl) continue;
            Region region2 = (Region)region.clone();
            region2.setImageItems(vector);
            this.regions.add(region2);
        }
        this.reGroup();
    }

    void searchReset() {
        this.searchText.setText(DEFAULT_IMAGE_EDITOR);
        this.clear();
        Iterator iterator = this.origRegions.iterator();
        while (iterator.hasNext()) {
            Region region = (Region)iterator.next();
            region.removing = false;
            this.regions.add(region);
        }
        this.reGroup();
    }

    ImageItem getImageItem(File file) {
        return this.getImageItem(file, false);
    }

    ImageItem getImageItem(File file, boolean bl) {
        ImageItem imageItem = (ImageItem)this.imageItemTable.get(file);
        if (imageItem == null) {
            imageItem = new ImageItem(this, file);
            this.imageItemTable.put(file, imageItem);
        }
        if (bl) {
            this.imageItemTable.remove(file);
        }
        return imageItem;
    }

    void createRegionsByDirectory(File file, Progress progress) {
        Object object;
        Vector<File> vector = new Vector<File>();
        Vector<ImageItem> vector2 = new Vector<ImageItem>();
        File[] fileArray = file.listFiles();
        try {
            int n = 0;
            while (n < fileArray.length) {
                if (this.isValidImage(fileArray[n])) {
                    vector2.add(this.getImageItem(fileArray[n]));
                } else if (this.openSubdirectories && fileArray[n].isDirectory() && fileArray[n].getName() != null && !this.isControlledFileName(fileArray[n].getName())) {
                    vector.add(fileArray[n]);
                }
                this.processQueuedEvents();
                ++n;
            }
        }
        catch (InterruptedException interruptedException) {
            this.clear();
            return;
        }
        if (vector2.size() > 0) {
            int n;
            Region region = new Region(this, vector2);
            if (this.state.getTwoLevelNames()) {
                int n2;
                object = file.getAbsolutePath();
                n = ((String)object).substring(0, n2 = ((String)object).lastIndexOf(File.separatorChar)).lastIndexOf(File.separatorChar);
                if (n >= 0) {
                    region.setName(((String)object).substring(n + 1, ((String)object).length()));
                } else {
                    region.setName(file.getName());
                }
            } else {
                region.setName(file.getName());
            }
            region.setDirectory(file.getAbsolutePath());
            region.setDate(file.lastModified());
            object = ((ImageItem)vector2.get(0)).getThumbPath(0);
            object = ((String)object).substring(0, ((String)object).lastIndexOf(File.separatorChar));
            object = (String)object + File.separator + COLOR_FILENAME;
            try {
                FileInputStream fileInputStream = new FileInputStream(new File((String)object));
                ObjectInputStream objectInputStream = new ObjectInputStream(fileInputStream);
                Color color = (Color)objectInputStream.readObject();
                fileInputStream.close();
                region.setColor(color);
            }
            catch (Exception exception) {
                n = (int)(1.0 + Math.floor(Math.random() * (double)(REGION_COLORS.length - 1)));
                this.setRegionColor(region, REGION_COLORS[n]);
            }
            this.regions.add(region);
            progress.setLabel("Searching for images...", file.getName() + " (" + vector2.size() + " images)     ");
        }
        fileArray = null;
        vector2 = null;
        object = vector.iterator();
        while (object.hasNext()) {
            this.createRegionsByDirectory((File)object.next(), progress);
        }
    }

    void createRegionsByDate(File file, Progress progress, int n) {
        Hashtable hashtable = new Hashtable();
        this.createRegionsByDateImpl(hashtable, file, progress, n);
        Iterator iterator = hashtable.values().iterator();
        while (iterator.hasNext()) {
            Vector vector = (Vector)iterator.next();
            String string = (String)vector.get(0);
            vector.remove(0);
            Region region = new Region(this, vector);
            ImageItem imageItem = (ImageItem)vector.get(0);
            region.setName(string);
            region.setDirectory(string);
            region.setDate(imageItem.getFile().lastModified());
            int n2 = (int)(1.0 + Math.floor(Math.random() * (double)(REGION_COLORS.length - 1)));
            region.setColor(REGION_COLORS[n2]);
            this.regions.add(region);
        }
    }

    void createRegionsByDateImpl(Hashtable hashtable, File file, Progress progress, int n) {
        ImageItem imageItem = null;
        Vector<ImageItem> vector = null;
        Vector<File> vector2 = new Vector<File>();
        File[] fileArray = file.listFiles();
        try {
            int n2 = 0;
            while (n2 < fileArray.length) {
                if (this.isValidImage(fileArray[n2])) {
                    imageItem = this.getImageItem(fileArray[n2]);
                    String string = this.getFileDate(fileArray[n2], n);
                    vector = (Vector<ImageItem>)hashtable.get(string);
                    if (vector == null) {
                        vector = new Vector<ImageItem>();
                        vector.add((ImageItem)((Object)string));
                        hashtable.put(string, vector);
                    }
                    vector.add(imageItem);
                } else if (this.openSubdirectories && fileArray[n2].isDirectory() && fileArray[n2].getName() != null && !this.isControlledFileName(fileArray[n2].getName())) {
                    vector2.add(fileArray[n2]);
                }
                this.processQueuedEvents();
                ++n2;
            }
        }
        catch (InterruptedException interruptedException) {
            this.clear();
            return;
        }
        Iterator iterator = vector2.iterator();
        while (iterator.hasNext()) {
            this.createRegionsByDateImpl(hashtable, (File)iterator.next(), progress, n);
        }
    }

    void createRegionsByFilenameWords(File file, Progress progress) {
        Hashtable hashtable = new Hashtable();
        this.createRegionsByFilenameWordsImpl(hashtable, file, progress);
        Iterator iterator = hashtable.values().iterator();
        while (iterator.hasNext()) {
            Vector vector = (Vector)iterator.next();
            String string = (String)vector.get(0);
            vector.remove(0);
            Region region = new Region(this, vector);
            ImageItem imageItem = (ImageItem)vector.get(0);
            region.setName(string);
            region.setDirectory(string);
            region.setDate(imageItem.getFile().lastModified());
            int n = (int)(1.0 + Math.floor(Math.random() * (double)(REGION_COLORS.length - 1)));
            region.setColor(REGION_COLORS[n]);
            this.regions.add(region);
        }
    }

    void createRegionsByFilenameWordsImpl(Hashtable hashtable, File file, Progress progress) {
        ImageItem imageItem = null;
        Vector<Object> vector = null;
        Vector<File> vector2 = new Vector<File>();
        File[] fileArray = file.listFiles();
        try {
            int n = 0;
            while (n < fileArray.length) {
                if (this.isValidImage(fileArray[n])) {
                    String string = fileArray[n].getName();
                    int n2 = string.lastIndexOf(46);
                    if (n2 != -1) {
                        string = string.substring(0, n2);
                    }
                    StringTokenizer stringTokenizer = new StringTokenizer(string, " _-");
                    while (stringTokenizer.hasMoreTokens()) {
                        String string2 = stringTokenizer.nextToken().toLowerCase();
                        try {
                            Integer.parseInt(string2);
                        }
                        catch (NumberFormatException numberFormatException) {
                            if (string2.length() < 3) continue;
                            vector = (Vector<Object>)hashtable.get(string2);
                            if (vector == null) {
                                vector = new Vector<Object>();
                                vector.add(string2);
                                hashtable.put(string2, vector);
                            }
                            imageItem = this.getImageItem(fileArray[n], true);
                            vector.add(imageItem);
                        }
                    }
                } else if (this.openSubdirectories && fileArray[n].isDirectory() && fileArray[n].getName() != null && !this.isControlledFileName(fileArray[n].getName())) {
                    vector2.add(fileArray[n]);
                }
                this.processQueuedEvents();
                ++n;
            }
        }
        catch (InterruptedException interruptedException) {
            this.clear();
            return;
        }
        Iterator iterator = vector2.iterator();
        while (iterator.hasNext()) {
            this.createRegionsByFilenameWordsImpl(hashtable, (File)iterator.next(), progress);
        }
    }

    void updateTitleList() {
        this.titleList.setListData(this.regions);
    }

    void updateLabels(boolean bl) {
        if (this.state.getGroupType() != 1) {
            return;
        }
        Iterator iterator = this.regions.iterator();
        while (iterator.hasNext()) {
            Region region = (Region)iterator.next();
            String string = region.getDirectory();
            int n = string.lastIndexOf(File.separatorChar);
            int n2 = string.substring(0, n).lastIndexOf(File.separatorChar);
            if (bl && n2 >= 0) {
                region.setName(string.substring(n2 + 1, string.length()));
            } else {
                region.setName(string.substring(n + 1, string.length()));
            }
            region.updateLabel();
        }
        this.updateTitleList();
    }

    String getFileDate(File file, int n) {
        String string;
        String[] stringArray = new String[]{"January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"};
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTime(new Date(file.lastModified()));
        if (n == 1) {
            string = Integer.toString(gregorianCalendar.get(1));
        } else {
            int n2 = gregorianCalendar.get(2);
            String string2 = stringArray[n2];
            string = string2 + " " + Integer.toString(gregorianCalendar.get(1));
        }
        return string;
    }

    void createThumbs(Vector vector, Progress progress) {
        Iterator iterator;
        int n;
        ImageItem imageItem;
        Object object;
        Region region;
        Vector<ImageItem> vector2 = new Vector<ImageItem>();
        Vector<ImageItem> vector3 = new Vector<ImageItem>();
        Iterator iterator2 = vector.iterator();
        while (iterator2.hasNext()) {
            region = (Region)iterator2.next();
            Vector vector4 = region.getImageItems();
            object = vector4.iterator();
            block5: while (object.hasNext()) {
                imageItem = (ImageItem)object.next();
                n = this.getNumThumbLevels() - 1;
                while (n >= 0) {
                    File file = new File(imageItem.getThumbPath(n));
                    if (!file.exists()) {
                        vector2.add(imageItem);
                        continue block5;
                    }
                    --n;
                }
            }
        }
        if (vector2.size() > 0) {
            progress.setLabel("Creating " + vector2.size() + " multiresolution image thumbnail(s)...");
            progress.setMaximum(vector2.size());
        }
        n = 0;
        try {
            iterator = vector2.iterator();
            while (iterator.hasNext()) {
                imageItem = (ImageItem)iterator.next();
                progress.setValue(n++);
                try {
                    object = null;
                    int n2 = this.getNumThumbLevels() - 1;
                    while (n2 >= 0) {
                        object = imageItem.createThumbFile(n2, (Image)object);
                        --n2;
                    }
                    imageItem.requestReload();
                    this.imagePane.updateThumb(imageItem);
                    this.imagePane.getDrawingSurface().paintImmediately();
                }
                catch (Exception exception) {
                    vector3.add(imageItem);
                }
                this.processQueuedEvents();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        iterator = vector3.iterator();
        while (iterator.hasNext()) {
            imageItem = (ImageItem)iterator.next();
            region = imageItem.getRegion();
            region.remove(imageItem);
            if (region.getNumImages() != 0) continue;
            vector.remove(region);
        }
    }

    void calculateLayout(Vector vector) {
        if (vector == null || vector.size() == 0) {
            return;
        }
        this.imagePane.getLayer().removeAllChildren();
        Rectangle rectangle = this.imagePane.getBounds();
        Rectangle2D.Double double_ = new Rectangle2D.Double(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        int[] nArray = new int[vector.size()];
        int n = 0;
        Iterator iterator = vector.iterator();
        while (iterator.hasNext()) {
            Region region = (Region)iterator.next();
            nArray[n] = region.getNumImages();
            ++n;
        }
        double d = THUMB_WIDTHS[0] + this.state.getImagePadding();
        double d2 = (double)THUMB_WIDTHS[0] / this.state.getAspectRatio() + (double)this.state.getImagePadding();
        double d3 = d / d2;
        switch (this.state.getLayoutType()) {
            case 1: {
                Rectangle rectangle2 = new Rectangle((int)((RectangularShape)double_).getX(), (int)((RectangularShape)double_).getY(), (int)((RectangularShape)double_).getWidth(), (int)((RectangularShape)double_).getHeight());
                this.qt = new QuantumStripTreemap(nArray, d3, rectangle2);
                this.qt.quantumStripLayout();
                break;
            }
            case 2: {
                Rectangle rectangle3 = new Rectangle((int)((RectangularShape)double_).getX(), (int)((RectangularShape)double_).getY(), (int)((RectangularShape)double_).getWidth(), (int)((RectangularShape)double_).getHeight());
                this.bm = new BubbleMap(nArray, d3, rectangle3);
                this.bm.setLayoutType(2);
                this.bm.bubbleMapLayout();
                break;
            }
            case 3: {
                int n2 = THUMB_WIDTHS.length - 1;
                int n3 = THUMB_WIDTHS[n2] + this.state.getImagePadding() * (THUMB_WIDTHS[n2] / THUMB_WIDTHS[0]);
                this.columnWidth = this.imagePane.getWidth() / n3;
            }
        }
    }

    void layoutImages(Vector vector) {
        if (vector == null || vector.size() == 0) {
            return;
        }
        switch (this.state.getLayoutType()) {
            case 1: {
                Rectangle[] rectangleArray = this.qt.getResult();
                this.layoutStrip(vector, rectangleArray);
                break;
            }
            case 2: {
                Vector vector2 = this.bm.getResult();
                this.layoutBubble(vector, vector2);
                break;
            }
            case 3: {
                this.layoutColumn(vector);
            }
        }
    }

    void layoutStrip(Vector vector, Rectangle[] rectangleArray) {
        ZLayerGroup zLayerGroup = this.imagePane.getBottomLayer();
        double d = 2.0;
        int n = THUMB_WIDTHS[0];
        int n2 = (int)((double)n / this.state.getAspectRatio());
        int n3 = n + this.state.getImagePadding();
        int n4 = n2 + this.state.getImagePadding();
        int n5 = 0;
        Iterator iterator = vector.iterator();
        while (iterator.hasNext()) {
            Region region = (Region)iterator.next();
            region.setLabelPosition(1);
            double d2 = 1.0 - 0.5 * this.state.getGroupPadding();
            if (rectangleArray[n5].width > rectangleArray[n5].height) {
                if (rectangleArray[n5].width > 1) {
                    d2 = ((double)rectangleArray[n5].width - this.state.getGroupPadding()) / (double)rectangleArray[n5].width;
                }
            } else if (rectangleArray[n5].height > 1) {
                d2 = ((double)rectangleArray[n5].height - this.state.getGroupPadding()) / (double)rectangleArray[n5].height;
            }
            CushionRectangle cushionRectangle = new CushionRectangle(this, n3 * rectangleArray[n5].x, n4 * rectangleArray[n5].y, n3 * rectangleArray[n5].width, n4 * rectangleArray[n5].height);
            ZGroup zGroup = this.imagePane.layoutImages(region, rectangleArray[n5].x, rectangleArray[n5].y, rectangleArray[n5].width, rectangleArray[n5].height);
            zGroup.editor().getTransformGroup().scale(d2, 0, this.imagePane.getDrawingSurface());
            zGroup.editor().getTransformGroup().position((Point2D)new Point2D.Double(0.0, 0.0), (Point2D)new Point2D.Double(0.0, 0.0), cushionRectangle.getBounds(), 0, this.imagePane.getDrawingSurface());
            double d3 = 0.5 * (2.0 + (double)this.state.getImagePadding() + zGroup.getBounds().getWidth() * (1.0 - d2));
            double d4 = 0.5 * (2.0 + (double)this.state.getImagePadding() + zGroup.getBounds().getHeight() * (1.0 - d2));
            zGroup.editor().getTransformGroup().translate(d3, d4);
            ((ZRectangle)cushionRectangle).setPenWidth(d);
            ((ZBasicVisualComponent)cushionRectangle).setPenPaint(BORDER_COLOR);
            cushionRectangle.setFillPaint(null);
            ZVisualLeaf zVisualLeaf = new ZVisualLeaf(cushionRectangle);
            zVisualLeaf.setPickable(false);
            zVisualLeaf.setFindable(false);
            zLayerGroup.addChild(zVisualLeaf);
            region.setBorder(cushionRectangle);
            ++n5;
        }
    }

    void layoutBubble(Vector vector, Vector vector2) {
        ZLayerGroup zLayerGroup = this.imagePane.getBottomLayer();
        double d = 2.0;
        int n = THUMB_WIDTHS[0];
        int n2 = (int)((double)n / this.state.getAspectRatio());
        int n3 = n + this.state.getImagePadding();
        int n4 = n2 + this.state.getImagePadding();
        int n5 = 0;
        Iterator iterator = vector.iterator();
        while (iterator.hasNext()) {
            Region region = (Region)iterator.next();
            Vector vector3 = this.bm.getBoundary(n5);
            ZPolygon zPolygon = new ZPolygon();
            Iterator iterator2 = vector3.iterator();
            while (iterator2.hasNext()) {
                Point point = (Point)iterator2.next();
                zPolygon.add(n3 * point.x, (double)(n4 * point.y));
            }
            zPolygon = new CushionPolygon(this, zPolygon);
            zPolygon.setPenWidth(d);
            zPolygon.setPenPaint(BORDER_COLOR);
            zPolygon.setFillPaint(null);
            ZVisualLeaf zVisualLeaf = new ZVisualLeaf(zPolygon);
            zVisualLeaf.setPickable(false);
            zVisualLeaf.setFindable(false);
            zLayerGroup.addChild(zVisualLeaf);
            region.setBorder(zPolygon);
            ZGroup zGroup = this.imagePane.layoutImages(region, (Point[])vector2.get(n5));
            double d2 = 1.0 - 0.5 * this.state.getGroupPadding();
            if (region.numCols > region.numRows) {
                if (region.numCols > 1) {
                    d2 = ((double)region.numCols - this.state.getGroupPadding()) / (double)region.numCols;
                }
            } else if (region.numRows > 1) {
                d2 = ((double)region.numRows - this.state.getGroupPadding()) / (double)region.numRows;
            }
            Point2D point2D = region.getCenterOfMass();
            region.setLabelPosition(2);
            ++n5;
        }
    }

    void layoutColumn(Vector vector) {
        Region region;
        double d = THUMB_WIDTHS[0];
        Rectangle2D[] rectangle2DArray = new Rectangle2D[vector.size()];
        ZDrawingSurface zDrawingSurface = this.imagePane.getDrawingSurface();
        double d2 = this.state.getAspectRatio();
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = THUMB_WIDTHS.length - 1;
        int n5 = this.columnWidth;
        Iterator iterator = vector.iterator();
        while (iterator.hasNext()) {
            region = (Region)iterator.next();
            region.setLabelPosition(1);
            int n6 = (int)Math.ceil((double)region.getNumImages() / (double)n5);
            ZGroup zGroup = this.imagePane.layoutImages(region, n2, n3, n5, n6);
            rectangle2DArray[n] = new Rectangle2D.Double((double)n2 * d, (double)n3 / d2 * d, (double)(n5 + this.state.getImagePadding()) * d, (double)n6 / d2 * d);
            rectangle2DArray[n] = zGroup.getGlobalBounds();
            n3 += n6;
            ++n;
        }
        ZLayerGroup zLayerGroup = this.imagePane.getBottomLayer();
        double d3 = 2.0;
        n = 0;
        Iterator iterator2 = vector.iterator();
        while (iterator2.hasNext()) {
            region = (Region)iterator2.next();
            ZRectangle zRectangle = new ZRectangle(rectangle2DArray[n]);
            zRectangle.setPenWidth(d3);
            zRectangle.setPenPaint(null);
            zRectangle.setFillPaint(null);
            ZVisualLeaf zVisualLeaf = new ZVisualLeaf(zRectangle);
            zVisualLeaf.setPickable(false);
            zVisualLeaf.setFindable(false);
            zLayerGroup.addChild(zVisualLeaf);
            region.setBorder(zRectangle);
            ++n;
        }
    }

    boolean isValidImage(File file) {
        boolean bl = false;
        String string = file.getName().toLowerCase();
        if (string.endsWith(".jpg") || string.endsWith(".jpeg") || string.endsWith(".gif")) {
            bl = true;
        }
        return bl;
    }

    ImageDragSource getImageDragSource() {
        return this.imageDragSource;
    }

    ImagePane getImagePane() {
        return this.imagePane;
    }

    public boolean isControlledFileName(String string) {
        String string2 = ".photomesa-thumbs " + this.state.getControlFileNames();
        StringTokenizer stringTokenizer = new StringTokenizer(string2, " \"", true);
        boolean bl = false;
        boolean bl2 = false;
        String string3 = DEFAULT_IMAGE_EDITOR;
        while (stringTokenizer.hasMoreTokens()) {
            String string4 = stringTokenizer.nextToken();
            if (bl2) {
                if (string4.equals("\"")) {
                    bl2 = false;
                    if (!string.equals(string3)) continue;
                    bl = true;
                    break;
                }
                string3 = string3 + string4;
                continue;
            }
            if (string4.equals("\"")) {
                bl2 = true;
                string3 = DEFAULT_IMAGE_EDITOR;
                continue;
            }
            if (string4.equals(" ") || !string.equals(string4)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    void printStatistics() {
        switch (this.state.getLayoutType()) {
            case 1: {
                this.qt.printStatistics();
            }
        }
    }

    void open() {
        JFileChooser jFileChooser = new JFileChooser(this.state.getCurrentDirectory(), (FileSystemView)new AltFileSystemView());
        jFileChooser.setFileSelectionMode(1);
        jFileChooser.setDialogTitle("Open Image Directory");
        jFileChooser.setSelectedFile(this.state.getCurrentDirectory());
        final JCheckBox jCheckBox = new JCheckBox("Open subdirectories");
        jCheckBox.setSelected(this.openSubdirectories);
        jCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PhotoMesa.this.openSubdirectories = jCheckBox.isSelected();
            }
        });
        jFileChooser.setAccessory(jCheckBox);
        int n = jFileChooser.showOpenDialog(this);
        if (n == 0) {
            File file = jFileChooser.getSelectedFile();
            Vector<Object> vector = new Vector<Object>();
            while (file != null) {
                vector.insertElementAt(file, 0);
                file = file.getParentFile();
            }
            vector.insertElementAt("My Computer", 0);
            Object[] objectArray = vector.toArray();
            TreePath treePath = new TreePath(objectArray);
            this.fileTree.setSelectionPath(treePath);
            this.loadFile(jFileChooser.getSelectedFile());
        }
    }

    private synchronized boolean getLock() {
        if (this.loading) {
            return false;
        }
        this.loading = true;
        return true;
    }

    private void releaseLock() {
        this.loading = false;
    }

    void loadFile(File file) {
        if (!this.getLock()) {
            String[] stringArray = new String[]{"Please try again after cancelling the current loading"};
            JOptionPane.showMessageDialog(this.getImagePane(), stringArray, "PhotoMesa Information", 0);
            return;
        }
        this.state.setCurrentDirectory(file);
        this.imageItemTable.clear();
        this.clear();
        Cursor cursor = this.getCursor();
        this.setCursor(new Cursor(3));
        Progress progress = new Progress(this, "PhotoMesa");
        progress.setMinimum(0);
        switch (this.state.getGroupType()) {
            case 1: {
                this.createRegionsByDirectory(this.state.getCurrentDirectory(), progress);
                break;
            }
            case 2: {
                this.createRegionsByDate(this.state.getCurrentDirectory(), progress, 1);
                break;
            }
            case 3: {
                this.createRegionsByDate(this.state.getCurrentDirectory(), progress, 12);
                break;
            }
            case 4: {
                this.createRegionsByFilenameWords(this.state.getCurrentDirectory(), progress);
            }
        }
        if (this.regions.size() == 0) {
            progress.dispose();
            this.setCursor(cursor);
            if (this.isInterrupted()) {
                String[] stringArray = new String[]{"User interrupts loading images in " + this.state.getCurrentDirectory(), "No image loaded"};
                JOptionPane.showMessageDialog(this.getImagePane(), stringArray, "PhotoMesa Information", 0);
            } else {
                String[] stringArray = new String[]{"No image in " + this.state.getCurrentDirectory(), "No image loaded"};
                JOptionPane.showMessageDialog(this.getImagePane(), stringArray, "PhotoMesa Information", 0);
            }
            this.setInterrupted(false);
            this.origRegions.clear();
            this.releaseLock();
            return;
        }
        this.origRegions.clear();
        Iterator iterator = this.regions.iterator();
        while (iterator.hasNext()) {
            this.origRegions.add((Region)iterator.next());
        }
        progress.dispose();
        this.setInterrupted(false);
        this.setCursor(cursor);
        this.reGroup();
        this.imagePane.requestFocus();
        this.releaseLock();
        File file2 = new File(this.getThumbDirectory() + File.separator + SAFE_TO_DELETE_FILENAME);
        if (!file2.exists()) {
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(file2);
                PrintWriter printWriter = new PrintWriter(fileOutputStream);
                printWriter.println("It is safe to delete this directory and its contents.");
                printWriter.println("This directory was created by PhotoMesa to store temporary files.");
                printWriter.println("Deleting these files will not affect your original images, and any");
                printWriter.println("files in this directory will be recreated as needed by PhotoMesa.");
                printWriter.flush();
                fileOutputStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    void setRegionColor(Color color) {
        Vector vector = this.imagePane.selection;
        Vector<Region> vector2 = new Vector<Region>();
        if (vector.isEmpty()) {
            String[] stringArray = new String[]{"'Set Group Color' sets the background color", "of the groups with selected images.", " ", "There currently are no selected images,", "so no background colors were changed."};
            JOptionPane.showMessageDialog(this.imagePane, stringArray, "PhotoMesa Information", 1);
        } else {
            Iterator iterator = vector.iterator();
            while (iterator.hasNext()) {
                ImageItem imageItem = (ImageItem)iterator.next();
                Region region = imageItem.getRegion();
                if (vector2.contains(region)) continue;
                vector2.add(region);
                this.setRegionColor(region, color);
            }
        }
    }

    void setRegionColor(Region region, Color color) {
        ImageItem imageItem = (ImageItem)region.getImageItems().get(0);
        String string = imageItem.getThumbPath(0);
        string = string.substring(0, string.lastIndexOf(File.separatorChar));
        string = string + File.separator + COLOR_FILENAME;
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(new File(string));
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
            objectOutputStream.writeObject(color);
            objectOutputStream.flush();
            fileOutputStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        region.setColor(color);
    }

    void about() {
        try {
            Rectangle rectangle = this.getBounds();
            JFrame jFrame = new JFrame();
            jFrame.setTitle("About PhotoMesa");
            jFrame.setIconImage(iconImage);
            int n = 600;
            int n2 = 400;
            jFrame.setBounds(rectangle.x + rectangle.width / 2 - n / 2, rectangle.y + rectangle.height / 2 - n2 / 2, n, n2);
            URL uRL = this.getClass().getClassLoader().getResource("resources/about.html");
            JEditorPane jEditorPane = new JEditorPane(uRL);
            jFrame.getContentPane().setLayout(new BorderLayout());
            jFrame.getContentPane().add((Component)new JScrollPane(jEditorPane), "Center");
            jFrame.setVisible(true);
        }
        catch (Exception exception) {
            System.out.println("Can't load about file");
            exception.printStackTrace();
        }
    }

    void help() {
        try {
            Rectangle rectangle = this.getBounds();
            JFrame jFrame = new JFrame();
            jFrame.setTitle("PhotoMesa Help");
            jFrame.setIconImage(iconImage);
            int n = 600;
            int n2 = 600;
            jFrame.setBounds(rectangle.x + rectangle.width / 2 - n / 2, rectangle.y, n, n2);
            URL uRL = this.getClass().getClassLoader().getResource("resources/help.html");
            JEditorPane jEditorPane = new JEditorPane(uRL);
            jFrame.getContentPane().setLayout(new BorderLayout());
            jFrame.getContentPane().add((Component)new JScrollPane(jEditorPane), "Center");
            jFrame.setVisible(true);
        }
        catch (Exception exception) {
            System.out.println("Can't load help file");
            exception.printStackTrace();
        }
    }

    public void fullScreen() {
        final JWindow jWindow = new JWindow(this);
        final ZCanvas zCanvas = new ZCanvas(this.imagePane.getRoot(), new ZLayerGroup());
        Dimension dimension = jWindow.getToolkit().getScreenSize();
        jWindow.setLocation(0, 0);
        jWindow.setSize(dimension);
        jWindow.setBackground(null);
        jWindow.getContentPane().add(zCanvas);
        ZCamera zCamera = zCanvas.getCamera();
        ZLayerGroup[] zLayerGroupArray = this.imagePane.getCamera().getLayers();
        int n = 0;
        while (n < zLayerGroupArray.length) {
            zCamera.addLayer(zLayerGroupArray[n]);
            ++n;
        }
        zCamera.removeLayer(zCanvas.getLayer());
        zCanvas.setLayer(this.imagePane.getLayer());
        jWindow.setVisible(true);
        zCamera.center(this.imagePane.getCamera().getViewBounds(), 0, zCamera.getDrawingSurface());
        zCanvas.setNavEventHandlersActive(false);
        EventHandlers eventHandlers = new EventHandlers(this.imagePane, zCanvas);
        eventHandlers.activateEventHandlers();
        this.imagePane.setActiveCamera(zCamera);
        eventHandlers.setEventMode(this.imagePane.eventHandlers.getEventMode());
        this.imagePane.setFullScreenEventHandlers(eventHandlers);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                zCanvas.requestFocus();
            }
        });
        zCanvas.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 27) {
                    ZLayerGroup[] zLayerGroupArray = zCanvas.getCamera().getLayers();
                    if (keyEvent.isConsumed()) {
                        return;
                    }
                    PhotoMesa.this.imagePane.eventHandlers.fileManipHandler.cancelRename();
                    int n = 0;
                    while (n < zLayerGroupArray.length) {
                        zCanvas.getCamera().removeLayer(zLayerGroupArray[n]);
                        ++n;
                    }
                    PhotoMesa.this.imagePane.setActiveCamera(PhotoMesa.this.imagePane.getCanvasCamera());
                    PhotoMesa.this.imagePane.eventHandlers.activateEventHandlers();
                    jWindow.dispose();
                    PhotoMesa.this.imagePane.resetEventHandlers();
                    SwingUtilities.invokeLater(new Runnable(this){
                        private final /* synthetic */ 18 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        public void run() {
                            18.access$200(this.this$1).imagePane.requestFocus();
                            SwingUtilities.invokeLater(new Runnable(this){
                                private final /* synthetic */ 19 this$2;
                                {
                                    this.this$2 = var1_1;
                                }

                                public void run() {
                                    18.access$200(19.access$300(this.this$2)).imagePane.requestFocus();
                                }
                            });
                        }

                        static /* synthetic */ 18 access$300(19 var0) {
                            return var0.this$1;
                        }
                    });
                }
            }

            static /* synthetic */ PhotoMesa access$200(18 var0) {
                return var0.PhotoMesa.this;
            }
        });
        zCanvas.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseMoved(MouseEvent mouseEvent) {
                zCanvas.requestFocus();
            }
        });
    }

    void delete() {
        this.imagePane.deleteSelectedImages();
    }

    void copy() {
    }

    void paste(Transferable transferable) {
    }

    public void println(String string, Object[] objectArray) {
        System.out.println(MessageFormat.format(string, objectArray));
    }

    public static void main(String[] stringArray) {
        splash = new PhotoMesaSplash();
        final PhotoMesa photoMesa = new PhotoMesa();
        splash.dispose();
        splash = null;
        if (stringArray.length > 0) {
            String string = stringArray[0];
            final File file = new File(string);
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    photoMesa.loadFile(file);
                }
            });
        }
    }

    static File[] getRoots() {
        Object[] objectArray;
        String string = System.getProperties().getProperty("os.name");
        if (string.indexOf("Windows") >= 0) {
            Vector<FileSystemRoot> vector = new Vector<FileSystemRoot>();
            char c = 'C';
            while (c <= 'Z') {
                String string2;
                FileSystemRoot fileSystemRoot;
                char[] cArray = new char[]{c, ':', '\\'};
                if ((System.getProperty("SUH") == null || !System.getProperty("SUH").equalsIgnoreCase("true") || c != 'D') && (fileSystemRoot = new FileSystemRoot(string2 = new String(cArray))) != null && fileSystemRoot.exists()) {
                    vector.addElement(fileSystemRoot);
                }
                c = (char)(c + 1);
            }
            objectArray = new File[vector.size()];
            vector.copyInto(objectArray);
        } else {
            objectArray = File.listRoots();
        }
        return objectArray;
    }

    void processQueuedEvents() throws InterruptedException {
        EventQueue eventQueue = Toolkit.getDefaultToolkit().getSystemEventQueue();
        while (eventQueue.peekEvent() != null) {
            try {
                AWTEvent aWTEvent = eventQueue.getNextEvent();
                Object object = aWTEvent.getSource();
                if (aWTEvent instanceof ActiveEvent) {
                    ((ActiveEvent)((Object)aWTEvent)).dispatch();
                    continue;
                }
                if (object instanceof Component) {
                    ((Component)object).dispatchEvent(aWTEvent);
                    continue;
                }
                if (object instanceof MenuComponent) {
                    ((MenuComponent)object).dispatchEvent(aWTEvent);
                    continue;
                }
                System.err.println("unable to dispatch event: " + aWTEvent);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (this.isInterrupted()) {
            throw new InterruptedException();
        }
    }

    static {
        splash = null;
        font = new Font("Helvetica", 0, 20);
    }
}

